/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.validation;

import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.operator.validation.WrapperValidationChain;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSplitWrapperValidationChain
extends WrapperValidationChain {
    public static final String PARAMETER_SPLIT_RATIO = "split_ratio";
    public static final String PARAMETER_SAMPLING_TYPE = "sampling_type";
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";

    public RandomSplitWrapperValidationChain(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        double splitRatio = this.getParameterAsDouble(PARAMETER_SPLIT_RATIO);
        SplittedExampleSet eSet = new SplittedExampleSet(this.getInput(ExampleSet.class), splitRatio, this.getParameterAsInt(PARAMETER_SAMPLING_TYPE), this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        eSet.selectSingleSubset(0);
        AttributeWeights weights = this.useMethod(eSet).remove(AttributeWeights.class);
        SplittedExampleSet newInputSet = (SplittedExampleSet)eSet.clone();
        this.learn(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanClone());
        newInputSet.selectSingleSubset(1);
        IOContainer evalRes = this.evaluate(new AttributeWeightedExampleSet(newInputSet, weights, 0.0).createCleanClone());
        PerformanceVector pv = evalRes.remove(PerformanceVector.class);
        this.setResult(pv.getMainCriterion());
        return new IOObject[]{pv, weights};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble(PARAMETER_SPLIT_RATIO, "Relative size of the training set", 0.0, 1.0, 0.7);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory(PARAMETER_SAMPLING_TYPE, "Defines the sampling type of the cross validation (linear = consecutive subsets, shuffled = random subsets, stratified = random subsets with class distribution kept constant)", SplittedExampleSet.SAMPLING_NAMES, 2));
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global)", -1, Integer.MAX_VALUE, -1));
        return types;
    }
}

