/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceSampleStream
extends FilterObjectStream<String, SentenceSample> {
    public SentenceSampleStream(ObjectStream<String> sentences) {
        super(sentences);
    }

    @Override
    public SentenceSample read() throws IOException {
        String sentence;
        StringBuilder sentencesString = new StringBuilder();
        LinkedList<Span> sentenceSpans = new LinkedList<Span>();
        while ((sentence = (String)this.samples.read()) != null && !sentence.equals("")) {
            int begin = sentencesString.length();
            sentencesString.append(sentence.trim());
            int end = sentencesString.length();
            sentenceSpans.add(new Span(begin, end));
            sentencesString.append(' ');
        }
        if (sentenceSpans.size() > 0) {
            return new SentenceSample(sentencesString.toString(), sentenceSpans.toArray(new Span[sentenceSpans.size()]));
        }
        return null;
    }
}

