/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.toolbox;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkovGenerator<O extends Observation> {
    private final Hmm<O> hmm;
    private int stateNb;

    public MarkovGenerator(Hmm<O> hmm) {
        if (hmm == null) {
            throw new IllegalArgumentException("Invalid null HMM");
        }
        this.hmm = hmm;
        this.newSequence();
    }

    public O observation() {
        O o = this.hmm.getOpdf(this.stateNb).generate();
        double rand = Math.random();
        int j = 0;
        while (j < this.hmm.nbStates() - 1) {
            double d;
            rand -= this.hmm.getAij(this.stateNb, j);
            if (d < 0.0) {
                this.stateNb = j;
                return o;
            }
            ++j;
        }
        this.stateNb = this.hmm.nbStates() - 1;
        return o;
    }

    public List<O> observationSequence(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("Positive length required");
        }
        ArrayList<O> sequence = new ArrayList<O>();
        while (length-- > 0) {
            sequence.add(this.observation());
        }
        this.newSequence();
        return sequence;
    }

    public void newSequence() {
        double rand = Math.random();
        double current = 0.0;
        int i = 0;
        while (i < this.hmm.nbStates() - 1) {
            if ((current += this.hmm.getPi(i)) > rand) {
                this.stateNb = i;
                return;
            }
            ++i;
        }
        this.stateNb = this.hmm.nbStates() - 1;
    }

    public int stateNb() {
        return this.stateNb;
    }
}

