/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.attributeeditor.actions;

import com.rapidminer.gui.attributeeditor.AttributeEditor;
import com.rapidminer.gui.tools.IconSize;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class LoadSeriesDataAction
extends AbstractAction {
    private static final long serialVersionUID = 3843660343361905373L;
    private static final String ICON_NAME = "oszillograph.png";
    private static final Icon[] ICONS = new Icon[IconSize.values().length];
    private AttributeEditor attributeEditor;

    static {
        int counter = 0;
        IconSize[] iconSizeArray = IconSize.values();
        int n = iconSizeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconSize size = iconSizeArray[n2];
            LoadSeriesDataAction.ICONS[counter++] = SwingTools.createIcon(String.valueOf(size.getSize()) + "/" + ICON_NAME);
            ++n2;
        }
    }

    public LoadSeriesDataAction(AttributeEditor attributeEditor, IconSize size) {
        super("Load Series Data...", ICONS[size.ordinal()]);
        this.putValue("ShortDescription", "Open series data file and append additional value series columns to table");
        this.putValue("MnemonicKey", 69);
        this.attributeEditor = attributeEditor;
    }

    public void actionPerformed(ActionEvent e) {
        File file = SwingTools.chooseFile((Component)this.attributeEditor, null, true, null, null);
        if (file != null) {
            try {
                this.attributeEditor.readData(file, 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.attributeEditor, e.toString(), "Error loading " + file, 0);
            }
        }
    }
}

