/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.AbstractFeatureExtractor;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.WVToolPreviewerCreator;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDirectory;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypePreview;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTFileInputList;
import edu.udo.cs.wvtool.main.WVTInputList;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureExtractionOperator
extends AbstractFeatureExtractor {
    private Attribute label = null;

    public FeatureExtractionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    protected Attribute getLabel() throws OperatorException {
        return this.label;
    }

    @Override
    protected WVTInputList createInputList() throws OperatorException {
        WVTInputList list = null;
        List<String[]> textList = this.getParameterList("texts");
        this.label = null;
        if (textList.size() == 0) {
            ExampleSet exampleSet = this.getInput(ExampleSet.class);
            this.label = exampleSet.getAttributes().getLabel();
            list = this.createInputList(exampleSet);
        } else {
            this.label = AttributeFactory.createAttribute("label", 1);
            list = this.createInputList(textList, this.label);
        }
        return list;
    }

    private WVTInputList createInputList(ExampleSet exampleSet) throws OperatorException {
        this.log("Creating WVTool input list from input example set.");
        Attribute documentClassAtt = exampleSet.getAttributes().getLabel();
        if (documentClassAtt != null && !documentClassAtt.isNominal()) {
            throw new UserError((Operator)this, 101, "wvtool", documentClassAtt);
        }
        Attribute sourceNameAtt = exampleSet.getAttributes().get("document_source");
        if (sourceNameAtt == null) {
            throw new UserError((Operator)this, 111, "document_source");
        }
        Attribute contentTypeAtt = exampleSet.getAttributes().get("type");
        Attribute contentEncodingAtt = exampleSet.getAttributes().get("encoding");
        Attribute contentLanguageAtt = exampleSet.getAttributes().get("language");
        String defaultContentType = this.getParameterAsString("default_content_type");
        String defaultContentEncoding = this.getParameterAsString("default_content_encoding");
        String defaultContentLanguage = this.getParameterAsString("default_content_language");
        WVTFileInputList list = new WVTFileInputList(documentClassAtt.getMapping().size());
        for (Example e : exampleSet) {
            String contentType = contentTypeAtt != null ? e.getValueAsString(contentTypeAtt) : defaultContentType;
            String contentEncoding = contentEncodingAtt != null ? e.getValueAsString(contentEncodingAtt) : defaultContentEncoding;
            String contentLanguage = contentLanguageAtt != null ? e.getValueAsString(contentLanguageAtt) : defaultContentLanguage;
            try {
                if (documentClassAtt != null) {
                    list.addEntry(new WVTDocumentInfo(this.resolveFilename(e.getValueAsString(sourceNameAtt)), contentType, contentEncoding, contentLanguage, (int)e.getValue(documentClassAtt)));
                    continue;
                }
                list.addEntry(new WVTDocumentInfo(this.resolveFilename(e.getValueAsString(sourceNameAtt)), contentType, contentEncoding, contentLanguage));
            }
            catch (IOException e1) {
                throw new UserError((Operator)this, 302, e.getValueAsString(sourceNameAtt), e1.getMessage());
            }
        }
        return list;
    }

    private WVTInputList createInputList(List<?> textList, Attribute label_) throws OperatorException {
        this.log("Creating WVTool input list from parameter list (ignoring input example set if any).");
        String contentType = this.getParameterAsString("default_content_type");
        String contentEncoding = this.getParameterAsString("default_content_encoding");
        String contentLanguage = this.getParameterAsString("default_content_language");
        for (Object[] keyValue : textList) {
            label_.getMapping().mapString((String)keyValue[0]);
        }
        WVTFileInputList list = new WVTFileInputList(label_.getMapping().getValues().size());
        for (Object[] keyValue : textList) {
            try {
                list.addEntry(new WVTDocumentInfo(this.resolveFilename((String)keyValue[1]), contentType, contentEncoding, contentLanguage, label_.getMapping().mapString((String)keyValue[0])));
            }
            catch (IOException e) {
                throw new UserError((Operator)this, 302, (String)keyValue[1], e.getMessage());
            }
        }
        return list;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        ParameterTypePreview previewType = new ParameterTypePreview(WVToolPreviewerCreator.class, this);
        previewType.setExpert(false);
        ParameterTypeList textListParam = new ParameterTypeList("texts", "Specifies a list of class/directory pairs.", new ParameterTypeDirectory("directory_name", "All files in this directory will be associated with the class specified by the key.", false));
        textListParam.setExpert(false);
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        types.add(previewType);
        types.add(textListParam);
        types.addAll(super.getParameterTypes());
        return types;
    }
}

