/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroDefinitionOperator
extends Operator {
    public static final String PARAMETER_VALUES = "values";
    public static final String PARAMETER_MACROS = "macros";

    public MacroDefinitionOperator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        List<String[]> macros = this.getParameterList(PARAMETER_MACROS);
        for (String[] macroDefinition : macros) {
            String macro = macroDefinition[0];
            String value = macroDefinition[1];
            this.getProcess().getMacroHandler().addMacro(macro, value);
        }
        return new IOObject[0];
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeList(PARAMETER_MACROS, "The list of macros defined by the user.", new ParameterTypeString(PARAMETER_VALUES, "The values of the user defined macros.", false)));
        return types;
    }
}

