/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.GroupedModel;
import com.rapidminer.operator.IODescription;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelGrouper
extends Operator {
    public ModelGrouper(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        GroupedModel groupedModel = new GroupedModel();
        try {
            while (true) {
                Model model = this.getInput(Model.class);
                groupedModel.prependModel(model);
            }
        }
        catch (MissingIOObjectException missingIOObjectException) {
            return new IOObject[]{groupedModel};
        }
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{Model.class};
    }

    @Override
    protected IODescription getIODescription() {
        return new GroupingIODescription();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroupingIODescription
    extends DefaultIODescription {
        public GroupingIODescription() {
            super(new Class[]{Model.class, Model.class}, new Class[]{Model.class});
        }

        @Override
        public Class<?>[] getOutputClasses(Class<?>[] input, Operator operator) throws IllegalInputException {
            int modelCount = 0;
            int i = 0;
            while (i < input.length) {
                if (Model.class.isAssignableFrom(input[i])) {
                    ++modelCount;
                }
                ++i;
            }
            if (modelCount > 0) {
                return new Class[]{Model.class};
            }
            return new Class[0];
        }
    }
}

