/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.PreviewListener;
import com.rapidminer.operator.DefaultIODescription;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IODescription;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.IllegalInputException;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.ListDescription;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.Value;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.WrongNumberOfInnerOperatorsException;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeColor;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.math.StringToMatrixConverter;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operator
implements ConfigurationListener,
PreviewListener,
LoggingHandler,
ParameterHandler {
    private boolean[] breakPoint = new boolean[BreakpointListener.BREAKPOINT_POS_NAME.length];
    private boolean enabled = true;
    private boolean expanded = true;
    private String name;
    private String userDescription;
    private OperatorChain parent;
    private IOContainer inputContainer;
    private int applyCount;
    private long startTime;
    private long loopStartTime;
    private Parameters parameters = null;
    private Map<String, Value> valueMap = new TreeMap<String, Value>();
    private List<String> errorList = new LinkedList<String>();
    private OperatorDescription operatorDescription = null;

    public Operator(OperatorDescription description) {
        this.operatorDescription = description;
        this.parameters = new Parameters(this.getParameterTypes());
        this.name = this.operatorDescription.getName();
        this.addValue(new ValueDouble("applycount", "The number of times the operator was applied.", false){

            public double getDoubleValue() {
                return Operator.this.applyCount;
            }
        });
        this.addValue(new ValueDouble("time", "The time elapsed since this operator started.", false){

            public double getDoubleValue() {
                return System.currentTimeMillis() - Operator.this.startTime;
            }
        });
        this.addValue(new ValueDouble("looptime", "The time elapsed since the current loop started.", false){

            public double getDoubleValue() {
                return System.currentTimeMillis() - Operator.this.loopStartTime;
            }
        });
    }

    public final OperatorDescription getOperatorDescription() {
        return this.operatorDescription;
    }

    public final String getOperatorClassName() {
        return this.operatorDescription.getName();
    }

    @Deprecated
    public Process getExperiment() {
        return this.getProcess();
    }

    @Override
    public Process getProcess() {
        OperatorChain parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getProcess();
    }

    public LogService getLog() {
        Process process = this.getProcess();
        if (process != null) {
            return process.getLog();
        }
        return LogService.getGlobal();
    }

    @Override
    public void log(String message) {
        this.getLog().log(String.valueOf(this.getName()) + ": " + message, 2);
    }

    @Override
    public void logNote(String message) {
        this.getLog().log(String.valueOf(this.getName()) + ": " + message, 4);
    }

    @Override
    public void logWarning(String message) {
        this.getLog().log(String.valueOf(this.getName()) + ": " + message, 5);
    }

    @Override
    public void logError(String message) {
        this.getLog().log(String.valueOf(this.getName()) + ": " + message, 6);
    }

    public final String getName() {
        return this.name;
    }

    private final void setName(String newName) {
        this.name = newName;
    }

    public final String rename(String newName) {
        Process process = this.getProcess();
        if (process != null) {
            process.unregisterName(this.name);
            this.name = process.registerName(newName, this);
        } else {
            this.name = newName;
        }
        return this.name;
    }

    public void setUserDescription(String description) {
        this.userDescription = description;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public final String getDeprecationInfo() {
        return this.operatorDescription.getDeprecationInfo();
    }

    public final void setParent(OperatorChain parent) {
        this.parent = parent;
    }

    public final OperatorChain getParent() {
        return this.parent;
    }

    public void remove() {
        Process process;
        if (this.parent != null) {
            this.parent.removeOperator(this);
        }
        if ((process = this.getProcess()) != null) {
            this.unregisterOperator(process);
        }
    }

    @Deprecated
    public void register(Process process, String name) {
    }

    protected void registerOperator(Process process) {
        if (process != null) {
            this.setName(process.registerName(this.getName(), this));
        }
    }

    protected void unregisterOperator(Process process) {
        process.unregisterName(this.name);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isEnabled() {
        if (this.getParent() == null) {
            return this.enabled;
        }
        return this.enabled && this.getParent().isEnabled();
    }

    public boolean isParallel() {
        return false;
    }

    public String getStatus() {
        return String.valueOf(this.name) + " [" + this.applyCount + "]";
    }

    public int getApplyCount() {
        return this.applyCount;
    }

    public Operator cloneOperator(String name) {
        Operator clone = null;
        try {
            clone = this.operatorDescription.createOperatorInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLog().log("Can not create clone of operator '" + this.getName() + "': " + e, 6);
            return null;
        }
        clone.setName(this.getName());
        clone.breakPoint = new boolean[]{this.breakPoint[0], this.breakPoint[1], this.breakPoint[2]};
        clone.enabled = this.enabled;
        clone.expanded = this.expanded;
        if (this.userDescription != null) {
            clone.userDescription = this.userDescription;
        }
        clone.inputContainer = this.inputContainer;
        clone.applyCount = this.applyCount;
        clone.startTime = this.startTime;
        clone.loopStartTime = this.loopStartTime;
        clone.parameters = (Parameters)this.parameters.clone();
        clone.errorList = this.errorList;
        return clone;
    }

    public abstract IOObject[] apply() throws OperatorException;

    public abstract Class<?>[] getInputClasses();

    public abstract Class<?>[] getOutputClasses();

    protected final Class<?>[] getDesiredInputClasses() {
        Class<?>[] inputClasses = this.getInputClasses();
        if (inputClasses == null) {
            return new Class[0];
        }
        return inputClasses;
    }

    protected final Class<?>[] getDeliveredOutputClasses() {
        LinkedList result = new LinkedList();
        Class<?>[] inputClasses = this.getDesiredInputClasses();
        int i = 0;
        while (i < inputClasses.length) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if (description.showParameter() && this.getParameterAsBoolean(description.getParameterName()) || description.getKeepDefault()) {
                result.add(inputClasses[i]);
            }
            ++i;
        }
        Class<?>[] additionalOutput = this.getOutputClasses();
        if (additionalOutput != null) {
            int i2 = 0;
            while (i2 < additionalOutput.length) {
                result.add(additionalOutput[i2]);
                ++i2;
            }
        }
        Class[] resultArray = new Class[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    protected InputDescription getInputDescription(Class<?> inputClass) {
        return new InputDescription(inputClass);
    }

    protected IODescription getIODescription() {
        return new DefaultIODescription(this.getDesiredInputClasses(), this.getDeliveredOutputClasses());
    }

    public Class<?>[] checkIO(Class<?>[] input) throws IllegalInputException, WrongNumberOfInnerOperatorsException {
        if (this.isEnabled()) {
            return this.getIODescription().getOutputClasses(input, this);
        }
        return input;
    }

    public void performAdditionalChecks() throws UserError {
    }

    public int checkProperties() {
        int errorCount = 0;
        if (this.isEnabled()) {
            for (ParameterType type : this.getParameterTypes()) {
                try {
                    String value = this.getParameters().getParameter(type.getKey());
                    if (type.isOptional() || type.getDefaultValue() != null || value != null) continue;
                    this.addError(String.valueOf(this.getName()) + ": " + type.getKey() + " is not defined!");
                    ++errorCount;
                }
                catch (UndefinedParameterError e) {
                    this.addError(String.valueOf(this.getName()) + ": " + type.getKey() + " is not defined!");
                    ++errorCount;
                }
            }
        }
        return errorCount;
    }

    public int checkDeprecations() {
        String deprecationString = this.getDeprecationInfo();
        int deprecationCount = 0;
        if (deprecationString != null) {
            this.addWarning(deprecationString);
            deprecationCount = 1;
        }
        return deprecationCount;
    }

    /*
     * Unable to fully structure code
     */
    public final synchronized IOContainer apply(IOContainer input) throws OperatorException {
        process = this.getProcess();
        if (process == null) {
            this.log("Process of operator " + this + " is not set, probably not registered! Trying to use this operator (should work in most cases anyway)...");
        }
        if (this.getDeprecationInfo() != null) {
            this.logWarning(this.getDeprecationInfo());
        }
        if (this.isEnabled()) {
            block27: {
                this.checkForStop(process);
                if (process != null) {
                    process.setCurrentOperator(this);
                }
                ++this.applyCount;
                this.startTime = this.loopStartTime = System.currentTimeMillis();
                if (input == null) {
                    throw new IllegalArgumentException("Input is null!");
                }
                this.inputContainer = input;
                if (process != null) {
                    process.getRootOperator().processStartedOperator(this);
                }
                if (this.breakPoint[0]) {
                    this.processBreakpoint(this.inputContainer, 0);
                }
                var7_4 = ioo = this.inputContainer.getIOObjects();
                var6_5 = ioo.length;
                var5_7 = 0;
                while (var5_7 < var6_5) {
                    ioObject = var7_4[var5_7];
                    if (ioObject != null) {
                        ioObject.setLoggingHandler(this.getLog());
                    }
                    ++var5_7;
                }
                if (this.getLog().isSufficientLogVerbosity(1)) {
                    if (ioo.length == 0) {
                        this.getLog().log("$b" + this.getName() + " called^b " + Tools.ordinalNumber(this.applyCount) + " time without input", 1);
                    } else {
                        iLog = new StringBuffer("$b");
                        iLog.append(this.getName());
                        iLog.append(" called^b ");
                        iLog.append(Tools.ordinalNumber(this.applyCount));
                        iLog.append(" time with input:");
                        i = 0;
                        while (i < ioo.length) {
                            iLog.append(Tools.getLineSeparator());
                            iLog.append("  ");
                            iLog.append(i + 1);
                            iLog.append(". ");
                            iLog.append(ioo[i]);
                            ++i;
                        }
                        this.getLog().log(iLog.toString(), 1);
                    }
                }
                output = null;
                try {
                    try {
                        output = this.apply();
                    }
                    catch (UserError e) {
                        if (e.getOperator() == null) {
                            e.setOperator(this);
                        }
                        throw e;
                    }
                }
                finally {
                    if (output == null) break block27;
                    var10_13 = output;
                    var9_15 = output.length;
                    var8_17 = 0;
                    ** while (var8_17 < var9_15)
                }
lbl-1000:
                // 1 sources

                {
                    ioObject = var10_13[var8_17];
                    if (ioObject != null && ioObject.getSource() == null) {
                        ioObject.setSource(this.getName());
                        ioObject.setLoggingHandler(null);
                    }
                    ++var8_17;
                    continue;
                }
            }
            if (this.getLog().isSufficientLogVerbosity(1)) {
                if (output.length == 0) {
                    this.getLog().log(String.valueOf(this.getName()) + " returned no additional output", 1);
                } else {
                    oLog = new StringBuffer(this.getName());
                    oLog.append(" returned additional output:");
                    i = 0;
                    while (i < output.length) {
                        oLog.append(Tools.getLineSeparator());
                        oLog.append("  ");
                        oLog.append(String.valueOf(i + 1) + ". ");
                        oLog.append(output[i]);
                        ++i;
                    }
                    this.getLog().log(oLog.toString(), 1);
                }
            }
            this.getLog().log(String.valueOf(this.getName()) + ": execution time was " + (System.currentTimeMillis() - this.startTime) + " ms", 0);
            outputContainer = this.handleAdditionalOutput(this.inputContainer, output);
            if (process != null) {
                process.getRootOperator().processFinishedOperator(this);
            }
            if (this.breakPoint[2]) {
                this.processBreakpoint(outputContainer, 2);
            }
            this.inputContainer = null;
            return outputContainer;
        }
        return input;
    }

    protected final void checkForStop() throws ProcessStoppedException {
        if (this.getParent() != null) {
            this.checkForStop(this.getParent().getProcess());
        } else {
            this.checkForStop(this.getProcess());
        }
    }

    private final void checkForStop(Process process) throws ProcessStoppedException {
        if (process != null && process.shouldStop()) {
            this.stop();
        }
    }

    private final void stop() throws ProcessStoppedException {
        this.getLog().log("$b" + this.getName() + "^b: Process stopped.", 4);
        throw new ProcessStoppedException(this);
    }

    @Deprecated
    public final void resume() {
        this.getProcess().resume();
    }

    private void processBreakpoint(IOContainer container, int breakpointType) throws ProcessStoppedException {
        this.getLog().log("$b" + this.getName() + "^b: Breakpoint reached", 4);
        Process process = this.getProcess();
        process.pause(this, container, breakpointType);
        if (process.shouldStop()) {
            this.stop();
        }
    }

    private final IOContainer handleAdditionalOutput(IOContainer container, IOObject[] additional) {
        if (this.getAddOnlyAdditionalOutput()) {
            return new IOContainer(additional);
        }
        return container.append(additional);
    }

    public boolean getAddOnlyAdditionalOutput() {
        return false;
    }

    protected <T extends IOObject> T getInput(Class<T> cls) throws MissingIOObjectException {
        return this.getInput(cls, 0);
    }

    protected <T extends IOObject> T getInput(Class<T> cls, int nr) throws MissingIOObjectException {
        InputDescription description = this.getInputDescription(cls);
        if (description.showParameter()) {
            if (this.getParameterAsBoolean(description.getParameterName())) {
                return this.inputContainer.get(cls, nr);
            }
            return this.inputContainer.remove(cls, nr);
        }
        if (description.getKeepDefault()) {
            return this.inputContainer.get(cls, nr);
        }
        return this.inputContainer.remove(cls, nr);
    }

    protected boolean hasInput(Class<? extends IOObject> cls) {
        return this.inputContainer.contains(cls);
    }

    protected final IOContainer getInput() {
        return this.inputContainer;
    }

    protected void setInput(IOContainer input) {
        if (input == null) {
            throw new IllegalArgumentException("Input is null!");
        }
        this.inputContainer = input;
    }

    public void processStarts() throws OperatorException {
        this.applyCount = 0;
    }

    public void processFinished() throws OperatorException {
    }

    public void setBreakpoint(int position, boolean on) {
        this.breakPoint[position] = on;
    }

    public boolean hasBreakpoint() {
        return this.hasBreakpoint(0) || this.hasBreakpoint(1) || this.hasBreakpoint(2);
    }

    public boolean hasBreakpoint(int position) {
        return this.breakPoint[position];
    }

    public void inApplyLoop() throws ProcessStoppedException {
        if (this.breakPoint[1]) {
            this.processBreakpoint(this.getIOContainerForInApplyLoopBreakpoint(), 1);
        }
        this.loopStartTime = System.currentTimeMillis();
        this.checkForStop();
    }

    protected IOContainer getIOContainerForInApplyLoopBreakpoint() {
        return IOContainer.DUMMY_IO_CONTAINER;
    }

    public void addValue(Value value) {
        this.valueMap.put(value.getKey(), value);
    }

    public final Value getValue(String key) {
        return this.valueMap.get(key);
    }

    public Collection<Value> getValues() {
        return this.valueMap.values();
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public void setParameter(String key, String value) {
        this.parameters.setParameter(key, value);
    }

    @Override
    public void setListParameter(String key, List<String[]> list) {
        this.parameters.setParameter(key, Parameters.transformList2String(list));
    }

    @Override
    public String getParameter(String key) throws UndefinedParameterError {
        try {
            return this.expandString(this.replaceMacros(this.parameters.getParameter(key)));
        }
        catch (UndefinedParameterError e) {
            e.setOperator(this);
            throw e;
        }
    }

    @Override
    public boolean isParameterSet(String key) throws UndefinedParameterError {
        return this.getParameter(key) != null;
    }

    @Override
    public String getParameterAsString(String key) throws UndefinedParameterError {
        return this.getParameter(key);
    }

    @Override
    public int getParameterAsInt(String key) throws UndefinedParameterError {
        ParameterType type = this.parameters.getParameterType(key);
        if (type != null) {
            if (type instanceof ParameterTypeCategory) {
                String parameterValue = this.getParameter(key);
                try {
                    return Integer.valueOf(parameterValue);
                }
                catch (NumberFormatException e) {
                    ParameterTypeCategory categoryType = (ParameterTypeCategory)type;
                    return categoryType.getIndex(parameterValue);
                }
            }
            return Integer.valueOf(this.getParameter(key));
        }
        return Integer.valueOf(this.getParameter(key));
    }

    @Override
    public double getParameterAsDouble(String key) throws UndefinedParameterError {
        return Double.valueOf(this.getParameter(key));
    }

    @Override
    public boolean getParameterAsBoolean(String key) {
        try {
            return Boolean.valueOf(this.getParameter(key));
        }
        catch (UndefinedParameterError undefinedParameterError) {
            return false;
        }
    }

    @Override
    public List<String[]> getParameterList(String key) throws UndefinedParameterError {
        return Parameters.transformString2List(this.getParameter(key));
    }

    @Override
    public Color getParameterAsColor(String key) throws UndefinedParameterError {
        return ParameterTypeColor.string2Color(this.getParameter(key));
    }

    @Override
    public InputStream getParameterAsInputStream(String key) throws UndefinedParameterError, IOException {
        String urlString = this.getParameter(key);
        if (urlString == null) {
            return null;
        }
        try {
            URL url = new URL(urlString);
            InputStream stream = url.openStream();
            return stream;
        }
        catch (MalformedURLException e) {
            File file = this.getParameterAsFile(key);
            if (file != null) {
                return new FileInputStream(file);
            }
            return null;
        }
    }

    @Override
    public File getParameterAsFile(String key) throws UndefinedParameterError {
        return this.getParameterAsFile(key, false);
    }

    @Override
    public File getParameterAsFile(String key, boolean createMissingDirectories) throws UndefinedParameterError {
        String fileName = this.getParameter(key);
        if (fileName == null) {
            return null;
        }
        Process process = this.getProcess();
        if (process != null) {
            File result = process.resolveFileName(fileName);
            if (createMissingDirectories) {
                if (result.isDirectory()) {
                    result.mkdirs();
                } else {
                    File parent = result.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                }
            }
            return result;
        }
        File result = new File(fileName);
        if (createMissingDirectories) {
            if (result.isDirectory()) {
                result.mkdirs();
            } else {
                File parent = result.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
            }
        }
        return result;
    }

    @Override
    public double[][] getParameterAsMatrix(String key) throws UndefinedParameterError {
        String matrixLine = this.getParameter(key);
        try {
            return StringToMatrixConverter.parseMatlabString(matrixLine);
        }
        catch (OperatorException e) {
            throw new UndefinedParameterError(e.getMessage());
        }
    }

    private String expandString(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int totalStart = 0;
        int start = 0;
        while ((start = str.indexOf("%{", totalStart)) >= 0) {
            result.append(str.substring(totalStart, start));
            int end = str.indexOf(125, start);
            if (end >= start) {
                String command = str.substring(start, end + 1);
                switch (command.charAt(2)) {
                    case 'n': {
                        result.append(this.getName());
                        break;
                    }
                    case 'c': {
                        result.append(this.getClass().getName());
                        break;
                    }
                    case 'a': {
                        result.append(this.applyCount);
                        break;
                    }
                    case 'b': {
                        result.append(this.applyCount + 1);
                        break;
                    }
                    case 'p': {
                        int openNumberIndex = command.indexOf(91, 3);
                        if (openNumberIndex < 0) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        int closeNumberIndex = command.indexOf(93, openNumberIndex);
                        if (closeNumberIndex < 0) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        if (closeNumberIndex <= openNumberIndex + 1) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        String numberString = command.substring(openNumberIndex + 1, closeNumberIndex);
                        int number = Integer.parseInt(numberString);
                        result.append(this.applyCount + number);
                        break;
                    }
                    case 't': {
                        GregorianCalendar calendar = new GregorianCalendar();
                        result.append(String.valueOf(calendar.get(1)) + "_");
                        String month = String.valueOf(calendar.get(2) + 1);
                        if (month.length() < 2) {
                            month = "0" + month;
                        }
                        result.append(String.valueOf(month) + "_");
                        String day = String.valueOf(calendar.get(5));
                        if (day.length() < 2) {
                            day = "0" + day;
                        }
                        result.append(String.valueOf(day) + "-");
                        int amPm = calendar.get(9);
                        String amPmString = amPm == 0 ? "AM" : "PM";
                        result.append(String.valueOf(amPmString) + "_");
                        String hour = String.valueOf(calendar.get(10));
                        if (hour.length() < 2) {
                            hour = "0" + hour;
                        }
                        result.append(String.valueOf(hour) + "_");
                        String minute = String.valueOf(calendar.get(12));
                        if (minute.length() < 2) {
                            minute = "0" + minute;
                        }
                        result.append(String.valueOf(minute) + "_");
                        String second = String.valueOf(calendar.get(13));
                        if (second.length() < 2) {
                            second = "0" + second;
                        }
                        result.append(second);
                        break;
                    }
                    case 'v': {
                        int openNumberIndex = command.indexOf(91, 3);
                        if (openNumberIndex < 0) {
                            throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                        }
                        int closeNumberIndex = command.indexOf(93, openNumberIndex);
                        if (closeNumberIndex < 0) {
                            throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                        }
                        if (closeNumberIndex <= openNumberIndex + 1) {
                            throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                        }
                        String operatorValueString = command.substring(openNumberIndex + 1, closeNumberIndex);
                        String[] operatorValuePair = operatorValueString.split("\\.");
                        if (operatorValuePair.length != 2) {
                            throw new RuntimeException("An operator name and a value name divided by '.' in [] must follow $v, for example $p[Learner.applycount].");
                        }
                        Operator operator = this.getProcess().getOperator(operatorValuePair[0]);
                        Value value = operator.getValue(operatorValuePair[1]);
                        if (value == null) {
                            this.logError("Value '" + operatorValuePair[1] + "' of the operator '" + operatorValuePair[0] + "' not found!");
                            break;
                        }
                        if (value.isNominal()) {
                            Object valueObject = value.getValue();
                            if (valueObject != null) {
                                result.append(valueObject.toString());
                                break;
                            }
                            this.logError("Value '" + operatorValuePair[1] + "' of the operator '" + operatorValuePair[0] + "' not found!");
                            break;
                        }
                        double doubleValue = (Double)value.getValue();
                        if (!Double.isNaN(doubleValue)) {
                            result.append(Tools.formatIntegerIfPossible(doubleValue));
                            break;
                        }
                        this.logError("Value '" + operatorValuePair[1] + "' of the operator '" + operatorValuePair[0] + "' not found!");
                        break;
                    }
                    case '%': {
                        result.append('%');
                        break;
                    }
                    default: {
                        result.append(command);
                        break;
                    }
                }
            } else {
                end = start + 2;
                result.append("%{");
            }
            totalStart = end + 1;
        }
        result.append(str.substring(totalStart));
        return result.toString();
    }

    private String replaceMacros(String value) {
        if (value == null) {
            return null;
        }
        try {
            String line = value;
            int startIndex = line.indexOf("%{");
            StringBuffer result = new StringBuffer();
            while (startIndex >= 0) {
                result.append(line.substring(0, startIndex));
                int endIndex = line.indexOf("}", startIndex + 2);
                String macroString = line.substring(startIndex + 2, endIndex);
                String macroValue = this.getProcess().getMacroHandler().getMacro(macroString);
                if (macroValue != null) {
                    result.append(macroValue);
                } else {
                    result.append("%{" + macroString + "}");
                }
                line = line.substring(endIndex + 1);
                startIndex = line.indexOf("%{");
            }
            result.append(line);
            return result.toString();
        }
        catch (Exception e) {
            return value;
        }
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        LinkedList<ParameterType> types = new LinkedList<ParameterType>();
        Class<?>[] inputClasses = this.getDesiredInputClasses();
        int i = 0;
        while (i < inputClasses.length) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if (description.showParameter()) {
                types.add(new ParameterTypeBoolean(description.getParameterName(), "Indicates if this input object should also be returned as output.", description.getKeepDefault()));
            }
            ++i;
        }
        return types;
    }

    public ParameterType getParameterType(String name) {
        for (ParameterType current : this.getParameterTypes()) {
            if (!current.getKey().equals(name)) continue;
            return current;
        }
        return null;
    }

    public void writeXML(PrintWriter out, String indent, boolean hideDefault) throws IOException {
        out.println(this.getXML(indent, hideDefault));
    }

    public String getXML(String indent, boolean hideDefault) {
        StringBuffer result = new StringBuffer();
        String breakpointString = "";
        StringBuffer breakpointBuf = null;
        boolean firstBreakpoint = true;
        int i = 0;
        while (i < BreakpointListener.BREAKPOINT_POS_NAME.length) {
            if (this.breakPoint[i]) {
                if (firstBreakpoint) {
                    breakpointBuf = new StringBuffer(" breakpoints=\"");
                    firstBreakpoint = false;
                } else {
                    breakpointBuf.append(",");
                }
                breakpointBuf.append(BreakpointListener.BREAKPOINT_POS_NAME[i]);
            }
            ++i;
        }
        if (breakpointBuf != null) {
            breakpointBuf.append("\"");
            breakpointString = breakpointBuf.toString();
        }
        result.append(String.valueOf(indent) + "<operator " + "name=\"" + this.name + "\" " + "class=\"" + this.operatorDescription.getName() + "\"" + breakpointString + (!this.enabled ? " activated=\"no\"" : "") + (this instanceof OperatorChain ? (this.expanded ? " expanded=\"yes\"" : " expanded=\"no\"") : "") + ">" + Tools.getLineSeparator());
        if (this.userDescription != null && this.userDescription.length() != 0) {
            result.append(String.valueOf(indent) + "    <description text=\"" + this.userDescription + "\"/>" + Tools.getLineSeparator());
        }
        result.append(this.parameters.getXML(String.valueOf(indent) + "    ", hideDefault));
        result.append(this.getInnerOperatorsXML(String.valueOf(indent) + "    ", hideDefault));
        result.append(String.valueOf(indent) + "</operator>" + Tools.getLineSeparator());
        return result.toString();
    }

    protected String getInnerOperatorsXML(String indent, boolean hideDefault) {
        return "";
    }

    private static String createDescriptionFromXML(Element element) throws XMLException {
        Attr textAttr = element.getAttributeNode("text");
        if (textAttr == null) {
            throw new XMLException("Attribute 'text' of <description> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <description>");
        }
        return textAttr.getValue();
    }

    private static String[] createParameterFromXML(Element element) throws XMLException {
        Attr keyAttr = element.getAttributeNode("key");
        Attr valueAttr = element.getAttributeNode("value");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <parameter> tag is not set.");
        }
        if (valueAttr == null) {
            throw new XMLException("Attribute 'value' of <parameter> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <parameter>");
        }
        return new String[]{keyAttr.getValue(), valueAttr.getValue()};
    }

    private static ListDescription createParameterListFromXML(Element element) throws XMLException {
        LinkedList<String[]> values = new LinkedList<String[]>();
        Attr keyAttr = element.getAttributeNode("key");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <list> tag is not set.");
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                Element inner = (Element)node;
                if (inner.getTagName().toLowerCase().equals("parameter")) {
                    values.add(Operator.createParameterFromXML(inner));
                } else {
                    throw new XMLException("Ilegal inner tag for <list>: " + inner.getTagName());
                }
            }
            ++i;
        }
        return new ListDescription(keyAttr.getValue(), values);
    }

    public static Operator createFromXML(Element element, List<UnknownParameterInformation> unknownParameterInformation) throws XMLException {
        if (!element.getTagName().toLowerCase().equals("operator")) {
            throw new XMLException("<operator> expected!");
        }
        String className = null;
        String name = null;
        Attr classAttr = element.getAttributeNode("class");
        if (classAttr == null) {
            throw new XMLException("Attribute 'class' of <operator> tag is not defined! ");
        }
        className = classAttr.getValue();
        Attr nameAttr = element.getAttributeNode("name");
        if (nameAttr == null) {
            throw new XMLException("Attribute 'name' of <operator> tag is not defined! ");
        }
        name = nameAttr.getValue();
        OperatorDescription opDescr = OperatorService.getOperatorDescription(className);
        if (opDescr == null) {
            if (className.startsWith("Y-")) {
                String yClassName = className.substring("Y-".length());
                opDescr = OperatorService.getOperatorDescription(yClassName);
                if (opDescr != null) {
                    className = yClassName;
                }
            } else {
                String wClassName = "W-" + className;
                opDescr = OperatorService.getOperatorDescription(wClassName);
                if (opDescr != null) {
                    className = wClassName;
                }
            }
        }
        if (opDescr == null) {
            throw new XMLException("Unknown operator class: '" + className + "'!");
        }
        Operator operator = null;
        try {
            operator = opDescr.createOperatorInstance();
        }
        catch (OperatorCreationException e) {
            throw new XMLException("Cannot create operator: " + e.getMessage(), e);
        }
        operator.setName(name);
        operator.setOperatorParameters(element, unknownParameterInformation);
        return operator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOperatorParameters(Element element, List<UnknownParameterInformation> unknownParameterInformation) throws XMLException {
        int i;
        Attr expansionAttr;
        Attr activationAttr;
        String breakpointString = null;
        String activationString = null;
        String expansionString = null;
        Attr breakpointAttr = element.getAttributeNode("breakpoints");
        if (breakpointAttr != null) {
            breakpointString = breakpointAttr.getValue();
        }
        if ((activationAttr = element.getAttributeNode("activated")) != null) {
            activationString = activationAttr.getValue();
        }
        if ((expansionAttr = element.getAttributeNode("expanded")) != null) {
            expansionString = expansionAttr.getValue();
        }
        if (breakpointString != null) {
            boolean ok = false;
            if (breakpointString.equals("both")) {
                this.setBreakpoint(0, true);
                this.setBreakpoint(2, true);
                ok = true;
            }
            i = 0;
            while (i < BreakpointListener.BREAKPOINT_POS_NAME.length) {
                if (breakpointString.indexOf(BreakpointListener.BREAKPOINT_POS_NAME[i]) >= 0) {
                    this.setBreakpoint(i, true);
                    ok = true;
                }
                ++i;
            }
            if (!ok) {
                throw new XMLException("Breakpoint `" + breakpointString + "` is not defined!");
            }
        }
        if (activationString != null) {
            if (activationString.equals("no")) {
                this.setEnabled(false);
            } else {
                if (!activationString.equals("yes")) throw new XMLException("Activation mode `" + activationString + "` is not defined!");
                this.setEnabled(true);
            }
        }
        if (expansionString != null) {
            if (expansionString.equals("no")) {
                this.setExpanded(false);
            } else {
                if (!expansionString.equals("yes")) throw new XMLException("Expansion mode `" + expansionString + "` is not defined!");
                this.setExpanded(true);
            }
        } else {
            this.setExpanded(true);
        }
        NodeList innerTags = element.getChildNodes();
        i = 0;
        while (i < innerTags.getLength()) {
            Node node = innerTags.item(i);
            if (node instanceof Element) {
                boolean knownType;
                Element inner = (Element)node;
                if (inner.getTagName().toLowerCase().equals("parameter")) {
                    String[] parameter = Operator.createParameterFromXML(inner);
                    knownType = this.getParameters().setParameter(parameter[0], parameter[1]);
                    if (!knownType) {
                        unknownParameterInformation.add(new UnknownParameterInformation(this.getName(), this.getOperatorDescription().getName(), parameter[0].toString(), parameter[1].toString()));
                    }
                } else if (inner.getTagName().toLowerCase().equals("list")) {
                    ListDescription listDescription = Operator.createParameterListFromXML(inner);
                    knownType = this.getParameters().setParameter(listDescription.getKey(), Parameters.transformList2String(listDescription.getList()));
                    if (!knownType) {
                        unknownParameterInformation.add(new UnknownParameterInformation(this.getName(), this.getOperatorDescription().getName(), listDescription.getKey(), listDescription.getList().toString()));
                    }
                } else if (inner.getTagName().toLowerCase().equals("operator")) {
                    if (!(this instanceof OperatorChain)) throw new XMLException("No inner operators allowed for '" + this.getOperatorClassName() + "'");
                    ((OperatorChain)this).addOperator(Operator.createFromXML(inner, unknownParameterInformation));
                } else {
                    if (!inner.getTagName().toLowerCase().equals("description")) throw new XMLException("Ilegal inner tag for <operator>: " + inner.getTagName());
                    String description = Operator.createDescriptionFromXML(inner);
                    this.setUserDescription(description);
                }
            }
            ++i;
        }
    }

    public void clearErrorList() {
        this.errorList.clear();
    }

    public void addError(String message) {
        this.logError(String.valueOf(this.getName()) + ": " + message);
        this.errorList.add(message);
    }

    public void addWarning(String message) {
        this.logWarning(String.valueOf(this.getName()) + ": " + message);
        this.errorList.add(message);
    }

    public List<String> getErrorList() {
        return this.errorList;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        String type = null;
        type = this.getOperatorDescription() != null ? this.getOperatorClassName() : this.getClass().getName();
        return String.valueOf(this.breakPoint[0] || this.breakPoint[1] ? "* " : "") + this.name + " (" + type + ")";
    }

    @Deprecated
    public String createExperimentTree(int indent) {
        return this.createProcessTree(indent);
    }

    public String createProcessTree(int indent) {
        return this.createProcessTree(indent, "", "", null, null);
    }

    @Deprecated
    public String createMarkedExperimentTree(int indent, String mark, Operator markOperator) {
        return this.createMarkedProcessTree(indent, mark, markOperator);
    }

    public String createMarkedProcessTree(int indent, String mark, Operator markOperator) {
        return this.createProcessTree(indent, "", "", markOperator, mark);
    }

    @Deprecated
    protected String createExperimentTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        return this.createProcessTree(indent, selfPrefix, childPrefix, markOperator, mark);
    }

    protected String createProcessTree(int indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        if (markOperator != null && this.getName().equals(markOperator.getName())) {
            return String.valueOf(this.indent(indent - mark.length())) + mark + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
        }
        return String.valueOf(this.indent(indent)) + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
    }

    private String indent(int indent) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < indent) {
            s.append(" ");
            ++i;
        }
        return s.toString();
    }

    public final Charset getEncoding() {
        String encoding = null;
        Process process = this.getProcess();
        if (process != null) {
            try {
                encoding = process.getRootOperator().getParameterAsString("encoding");
            }
            catch (UndefinedParameterError undefinedParameterError) {
                // empty catch block
            }
        }
        return Process.getEncoding(encoding);
    }

    public boolean isDebugMode() {
        String debugProperty = System.getProperty("rapidminer.general.debugmode");
        return Tools.booleanValue(debugProperty, false);
    }

    public void setApplyCount(int applyCount) {
        this.applyCount = applyCount;
    }
}

