/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.clustering.clusterer;

import com.rapidminer.operator.Operator;
import com.rapidminer.operator.clustering.clusterer.SVCExampleSet;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExample;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.optimizer.QuadraticProblem;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.optimizer.QuadraticProblemSMO;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVMInterface;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.util.MaxHeap;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.util.MinHeap;
import com.rapidminer.parameter.UndefinedParameterError;

public class SVClusteringAlgorithm
implements SVMInterface {
    private static final int[] RAPID_MINER_VERBOSITY;
    protected Kernel kernel;
    protected SVCExampleSet examples;
    double[] alphas;
    protected int examples_total;
    protected int target_count;
    protected double convergence_epsilon = 0.001;
    protected double lambda_factor;
    protected int[] at_bound;
    protected double[] sum;
    protected double[] K;
    protected int[] working_set;
    protected double[] primal;
    protected double sum_alpha;
    protected double lambda_eq;
    protected int to_shrink;
    protected double feasible_epsilon;
    protected double lambda_WS;
    boolean shrinked;
    private int max_iterations = 100000;
    protected int working_set_size = 10;
    protected int parameters_working_set_size = 10;
    protected double is_zero = 1.0E-10;
    protected int shrink_const = 55;
    protected double C = 0.0;
    protected double descend = 1.0E-15;
    MinHeap heap_min;
    MaxHeap heap_max;
    protected QuadraticProblem qp;
    private Operator paramOperator;

    static {
        int[] nArray = new int[5];
        nArray[0] = 2;
        nArray[1] = 2;
        nArray[2] = 2;
        RAPID_MINER_VERBOSITY = nArray;
    }

    public SVClusteringAlgorithm() {
    }

    public SVClusteringAlgorithm(Operator paramOperator, Kernel new_kernel, SVCExampleSet new_examples) throws UndefinedParameterError {
        this.init(new_kernel, new_examples);
        this.paramOperator = paramOperator;
        this.examples = new_examples;
        this.max_iterations = paramOperator.getParameterAsInt("max_iterations");
        this.convergence_epsilon = paramOperator.getParameterAsDouble("convergence_epsilon");
        this.C = 1.0 / ((double)this.examples_total * paramOperator.getParameterAsDouble("p"));
    }

    public void init(Kernel new_kernel, SVCExampleSet new_examples) {
        this.kernel = new_kernel;
        this.examples = new_examples;
        this.examples_total = this.examples.count_examples();
        this.parameters_working_set_size = this.working_set_size;
        this.lambda_factor = 1.0;
        this.lambda_eq = 0.0;
        this.target_count = 0;
        this.sum_alpha = 0.0;
        this.feasible_epsilon = this.convergence_epsilon;
        this.alphas = this.examples.get_alphas();
    }

    public void train() {
        int i;
        if (this.examples_total <= 0) {
            this.examples.set_b(Double.NaN);
            this.examples.set_R(0.0);
            return;
        }
        if (this.examples_total == 1) {
            this.examples.set_b(this.kernel.calculate_K(0, 0));
            this.examples.set_R(0.0);
            return;
        }
        this.target_count = 0;
        this.shrinked = false;
        this.init_optimizer();
        this.init_working_set();
        int iteration = 0;
        boolean converged = false;
        while (iteration < this.max_iterations) {
            this.logln(4, "optimizer iteration " + ++iteration);
            this.optimize();
            this.put_optimizer_values();
            converged = this.convergence();
            if (converged) {
                this.project_to_constraint();
                if (this.shrinked) {
                    this.logln(2, "***** Checking convergence for all variables");
                    this.reset_shrinked();
                    converged = this.convergence();
                }
                if (converged) {
                    this.logln(1, "*** Convergence");
                    break;
                }
                this.shrink_const += 10;
                this.target_count = 0;
                i = 0;
                while (i < this.examples_total) {
                    this.at_bound[i] = 0;
                    ++i;
                }
            }
            this.shrink();
            this.calculate_working_set();
            this.update_working_set();
        }
        if (iteration >= this.max_iterations && !converged) {
            this.logln(1, "*** No convergence: Time up.");
            if (this.shrinked) {
                this.reset_shrinked();
            }
        }
        double new_b = 0.0;
        double new_R = 0.0;
        int new_R_count = 0;
        i = 0;
        while (i < this.examples_total) {
            new_b += this.alphas[i] * this.sum[i];
            if (this.alphas[i] - this.C < -this.is_zero && this.alphas[i] > this.is_zero) {
                new_R += this.K[i] - 2.0 * this.sum[i];
                ++new_R_count;
            }
            ++i;
        }
        this.examples.set_b(new_b);
        if (new_R_count > 0) {
            if ((new_R = new_b + new_R / (double)new_R_count) < 0.0) {
                new_R = 0.0;
            }
            this.examples.set_R(Math.sqrt(new_R));
        } else {
            double minR = Double.MIN_VALUE;
            double maxR = Double.MAX_VALUE;
            i = 0;
            while (i < this.examples_total) {
                new_R = this.K[i] - 2.0 * this.sum[i] + new_b;
                if (this.alphas[i] <= this.is_zero && new_R > minR) {
                    minR = new_R;
                }
                if (this.alphas[i] - this.C >= -this.is_zero && new_R < maxR) {
                    maxR = new_R;
                }
                ++i;
            }
            new_R = minR > Double.MIN_VALUE ? (maxR < Double.MAX_VALUE ? (minR + maxR) / 2.0 : minR) : maxR;
            this.examples.set_R(Math.sqrt(new_R));
        }
        this.logln(2, "Done training: " + iteration + " iterations.");
        this.print_statistics();
        this.exit_optimizer();
    }

    protected void print_statistics() {
        double alpha;
        int dim = this.examples.get_dim();
        int svs = 0;
        int bsv = 0;
        double min_lambda = Double.MAX_VALUE;
        double R = this.examples.get_R();
        int i = 0;
        while (i < this.examples_total) {
            if (this.lambda(i) < min_lambda) {
                min_lambda = this.lambda(i);
            }
            if ((alpha = this.alphas[i]) != 0.0) {
                ++svs;
                if (alpha == this.C) {
                    ++bsv;
                }
            }
            ++i;
        }
        this.logln(1, "Error on KKT is " + -min_lambda);
        this.logln(1, String.valueOf(svs) + " SVs");
        this.logln(1, String.valueOf(bsv) + " BSVs");
        this.logln(1, "R = " + R);
        double[] w = new double[dim];
        int j = 0;
        while (j < dim) {
            w[j] = 0.0;
            ++j;
        }
        i = 0;
        while (i < this.examples_total) {
            double[] x = this.examples.get_example(i).toDense(dim);
            alpha = this.alphas[i];
            j = 0;
            while (j < dim) {
                int n = j;
                w[n] = w[n] + alpha * x[j];
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < dim) {
            this.logln(2, "a[" + j + "] = " + w[j]);
            ++j;
        }
    }

    public double getB() {
        return this.examples.get_b();
    }

    public double getR() {
        return this.examples.get_R();
    }

    protected void init_optimizer() {
        this.primal = new double[this.working_set_size];
        this.sum = new double[this.examples_total];
        this.K = new double[this.examples_total];
        this.at_bound = new int[this.examples_total];
        if (this.working_set_size > this.examples_total) {
            this.working_set_size = this.examples_total;
        }
        this.qp = new QuadraticProblemSMO(this.is_zero / 100.0, this.convergence_epsilon / 100.0, this.working_set_size * this.working_set_size);
        this.qp.set_n(this.working_set_size);
        this.working_set = new int[this.working_set_size];
        this.heap_max = new MaxHeap(0);
        this.heap_min = new MinHeap(0);
        int i = 0;
        while (i < this.working_set_size) {
            this.qp.l[i] = 0.0;
            ++i;
        }
        double s = 1.0;
        i = 0;
        while (i < this.examples_total && s > 0.0) {
            if (s < this.C) {
                this.alphas[i] = s;
                break;
            }
            this.alphas[i] = this.C;
            s -= this.C;
            ++i;
        }
        this.lambda_WS = 0.0;
        this.to_shrink = 0;
        this.qp.set_n(this.working_set_size);
    }

    protected void exit_optimizer() {
        this.qp = null;
    }

    protected void shrink() {
        if (this.to_shrink > this.examples_total / 10) {
            int last_pos = this.examples_total;
            if (last_pos > this.working_set_size) {
                int i = 0;
                while (i < last_pos) {
                    if (this.at_bound[i] >= this.shrink_const) {
                        this.sum_alpha += this.alphas[i];
                        this.examples.swap(i, --last_pos);
                        this.kernel.swap(i, last_pos);
                        this.sum[i] = this.sum[last_pos];
                        this.K[i] = this.K[last_pos];
                        this.at_bound[i] = this.at_bound[last_pos];
                        if (last_pos <= this.working_set_size) break;
                    }
                    ++i;
                }
                this.to_shrink = 0;
                this.shrinked = true;
                if (last_pos < this.examples_total) {
                    this.examples_total = last_pos;
                    this.kernel.set_examples_size(this.examples_total);
                }
            }
            this.logln(4, "shrinked to " + this.examples_total + " variables");
        }
    }

    protected void reset_shrinked() {
        int old_ex_tot = this.examples_total;
        this.target_count = 0;
        this.examples_total = this.examples.count_examples();
        this.kernel.set_examples_size(this.examples_total);
        int i = old_ex_tot;
        while (i < this.examples_total) {
            this.sum[i] = 0.0;
            this.K[i] = this.kernel.calculate_K(i, i);
            this.at_bound[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.examples_total) {
            double alpha = this.alphas[i];
            if (alpha != 0.0) {
                double[] kernel_row = this.kernel.get_row(i);
                int j = old_ex_tot;
                while (j < this.examples_total) {
                    int n = j;
                    this.sum[n] = this.sum[n] + alpha * kernel_row[j];
                    ++j;
                }
            }
            ++i;
        }
        this.sum_alpha = 0.0;
        this.shrinked = false;
        this.logln(5, "Resetting shrinked from " + old_ex_tot + " to " + this.examples_total);
    }

    protected void project_to_constraint() {
        double alpha;
        double alpha_sum = this.sum_alpha - 1.0;
        int SVcount = 0;
        int i = 0;
        while (i < this.examples_total) {
            alpha = this.alphas[i];
            alpha_sum += alpha;
            if (alpha > 0.0 && alpha < this.C) {
                ++SVcount;
            }
            ++i;
        }
        if (alpha_sum != 0.0) {
            if (SVcount > 0) {
                double alpha_delta = alpha_sum / (double)SVcount;
                alpha_sum = this.sum_alpha - 1.0;
                i = 0;
                while (i < this.examples_total) {
                    alpha = this.alphas[i];
                    if (alpha > 0.0 && alpha < this.C) {
                        int n = i;
                        this.alphas[n] = this.alphas[n] - alpha_delta;
                        double[] kernel_row = this.kernel.get_row(i);
                        int j = 0;
                        while (j < this.examples_total) {
                            int n2 = j;
                            this.sum[n2] = this.sum[n2] - alpha_delta * kernel_row[j];
                            ++j;
                        }
                    }
                    alpha_sum += alpha;
                    ++i;
                }
            }
            if (Math.abs(alpha_sum) > this.is_zero) {
                i = 0;
                while (i < this.examples_total && alpha_sum != 0.0) {
                    alpha = this.alphas[i];
                    if (alpha_sum > 0.0) {
                        if (!(alpha > 0.0)) continue;
                        if (alpha < alpha_sum) {
                            alpha_sum -= alpha;
                            this.alphas[i] = 0.0;
                            continue;
                        }
                        int n = i;
                        this.alphas[n] = this.alphas[n] - alpha_sum;
                        alpha_sum = 0.0;
                        continue;
                    }
                    if (!(alpha < this.C)) continue;
                    if (this.C - alpha < -alpha_sum) {
                        alpha_sum += this.C - alpha;
                        this.alphas[i] = this.C;
                        continue;
                    }
                    int n = i;
                    this.alphas[n] = this.alphas[n] - alpha_sum;
                    alpha_sum = 0.0;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void calculate_working_set() {
        block32: {
            if (this.working_set_size < this.parameters_working_set_size) {
                this.working_set_size = this.parameters_working_set_size;
                if (this.working_set_size > this.examples_total) {
                    this.working_set_size = this.examples_total;
                }
            }
            this.heap_min.init(this.working_set_size / 2);
            this.heap_max.init(this.working_set_size / 2 + this.working_set_size % 2);
            i = 0;
            if (this.target_count >= 3) ** GOTO lbl24
            while (i < this.examples_total) {
                is_feasible = this.feasible(i);
                if (is_feasible) {
                    the_nabla = this.nabla(i);
                    this.heap_max.add(the_nabla, i);
                    this.heap_min.add(the_nabla, i);
                }
                ++i;
            }
            break block32;
lbl-1000:
            // 1 sources

            {
                is_feasible = this.feasible(i);
                if (is_feasible) {
                    the_nabla = this.lambda(i);
                    this.heap_max.add(the_nabla, i);
                    this.heap_min.add(the_nabla, i);
                }
                ++i;
lbl24:
                // 2 sources

                ** while (i < this.examples_total)
            }
        }
        new_ws = this.heap_min.get_values();
        this.working_set_size = 0;
        j = this.heap_min.size();
        i = 0;
        while (i < j) {
            this.working_set[this.working_set_size] = new_ws[i];
            ++this.working_set_size;
            ++i;
        }
        pos = this.working_set_size;
        new_ws = this.heap_max.get_values();
        j = this.heap_max.size();
        i = 0;
        while (i < j) {
            this.working_set[this.working_set_size] = new_ws[i];
            ++this.working_set_size;
            ++i;
        }
        if (!this.heap_min.empty() && !this.heap_max.empty() && this.heap_min.top_value() >= this.heap_max.top_value()) {
            j = 0;
            i = 0;
            while (i < pos) {
                j = pos;
                while (j < this.working_set_size && this.working_set[j] != this.working_set[i]) {
                    ++j;
                }
                if (j < this.working_set_size) {
                    this.working_set[j] = this.working_set[this.working_set_size - 1];
                    --this.working_set_size;
                    continue;
                }
                ++i;
            }
        }
        if (this.target_count > 1) {
            bounded_pos = true;
            bounded_neg = true;
            pos = 0;
            while (pos < this.working_set_size && (bounded_pos || bounded_neg)) {
                pos_abs = this.working_set[pos];
                alpha = this.alphas[pos_abs];
                if (alpha - this.C < -this.is_zero) {
                    bounded_pos = false;
                }
                if (alpha > this.is_zero) {
                    bounded_neg = false;
                }
                ++pos;
            }
            if (bounded_pos) {
                max_lambda = 1.7976931348623157E308;
                max_pos = this.examples_total;
                pos_abs = 0;
                while (pos_abs < this.examples_total) {
                    alpha = this.alphas[pos_abs];
                    if (alpha - this.C < -this.is_zero && this.lambda(pos_abs) < max_lambda) {
                        max_lambda = this.lambda(pos_abs);
                        max_pos = pos_abs;
                    }
                    ++pos_abs;
                }
                if (max_pos < this.examples_total) {
                    if (this.working_set_size < this.parameters_working_set_size) {
                        ++this.working_set_size;
                    }
                    this.working_set[this.working_set_size - 1] = max_pos;
                }
            } else if (bounded_neg) {
                max_lambda = 1.7976931348623157E308;
                max_pos = this.examples_total;
                pos_abs = 0;
                while (pos_abs < this.examples_total) {
                    alpha = this.alphas[pos_abs];
                    if (alpha > this.is_zero && this.lambda(pos_abs) < max_lambda) {
                        max_lambda = this.lambda(pos_abs);
                        max_pos = pos_abs;
                    }
                    ++pos_abs;
                }
                if (max_pos < this.examples_total) {
                    if (this.working_set_size < this.parameters_working_set_size) {
                        ++this.working_set_size;
                    }
                    this.working_set[this.working_set_size - 1] = max_pos;
                }
            }
        }
        if (this.working_set_size < this.parameters_working_set_size && this.working_set_size < this.examples_total) {
            pos = (int)(Math.random() * (double)this.examples_total);
            while (this.working_set_size < this.parameters_working_set_size && this.working_set_size < this.examples_total) {
                ok = true;
                i = 0;
                while (i < this.working_set_size) {
                    if (this.working_set[i] == pos) {
                        ok = false;
                        i = this.working_set_size;
                    }
                    ++i;
                }
                if (ok) {
                    this.working_set[this.working_set_size] = pos;
                    ++this.working_set_size;
                }
                pos = (pos + 1) % this.examples_total;
            }
        }
    }

    protected void update_working_set() {
        int pos_i = 0;
        while (pos_i < this.working_set_size) {
            int j;
            int i = this.working_set[pos_i];
            double[] kernel_row = this.kernel.get_row(i);
            double sum_WS = 0.0;
            int pos_j = 0;
            while (pos_j < pos_i) {
                j = this.working_set[pos_j];
                this.qp.H[pos_i * this.working_set_size + pos_j] = 2.0 * kernel_row[j];
                this.qp.H[pos_j * this.working_set_size + pos_i] = 2.0 * kernel_row[j];
                ++pos_j;
            }
            pos_j = 0;
            while (pos_j < this.working_set_size) {
                j = this.working_set[pos_j];
                sum_WS += this.alphas[j] * kernel_row[j];
                ++pos_j;
            }
            this.qp.H[pos_i * this.working_set_size + pos_i] = 2.0 * kernel_row[i];
            this.qp.A[pos_i] = 1.0;
            this.qp.c[pos_i] = 2.0 * (this.sum[i] - sum_WS) - this.K[i];
            this.primal[pos_i] = this.alphas[i];
            this.qp.u[pos_i] = this.C;
            ++pos_i;
        }
    }

    protected void init_working_set() {
        int j;
        this.project_to_constraint();
        int i = 0;
        while (i < this.examples_total) {
            this.sum[i] = 0.0;
            this.at_bound[i] = 0;
            this.K[i] = this.kernel.calculate_K(i, i);
            ++i;
        }
        i = 0;
        while (i < this.examples_total) {
            double alpha = this.alphas[i];
            if (alpha != 0.0) {
                double[] kernel_row = this.kernel.get_row(i);
                j = 0;
                while (j < this.examples_total) {
                    int n = j;
                    this.sum[n] = this.sum[n] + alpha * kernel_row[j];
                    ++j;
                }
            }
            ++i;
        }
        j = 0;
        i = 0;
        while (i < this.working_set_size && j < this.examples_total) {
            this.working_set[i] = j++;
            ++i;
        }
        this.working_set[this.working_set_size - 1] = this.examples_total - 1;
        this.update_working_set();
    }

    protected void optimize() {
        int j;
        double target_tmp;
        this.qp.b[0] = 0.0;
        int i = 0;
        while (i < this.working_set_size) {
            this.qp.b[0] = this.qp.b[0] + this.alphas[this.working_set[i]];
            ++i;
        }
        double[] my_primal = this.primal;
        double new_target = 0.0;
        double old_target = 0.0;
        i = 0;
        while (i < this.working_set_size) {
            target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
            j = 0;
            while (j < i) {
                target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
                ++j;
            }
            old_target += (target_tmp += this.qp.c[i]) * my_primal[i];
            ++i;
        }
        double new_constraint_sum = 0.0;
        double my_is_zero = this.is_zero;
        int sv_count = this.working_set_size;
        boolean KKTerror = true;
        boolean convError = false;
        this.qp.max_allowed_error = this.convergence_epsilon;
        this.qp.x = my_primal;
        this.qp.lambda_eq = this.lambda_eq;
        this.qp.solve();
        my_primal = this.qp.x;
        this.lambda_WS = this.qp.lambda_eq;
        while (KKTerror) {
            sv_count = this.working_set_size;
            new_constraint_sum = this.qp.b[0];
            i = 0;
            while (i < this.working_set_size) {
                if (my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.l[i];
                    --sv_count;
                } else if (this.qp.u[i] - my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.u[i];
                    --sv_count;
                }
                new_constraint_sum -= this.qp.A[i] * my_primal[i];
                ++i;
            }
            if (sv_count > 0) {
                this.logln(5, "adjusting " + sv_count + " alphas by " + (new_constraint_sum /= (double)sv_count));
                i = 0;
                while (i < this.working_set_size) {
                    if (my_primal[i] > this.qp.l[i] && my_primal[i] < this.qp.u[i]) {
                        int n = i;
                        my_primal[n] = my_primal[n] + this.qp.A[i] * new_constraint_sum;
                    }
                    ++i;
                }
            } else if (Math.abs(new_constraint_sum) > (double)this.working_set_size * this.is_zero) {
                this.logln(5, "WARNING: No SVs, constraint_sum = " + new_constraint_sum);
                old_target = Double.MIN_VALUE;
                new_target = Double.MAX_VALUE;
                convError = true;
                break;
            }
            new_target = 0.0;
            i = 0;
            while (i < this.working_set_size) {
                target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
                j = 0;
                while (j < i) {
                    target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
                    ++j;
                }
                new_target += (target_tmp += this.qp.c[i]) * my_primal[i];
                ++i;
            }
            if (new_target < old_target) {
                KKTerror = false;
                if (this.descend < old_target - new_target) {
                    this.target_count = 0;
                } else {
                    convError = true;
                }
                this.logln(5, "descend = " + (old_target - new_target));
                continue;
            }
            if (sv_count > 0) {
                my_is_zero = Double.MAX_VALUE;
                i = 0;
                while (i < this.working_set_size) {
                    if (my_primal[i] > this.qp.l[i] && my_primal[i] < this.qp.u[i]) {
                        if (my_primal[i] - this.qp.l[i] < my_is_zero) {
                            my_is_zero = my_primal[i] - this.qp.l[i];
                        }
                        if (this.qp.u[i] - my_primal[i] < my_is_zero) {
                            my_is_zero = this.qp.u[i] - my_primal[i];
                        }
                    }
                    ++i;
                }
                if (this.target_count == 0) {
                    my_is_zero *= 2.0;
                }
                this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), adjusting is_zero to " + my_is_zero);
                this.logln(5, "new_target = " + new_target);
                continue;
            }
            this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), stopping (it = " + this.target_count + ").");
            KKTerror = false;
            convError = true;
        }
        if (convError) {
            ++this.target_count;
            if (old_target < new_target) {
                i = 0;
                while (i < this.working_set_size) {
                    my_primal[i] = this.qp.A[i] * this.alphas[this.working_set[i]];
                    ++i;
                }
                this.logln(5, "WARNING: Convergence error, restoring old primals");
            }
        }
        if (this.target_count > 50) {
            this.convergence_epsilon *= 2.0;
            this.feasible_epsilon = this.convergence_epsilon;
            this.logln(1, "WARNING: reducing KKT precision to " + this.convergence_epsilon);
            this.target_count = 0;
        }
    }

    protected void put_optimizer_values() {
        int i = 0;
        int j = 0;
        double[] my_sum = this.sum;
        int pos_i = this.working_set_size;
        while (pos_i > 0) {
            double the_new_alpha = this.primal[--pos_i];
            i = this.working_set[pos_i];
            double alpha_diff = the_new_alpha - this.alphas[i];
            this.alphas[i] = the_new_alpha;
            if (alpha_diff == 0.0) continue;
            double[] kernel_row = this.kernel.get_row(i);
            j = this.examples_total - 1;
            while (j >= 0) {
                int n = j;
                my_sum[n] = my_sum[n] + alpha_diff * kernel_row[j];
                --j;
            }
        }
    }

    protected boolean convergence() {
        double the_lambda_eq = 0.0;
        int total = 0;
        double alpha_sum = 0.0;
        double alpha = 0.0;
        boolean result = true;
        total = 0;
        alpha_sum = 0.0;
        int i = 0;
        while (i < this.examples_total) {
            alpha = this.alphas[i];
            alpha_sum += alpha;
            if (alpha > 0.0 && alpha < this.C) {
                the_lambda_eq += -this.nabla(i);
                ++total;
            }
            ++i;
        }
        this.logln(4, "lambda_eq = " + the_lambda_eq / (double)total);
        if (total > 0) {
            this.lambda_eq = the_lambda_eq / (double)total;
        } else {
            double l_min = Double.MAX_VALUE;
            double l_max = Double.MIN_VALUE;
            i = 0;
            while (i < this.examples_total) {
                double nabla = -this.nabla(i);
                if (this.alphas[i] < this.is_zero) {
                    if (nabla > l_max) {
                        l_max = nabla;
                    }
                } else if (nabla < l_min) {
                    l_min = nabla;
                }
                ++i;
            }
            this.lambda_eq = (l_min + l_max) / 2.0;
            this.logln(4, "*** no SVs in convergence(), lambda_eq = " + this.lambda_eq + ".");
        }
        if (this.target_count > 2) {
            if (this.target_count > 20) {
                this.lambda_eq = ((double)(40 - this.target_count) * this.lambda_eq + (double)(this.target_count - 20) * this.lambda_WS) / 20.0;
                this.logln(5, "Re-Re-calculated lambda from WS: " + this.lambda_eq);
                if (this.target_count > 40) {
                    i = this.working_set[this.target_count % this.working_set_size];
                    this.lambda_eq = -this.nabla(i);
                    this.logln(5, "set lambda_eq to nabla(" + i + "): " + this.lambda_eq);
                }
            } else {
                this.lambda_eq = this.lambda_WS;
                this.logln(5, "Re-calculated lambda_eq from WS: " + this.lambda_eq);
            }
        }
        if (Math.abs(alpha_sum + this.sum_alpha - 1.0) > this.convergence_epsilon) {
            this.logln(4, "No convergence: equality constraint violated: |" + (alpha_sum + this.sum_alpha - 1.0) + "| >> 0");
            this.project_to_constraint();
            result = false;
        }
        i = 0;
        while (i < this.examples_total && result) {
            if (this.lambda(i) >= -this.convergence_epsilon) {
                ++i;
                continue;
            }
            result = false;
        }
        return result;
    }

    protected final double nabla(int i) {
        return -this.K[i] + 2.0 * this.sum[i];
    }

    protected double lambda(int i) {
        double result = -Math.abs(this.nabla(i) + this.lambda_eq);
        double alpha = this.alphas[i];
        if (alpha > this.is_zero) {
            if (alpha - this.C >= -this.is_zero) {
                result = -this.lambda_eq - this.nabla(i);
            }
        } else {
            result = this.nabla(i) + this.lambda_eq;
        }
        return result;
    }

    protected boolean feasible(int i) {
        boolean is_feasible = true;
        double alpha = this.alphas[i];
        double the_lambda = this.lambda(i);
        if (alpha - this.C >= -this.is_zero) {
            if (the_lambda >= 0.0) {
                int n = i;
                this.at_bound[n] = this.at_bound[n] + 1;
                if (this.at_bound[i] == this.shrink_const) {
                    ++this.to_shrink;
                }
            } else {
                this.at_bound[i] = 0;
            }
        } else if (alpha <= this.is_zero) {
            if (the_lambda >= 0.0) {
                int n = i;
                this.at_bound[n] = this.at_bound[n] + 1;
                if (this.at_bound[i] == this.shrink_const) {
                    ++this.to_shrink;
                }
            } else {
                this.at_bound[i] = 0;
            }
        } else {
            this.at_bound[i] = 0;
        }
        if (this.at_bound[i] >= this.shrink_const) {
            is_feasible = false;
        }
        return is_feasible;
    }

    protected void logln(int level, String message) {
        this.paramOperator.getLog().log(message, RAPID_MINER_VERBOSITY[level - 1]);
    }

    public void predict(SVMExamples to_predict) {
        int size = to_predict.count_examples();
        int i = 0;
        while (i < size) {
            SVMExample sVMExample = to_predict.get_example(i);
            double prediction = this.predict(sVMExample);
            to_predict.set_y(i, prediction);
            ++i;
        }
        this.logln(4, "Prediction generated");
    }

    public double predict(SVMExample sVMExample) {
        double the_sum = this.examples.get_b() + this.kernel.calculate_K(sVMExample, sVMExample);
        int i = 0;
        while (i < this.examples_total) {
            double alpha = this.alphas[i];
            if (alpha != 0.0) {
                int[] sv_index = this.examples.index[i];
                double[] sv_att = this.examples.atts[i];
                the_sum -= 2.0 * alpha * this.kernel.calculate_K(sv_index, sv_att, sVMExample.index, sVMExample.att);
            }
            ++i;
        }
        if (the_sum < 0.0) {
            the_sum = 0.0;
        }
        return Math.sqrt(the_sum);
    }

    protected void check() {
        int j;
        double tsum;
        double s = 0.0;
        int i = 0;
        while (i < this.examples_total) {
            tsum = 0.0;
            s += this.alphas[i];
            j = 0;
            while (j < this.examples.count_examples()) {
                tsum += this.alphas[j] * this.kernel.calculate_K(i, j);
                ++j;
            }
            if (Math.abs(tsum - this.sum[i]) > this.is_zero) {
                this.logln(1, "ERROR: sum[" + i + "] off by " + (tsum - this.sum[i]) + " (is " + this.sum[i] + ", should be " + tsum);
            }
            ++i;
        }
        tsum = 0.0;
        j = 0;
        while (j < this.examples.count_examples()) {
            tsum += this.alphas[j];
            ++j;
        }
        if (Math.abs(tsum - 1.0) > this.is_zero) {
            this.logln(1, "ERROR: sum over all alphas is off by " + (tsum - 1.0));
        }
        if (Math.abs(s + this.sum_alpha - 1.0) > this.is_zero) {
            this.logln(1, "ERROR: sum_alpha is off by " + (s + this.sum_alpha - 1.0));
        }
    }

    public double[] getWeights() {
        return null;
    }

    public void init(Kernel kernel_, SVMExamples examples_) {
        this.init(kernel_, (SVCExampleSet)examples_);
    }
}

