/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeWeights;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.gui.dialog.StopDialog;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ValueDouble;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.LastInnerOperatorCondition;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulation;
import com.rapidminer.operator.features.construction.ExampleSetBasedPopulationOperator;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.Tools;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExampleSetBasedFeatureOperator
extends OperatorChain {
    public static final String PARAMETER_LOCAL_RANDOM_SEED = "local_random_seed";
    public static final String PARAMETER_SHOW_STOP_DIALOG = "show_stop_dialog";
    public static final String PARAMETER_MAXIMAL_FITNESS = "maximal_fitness";
    private static final Class[] OUTPUT_CLASSES = new Class[]{ExampleSet.class, AttributeWeights.class, PerformanceVector.class};
    private static final Class[] INPUT_CLASSES = new Class[]{ExampleSet.class};
    private ExampleSetBasedPopulation population;
    private double maximalFitness = Double.POSITIVE_INFINITY;
    private boolean checkForMaximalFitness = true;
    private int evaluationCounter = 0;
    private int totalEvaluations = 0;
    private RandomGenerator random;

    public ExampleSetBasedFeatureOperator(OperatorDescription description) {
        super(description);
        this.addValue(new ValueDouble("generation", "The number of the current generation."){

            public double getDoubleValue() {
                if (ExampleSetBasedFeatureOperator.this.population == null) {
                    return 0.0;
                }
                return ExampleSetBasedFeatureOperator.this.population.getGeneration();
            }
        });
        this.addValue(new ValueDouble("performance", "The performance of the current generation (main criterion)."){

            public double getDoubleValue() {
                if (ExampleSetBasedFeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                if (ExampleSetBasedFeatureOperator.this.population.getCurrentBestPerformance() == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = ExampleSetBasedFeatureOperator.this.population.getCurrentBestPerformance();
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getAverage();
            }
        });
        this.addValue(new ValueDouble("best", "The performance of the best individual ever (main criterion)."){

            public double getDoubleValue() {
                if (ExampleSetBasedFeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = ExampleSetBasedFeatureOperator.this.population.getBestPerformanceEver();
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getAverage();
            }
        });
        this.addValue(new ValueDouble("average_length", "The average number of attributes."){

            public double getDoubleValue() {
                if (ExampleSetBasedFeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                double lengthSum = 0.0;
                int i = 0;
                while (i < ExampleSetBasedFeatureOperator.this.population.getNumberOfIndividuals()) {
                    lengthSum += (double)ExampleSetBasedFeatureOperator.this.population.get(i).getExampleSet().getNumberOfUsedAttributes();
                    ++i;
                }
                return lengthSum / (double)ExampleSetBasedFeatureOperator.this.population.getNumberOfIndividuals();
            }
        });
        this.addValue(new ValueDouble("best_length", "The number of attributes of the best example set."){

            public double getDoubleValue() {
                if (ExampleSetBasedFeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                ExampleSetBasedIndividual individual = ExampleSetBasedFeatureOperator.this.population.getBestIndividualEver();
                if (individual != null) {
                    AttributeWeightedExampleSet eSet = individual.getExampleSet();
                    if (eSet != null) {
                        return eSet.getNumberOfUsedAttributes();
                    }
                    return Double.NaN;
                }
                return Double.NaN;
            }
        });
    }

    public abstract ExampleSetBasedPopulation createInitialPopulation(ExampleSet var1) throws OperatorException;

    public abstract List<ExampleSetBasedPopulationOperator> getPreEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract List<ExampleSetBasedPopulationOperator> getPostEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract boolean solutionGoodEnough(ExampleSetBasedPopulation var1) throws OperatorException;

    @Override
    public Class<?>[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return INPUT_CLASSES;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        return new LastInnerOperatorCondition(new Class[]{ExampleSet.class}, new Class[]{PerformanceVector.class});
    }

    protected RandomGenerator getRandom() {
        return this.random;
    }

    protected ExampleSetBasedPopulation getPopulation() {
        return this.population;
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        this.random = RandomGenerator.getRandomGenerator(this.getParameterAsInt(PARAMETER_LOCAL_RANDOM_SEED));
        this.evaluationCounter = 0;
        this.totalEvaluations = 0;
        this.maximalFitness = this.getParameterAsDouble(PARAMETER_MAXIMAL_FITNESS);
        ExampleSet es = this.getInput(ExampleSet.class);
        if (es.getAttributes().size() == 0) {
            throw new UserError((Operator)this, 125, 0, 1);
        }
        List<ExampleSetBasedPopulationOperator> preOps = this.getPreEvaluationPopulationOperators(es);
        List<ExampleSetBasedPopulationOperator> postOps = this.getPostEvaluationPopulationOperators(es);
        boolean userDialogOk = true;
        StopDialog stopDialog = null;
        if (this.getParameterAsBoolean(PARAMETER_SHOW_STOP_DIALOG)) {
            stopDialog = new StopDialog("Stop Dialog", "<html>Press the stop button to abort the search for best feature space.<br>The best individual found so far is returned.</html>");
            stopDialog.setVisible(true);
        }
        this.population = this.createInitialPopulation(es);
        this.log("Initial population has " + this.population.getNumberOfIndividuals() + " individuals.");
        this.evaluate(this.population);
        while (userDialogOk && !this.solutionGoodEnough(this.population) && !this.isMaximumReached()) {
            this.population.nextGeneration();
            this.applyOpList(preOps, this.population);
            this.log(String.valueOf(Tools.ordinalNumber(this.population.getGeneration())) + " generation has " + this.population.getNumberOfIndividuals() + " individuals.");
            this.log("Evaluating " + Tools.ordinalNumber(this.population.getGeneration()) + " population.");
            this.evaluate(this.population);
            this.population.updateEvaluation();
            this.applyOpList(postOps, this.population);
            userDialogOk = stopDialog == null ? true : stopDialog.isStillRunning();
            this.inApplyLoop();
        }
        if (stopDialog != null) {
            stopDialog.setVisible(false);
            stopDialog.dispose();
        }
        this.applyOpList(postOps, this.population);
        this.log("Optimization finished. " + this.evaluationCounter + " / " + this.totalEvaluations + " evaluations performed.");
        ExampleSetBasedIndividual bestEver = this.population.getBestIndividualEver();
        AttributeWeightedExampleSet weightedResultSet = bestEver.getExampleSet();
        for (Attribute attribute : weightedResultSet.getAttributes()) {
            if (!Double.isNaN(weightedResultSet.getWeight(attribute))) continue;
            weightedResultSet.setWeight(attribute, 1.0);
        }
        AttributeWeights weights = weightedResultSet.getAttributeWeights();
        for (String name : weights.getAttributeNames()) {
            if (weightedResultSet.getAttributes().get(name) != null) continue;
            weights.setWeight(name, 0.0);
        }
        weights.normalize();
        return new IOObject[]{weightedResultSet.createCleanClone(), weights, bestEver.getPerformance()};
    }

    void applyOpList(List opList, ExampleSetBasedPopulation population) throws OperatorException {
        ListIterator i = opList.listIterator();
        while (i.hasNext()) {
            ExampleSetBasedPopulationOperator op = (ExampleSetBasedPopulationOperator)i.next();
            if (!op.performOperation(population.getGeneration())) continue;
            try {
                op.operate(population);
                int k = 0;
                while (k < population.getNumberOfIndividuals()) {
                    if (population.get(k).getExampleSet().getNumberOfUsedAttributes() <= 0) {
                        this.logError("Population operator " + op + " has produced an example set without attributes!");
                    }
                    ++k;
                }
            }
            catch (Exception e) {
                throw new UserError((Operator)this, (Throwable)e, 108, e.toString());
            }
        }
    }

    protected void evaluate(ExampleSetBasedPopulation population) throws OperatorException {
        int i = 0;
        while (i < population.getNumberOfIndividuals()) {
            this.evaluate(population.get(i));
            ++i;
        }
    }

    protected PerformanceVector evaluate(ExampleSetBasedIndividual individual) throws OperatorException {
        ++this.totalEvaluations;
        if (individual.getPerformance() != null) {
            return individual.getPerformance();
        }
        ++this.evaluationCounter;
        AttributeWeightedExampleSet clone = individual.getExampleSet().createCleanClone();
        IOObject[] operatorChainInput = new IOObject[]{clone};
        IOContainer innerResult = this.getInput().prepend(operatorChainInput);
        int i = 0;
        while (i < this.getNumberOfOperators()) {
            innerResult = this.getOperator(i).apply(innerResult);
            ++i;
        }
        PerformanceVector performanceVector = innerResult.remove(PerformanceVector.class);
        individual.setPerformance(performanceVector);
        return performanceVector;
    }

    private boolean isMaximumReached() {
        if (this.checkForMaximalFitness) {
            PerformanceVector pv = this.population.getBestPerformanceEver();
            if (pv == null) {
                return false;
            }
            if (pv.getMainCriterion().getFitness() == Double.POSITIVE_INFINITY) {
                return true;
            }
            if (pv.getMainCriterion().getMaxFitness() == pv.getMainCriterion().getFitness()) {
                return true;
            }
            return pv.getMainCriterion().getFitness() >= this.maximalFitness;
        }
        return false;
    }

    protected void setCheckForMaximum(boolean checkForMaximalFitness) {
        this.checkForMaximalFitness = checkForMaximalFitness;
    }

    protected boolean getCheckForMaximum() {
        return this.checkForMaximalFitness;
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInt(PARAMETER_LOCAL_RANDOM_SEED, "Use the given random seed instead of global random numbers (-1: use global).", -1, Integer.MAX_VALUE, -1));
        ParameterTypeBoolean type = new ParameterTypeBoolean(PARAMETER_SHOW_STOP_DIALOG, "Determines if a dialog with a button should be displayed which stops the run: the best individual is returned.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble(PARAMETER_MAXIMAL_FITNESS, "The optimization will stop if the fitness reaches the defined maximum.", 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        return types;
    }
}

