/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ResultObjectAdapter;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.clustering.ClusterModel;
import com.rapidminer.operator.clustering.HierarchicalClusterModel;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterModelWriter
extends Operator {
    public static final String PARAMETER_CLUSTER_MODEL_FILE = "cluster_model_file";

    public ClusterModelWriter(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        IOContainer container = this.getInput();
        ResultObjectAdapter model = null;
        if (container.contains(ClusterModel.class)) {
            model = this.getInput(ClusterModel.class);
        } else if (container.contains(HierarchicalClusterModel.class)) {
            model = this.getInput(HierarchicalClusterModel.class);
        } else {
            throw new UserError((Operator)this, 122, "ClusterModel or HierarchicalClusterModel");
        }
        File file = this.getParameterAsFile(PARAMETER_CLUSTER_MODEL_FILE, true);
        OutputStream out = null;
        try {
            try {
                out = new GZIPOutputStream(new FileOutputStream(file));
                model.write(out);
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 303, file, e.getMessage());
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logError("Cannot close stream to file " + file);
                }
            }
        }
        return new IOObject[]{model};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile(PARAMETER_CLUSTER_MODEL_FILE, "the file to which the cluster model is stored", "clm", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

