/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.io;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Model;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.io.AbstractModelLoader;
import com.rapidminer.operator.learner.weka.WekaClassifier;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.tools.WekaTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaModelLoader
extends AbstractModelLoader {
    public static final String PARAMETER_MODEL_FILE = "model_file";

    public WekaModelLoader(OperatorDescription description) {
        super(description);
    }

    @Override
    public Model read() throws OperatorException {
        File modelFile = this.getParameterAsFile(PARAMETER_MODEL_FILE);
        WekaClassifier model = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(modelFile));
            Classifier classifier = (Classifier)in.readObject();
            ExampleSet trainingExampleSet = null;
            try {
                Instances trainingInstances = (Instances)in.readObject();
                trainingExampleSet = WekaTools.toRapidMinerExampleSet(trainingInstances);
            }
            catch (Throwable e) {
                this.log("Problem during reading label information, just try without...");
            }
            in.close();
            model = new WekaClassifier(trainingExampleSet, "Weka Model", classifier);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 302, modelFile, e.getMessage());
        }
        return model;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeFile(PARAMETER_MODEL_FILE, "Filename containing the Weka model to load.", "model", false));
        return types;
    }
}

