/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions;

import Jama.Matrix;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.functions.LogisticRegressionModel;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.math.optimization.ec.es.ESOptimization;
import com.rapidminer.tools.math.optimization.ec.es.Individual;

public class LogisticRegressionOptimization
extends ESOptimization {
    private ExampleSet exampleSet;
    private Attribute label;
    private Attribute weight;
    private boolean addIntercept;
    LoggingHandler logging;

    public LogisticRegressionOptimization(ExampleSet exampleSet, boolean addIntercept, int initType, int maxIterations, int generationsWithoutImprovement, int popSize, int selectionType, double tournamentFraction, boolean keepBest, int mutationType, double crossoverProb, boolean showConvergencePlot, RandomGenerator random, LoggingHandler logging) {
        super(-1.0, 1.0, popSize, addIntercept ? exampleSet.getAttributes().size() + 1 : exampleSet.getAttributes().size(), initType, maxIterations, generationsWithoutImprovement, selectionType, tournamentFraction, keepBest, mutationType, crossoverProb, showConvergencePlot, false, random, logging);
        this.logging = logging;
        this.exampleSet = exampleSet;
        this.label = exampleSet.getAttributes().getLabel();
        this.weight = exampleSet.getAttributes().getWeight();
        this.addIntercept = addIntercept;
    }

    public PerformanceVector evaluateIndividual(Individual individual) {
        double[] beta = individual.getValues();
        double fitness = 0.0;
        for (Example example : this.exampleSet) {
            double eta = 0.0;
            int i = 0;
            for (Attribute attribute : example.getAttributes()) {
                double value = example.getValue(attribute);
                eta += beta[i] * value;
                ++i;
            }
            if (this.addIntercept) {
                eta += beta[beta.length - 1];
            }
            double pi = Math.exp(eta) / (1.0 + Math.exp(eta));
            double classValue = example.getValue(this.label);
            double currentFitness = classValue * Math.log(pi) + (1.0 - classValue) * Math.log(1.0 - pi);
            double weightValue = 1.0;
            if (this.weight != null) {
                weightValue = example.getValue(this.weight);
            }
            fitness += weightValue * currentFitness;
        }
        PerformanceVector performanceVector = new PerformanceVector();
        performanceVector.addCriterion(new EstimatedPerformance("log_reg_fitness", fitness, this.exampleSet.size(), false));
        return performanceVector;
    }

    public LogisticRegressionModel train() throws OperatorException {
        this.optimize();
        return new LogisticRegressionModel(this.exampleSet, this.getBestValuesEver(), this.estimateVariance(), this.addIntercept);
    }

    /*
     * Unable to fully structure code
     */
    private double[] estimateVariance() {
        block10: {
            beta = this.getBestValuesEver();
            hessian = new Matrix(beta.length, beta.length);
            for (Example example : this.exampleSet) {
                values = new double[beta.length];
                eta = 0.0;
                j = 0;
                for (Attribute attribute : example.getAttributes()) {
                    values[j] = value = example.getValue(attribute);
                    eta += beta[j] * value;
                    ++j;
                }
                if (this.addIntercept) {
                    values[beta.length - 1] = 1.0;
                    eta += beta[beta.length - 1];
                }
                pi = Math.exp(eta) / (1.0 + Math.exp(eta));
                weightValue = 1.0;
                if (this.weight != null) {
                    weightValue = example.getValue(this.weight);
                }
                x = 0;
                while (x < beta.length) {
                    y = 0;
                    while (y < beta.length) {
                        h = hessian.get(x, y) - values[x] * values[y] * weightValue * pi * (1.0 - pi);
                        hessian.set(x, y, h);
                        ++y;
                    }
                    ++x;
                }
            }
            variance = new double[beta.length];
            varianceCovarianceMatrix = null;
            try {
                varianceCovarianceMatrix = hessian.inverse();
                break block10;
            }
            catch (Exception e) {
                this.logging.logWarning("could not determine variance-covariance matrix, hessian is singular");
                j = 0;
                ** while (j < beta.length)
            }
lbl-1000:
            // 1 sources

            {
                variance[j] = NaN;
                ++j;
                continue;
            }
lbl42:
            // 1 sources

            return variance;
        }
        j = 0;
        while (j < beta.length) {
            variance[j] = Math.abs(varianceCovarianceMatrix.get(j, j));
            ++j;
        }
        return variance;
    }

    public void nextIteration() {
        double[] beta = this.getBestValuesEver();
        int i = 0;
        while (i < beta.length) {
            double minBound = this.getMin(i);
            double maxBound = this.getMax(i);
            if (beta[i] == minBound) {
                this.setMin(i, minBound -= 1.0);
                this.logging.log("decrease lower bound for beta(" + i + ") to + " + minBound);
            }
            if (beta[i] == maxBound) {
                this.setMax(i, maxBound += 1.0);
                this.logging.log("increase upper bound for beta(" + i + ") to + " + maxBound);
            }
            ++i;
        }
    }

    public PerformanceVector getPerformance() {
        double[] beta = this.getBestValuesEver();
        double numberOfSlopes = this.addIntercept ? beta.length - 1 : beta.length;
        double logLikelihood = this.getBestFitnessEver();
        double restrictedLogLikelihood = 0.0;
        double minusTwoLogLikelihood = 0.0;
        double modelChiSquared = 0.0;
        double goodnessOfFit = 0.0;
        double coxSnellRSquared = 0.0;
        double nagelkerkeRSquared = 0.0;
        double mcfaddenRSquared = 0.0;
        double AIC = 0.0;
        double BIC = 0.0;
        double weightSum = 0.0;
        double positiveSum = 0.0;
        for (Example example : this.exampleSet) {
            double eta = 0.0;
            int i = 0;
            for (Attribute attribute : example.getAttributes()) {
                double value = example.getValue(attribute);
                eta += beta[i] * value;
                ++i;
            }
            if (this.addIntercept) {
                eta += beta[beta.length - 1];
            }
            double pi = Math.exp(eta) / (1.0 + Math.exp(eta));
            double classValue = example.getValue(this.label);
            double currentFit = (classValue - pi) * (classValue - pi) / (pi * (1.0 - pi));
            double weightValue = 1.0;
            if (this.weight != null) {
                weightValue = example.getValue(this.weight);
            }
            weightSum += weightValue;
            positiveSum += weightValue * classValue;
            goodnessOfFit += weightValue * currentFit;
        }
        double pi0 = positiveSum / weightSum;
        restrictedLogLikelihood = this.addIntercept ? weightSum * (pi0 * Math.log(pi0) + (1.0 - pi0) * Math.log(1.0 - pi0)) : weightSum * Math.log(0.5);
        minusTwoLogLikelihood = -2.0 * logLikelihood;
        modelChiSquared = 2.0 * (logLikelihood - restrictedLogLikelihood);
        coxSnellRSquared = 1.0 - Math.pow(Math.exp(restrictedLogLikelihood) / Math.exp(logLikelihood), 2.0 / weightSum);
        nagelkerkeRSquared = coxSnellRSquared / (1.0 - Math.pow(Math.exp(restrictedLogLikelihood), 2.0 / weightSum));
        mcfaddenRSquared = 1.0 - logLikelihood / restrictedLogLikelihood;
        AIC = -2.0 * logLikelihood + 2.0 * (numberOfSlopes + 1.0);
        BIC = -2.0 * logLikelihood + Math.log(weightSum) * (numberOfSlopes + 1.0);
        PerformanceVector estimatedPerformance = new PerformanceVector();
        estimatedPerformance.addCriterion(new EstimatedPerformance("log_likelihood", logLikelihood, this.exampleSet.size(), false));
        estimatedPerformance.addCriterion(new EstimatedPerformance("restricted_log_likelihood", restrictedLogLikelihood, this.exampleSet.size(), false));
        estimatedPerformance.addCriterion(new EstimatedPerformance("-2_log_likelihood", minusTwoLogLikelihood, this.exampleSet.size(), true));
        estimatedPerformance.addCriterion(new EstimatedPerformance("model_chi_squared", modelChiSquared, this.exampleSet.size(), false));
        estimatedPerformance.addCriterion(new EstimatedPerformance("goodness_of_fit", goodnessOfFit, this.exampleSet.size(), false));
        estimatedPerformance.addCriterion(new EstimatedPerformance("cox_snell_r_squared", coxSnellRSquared, this.exampleSet.size(), false));
        estimatedPerformance.addCriterion(new EstimatedPerformance("nagelkerke_r_squared", nagelkerkeRSquared, this.exampleSet.size(), false));
        estimatedPerformance.addCriterion(new EstimatedPerformance("mcfadden_r_squared", mcfaddenRSquared, this.exampleSet.size(), false));
        estimatedPerformance.addCriterion(new EstimatedPerformance("AIC", AIC, this.exampleSet.size(), true));
        estimatedPerformance.addCriterion(new EstimatedPerformance("BIC", BIC, this.exampleSet.size(), true));
        estimatedPerformance.setMainCriterionName("AIC");
        return estimatedPerformance;
    }
}

