/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.functions.kernel.jmysvm.svm;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.examples.SVMExamples;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.kernel.Kernel;
import com.rapidminer.operator.learner.functions.kernel.jmysvm.svm.SVM;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.tools.RandomGenerator;

public class SVMregression
extends SVM {
    public SVMregression() {
    }

    public SVMregression(Operator paramOperator, Kernel kernel, SVMExamples sVMExamples, ExampleSet rapidMinerExamples, RandomGenerator randomGenerator) throws UndefinedParameterError {
        super(paramOperator, kernel, sVMExamples, rapidMinerExamples, randomGenerator);
    }

    protected void optimize() {
        int j;
        double target_tmp;
        double[] my_primal = this.primal;
        this.qp.b[0] = 0.0;
        int i = 0;
        while (i < this.working_set_size) {
            this.qp.b[0] = this.qp.b[0] + this.alphas[this.working_set[i]];
            ++i;
        }
        double new_target = 0.0;
        double old_target = 0.0;
        i = 0;
        while (i < this.working_set_size) {
            target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
            j = 0;
            while (j < i) {
                target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
                ++j;
            }
            old_target += (target_tmp += this.qp.c[i]) * my_primal[i];
            ++i;
        }
        double new_constraint_sum = 0.0;
        double my_is_zero = this.is_zero;
        int sv_count = this.working_set_size;
        boolean KKTerror = true;
        boolean convError = false;
        this.qp.max_allowed_error = this.convergence_epsilon;
        this.qp.x = this.primal;
        this.qp.solve();
        this.primal = this.qp.x;
        this.lambda_WS = this.qp.lambda_eq;
        my_primal = this.primal;
        int it = 3;
        while (KKTerror && it > 0) {
            KKTerror = false;
            --it;
            i = 0;
            while (i < this.working_set_size) {
                if (my_primal[i] < this.is_zero) {
                    double lambda_lo = this.epsilon_neg + this.epsilon_pos - this.qp.c[i];
                    j = 0;
                    while (j < this.working_set_size) {
                        lambda_lo -= my_primal[j] * this.qp.H[i * this.working_set_size + j];
                        ++j;
                    }
                    lambda_lo = this.qp.A[i] > 0.0 ? (lambda_lo -= this.lambda_WS) : (lambda_lo += this.lambda_WS);
                    if (lambda_lo < -this.convergence_epsilon) {
                        KKTerror = true;
                        this.qp.A[i] = -this.qp.A[i];
                        this.which_alpha[i] = !this.which_alpha[i];
                        my_primal[i] = -my_primal[i];
                        this.qp.c[i] = this.epsilon_neg + this.epsilon_pos - this.qp.c[i];
                        this.qp.u[i] = this.qp.A[i] > 0.0 ? this.cNeg[this.working_set[i]] : this.cPos[this.working_set[i]];
                        j = 0;
                        while (j < this.working_set_size) {
                            this.qp.H[i * this.working_set_size + j] = -this.qp.H[i * this.working_set_size + j];
                            this.qp.H[j * this.working_set_size + i] = -this.qp.H[j * this.working_set_size + i];
                            ++j;
                        }
                        if (this.quadraticLossNeg) {
                            if (this.which_alpha[i]) {
                                int n = i * (this.working_set_size + 1);
                                this.qp.H[n] = this.qp.H[n] + 1.0 / this.cNeg[this.working_set[i]];
                                this.qp.u[i] = Double.MAX_VALUE;
                            } else {
                                int n = i * (this.working_set_size + 1);
                                this.qp.H[n] = this.qp.H[n] - 1.0 / this.cNeg[this.working_set[i]];
                            }
                        }
                        if (this.quadraticLossPos) {
                            if (!this.which_alpha[i]) {
                                int n = i * (this.working_set_size + 1);
                                this.qp.H[n] = this.qp.H[n] + 1.0 / this.cPos[this.working_set[i]];
                                this.qp.u[i] = Double.MAX_VALUE;
                            } else {
                                int n = i * (this.working_set_size + 1);
                                this.qp.H[n] = this.qp.H[n] - 1.0 / this.cPos[this.working_set[i]];
                            }
                        }
                    }
                }
                ++i;
            }
            this.qp.x = my_primal;
            this.qp.solve();
            my_primal = this.qp.x;
            this.lambda_WS = this.qp.lambda_eq;
        }
        KKTerror = true;
        while (KKTerror) {
            sv_count = this.working_set_size;
            new_constraint_sum = this.qp.b[0];
            i = 0;
            while (i < this.working_set_size) {
                if (my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.l[i];
                    --sv_count;
                } else if (this.qp.u[i] - my_primal[i] <= my_is_zero) {
                    my_primal[i] = this.qp.u[i];
                    --sv_count;
                }
                new_constraint_sum -= this.qp.A[i] * my_primal[i];
                ++i;
            }
            if (sv_count > 0) {
                this.logln(5, "adjusting " + sv_count + " alphas by " + (new_constraint_sum /= (double)sv_count));
                i = 0;
                while (i < this.working_set_size) {
                    if (my_primal[i] > this.qp.l[i] && my_primal[i] < this.qp.u[i]) {
                        int n = i;
                        my_primal[n] = my_primal[n] + this.qp.A[i] * new_constraint_sum;
                    }
                    ++i;
                }
            } else if (Math.abs(new_constraint_sum) > (double)this.working_set_size * this.is_zero) {
                this.logln(5, "WARNING: No SVs, constraint_sum = " + new_constraint_sum);
                old_target = -4.9E-324;
                convError = true;
            }
            new_target = 0.0;
            i = 0;
            while (i < this.working_set_size) {
                target_tmp = my_primal[i] * this.qp.H[i * this.working_set_size + i] / 2.0;
                j = 0;
                while (j < i) {
                    target_tmp += my_primal[j] * this.qp.H[j * this.working_set_size + i];
                    ++j;
                }
                new_target += (target_tmp += this.qp.c[i]) * my_primal[i];
                ++i;
            }
            if (new_target < old_target) {
                KKTerror = false;
                if (this.descend < old_target - new_target) {
                    this.target_count = 0;
                } else {
                    convError = true;
                }
                this.logln(5, "descend = " + (old_target - new_target));
                continue;
            }
            if (sv_count > 0) {
                my_is_zero = Double.MAX_VALUE;
                i = 0;
                while (i < this.working_set_size) {
                    if (my_primal[i] > this.qp.l[i] && my_primal[i] < this.qp.u[i]) {
                        if (my_primal[i] - this.qp.l[i] < my_is_zero) {
                            my_is_zero = my_primal[i] - this.qp.l[i];
                        }
                        if (this.qp.u[i] - my_primal[i] < my_is_zero) {
                            my_is_zero = this.qp.u[i] - my_primal[i];
                        }
                    }
                    ++i;
                }
                if (this.target_count == 0) {
                    my_is_zero *= 2.0;
                }
                this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), adjusting is_zero to " + my_is_zero);
                this.logln(5, "new_target = " + new_target);
                continue;
            }
            this.logln(5, "WARNING: no descend (" + (old_target - new_target) + " <= " + this.descend + "), stopping.");
            KKTerror = false;
            convError = true;
        }
        if (convError) {
            ++this.target_count;
            if (old_target < new_target) {
                i = 0;
                while (i < this.working_set_size) {
                    my_primal[i] = this.qp.A[i] * this.alphas[this.working_set[i]];
                    ++i;
                }
                this.logln(5, "WARNING: Convergence error, restoring old primals");
            }
        }
        if (this.target_count > 50) {
            this.convergence_epsilon *= 2.0;
            this.feasible_epsilon = this.convergence_epsilon;
            this.logln(1, "WARNING: reducing KKT precision to " + this.convergence_epsilon);
            this.target_count = 0;
        }
    }

    protected final boolean is_alpha_neg(int i) {
        double alpha = this.alphas[i];
        boolean result = alpha > 0.0 ? true : (alpha == 0.0 ? !(this.sum[i] - this.ys[i] + this.lambda_eq > 0.0) : false);
        return result;
    }

    protected final double nabla(int i) {
        double alpha = this.alphas[i];
        double y = this.ys[i];
        double result = alpha > 0.0 ? this.sum[i] - y + this.epsilon_neg : (alpha == 0.0 ? (this.is_alpha_neg(i) ? this.sum[i] - y + this.epsilon_neg : -this.sum[i] + y + this.epsilon_pos) : -this.sum[i] + y + this.epsilon_pos);
        return result;
    }
}

