/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.igss.utility;

import com.rapidminer.operator.learner.igss.hypothesis.Hypothesis;
import com.rapidminer.operator.learner.igss.utility.AbstractUtility;

public abstract class InstanceAveraging
extends AbstractUtility {
    public InstanceAveraging(double[] priors, int large) {
        super(priors, large);
    }

    public double confidenceIntervall(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        if (totalWeight < (double)this.large) {
            return this.confSmallM(totalWeight, delta);
        }
        return this.conf(totalWeight, totalPositiveWeight, hypo, delta);
    }

    public double conf(double totalWeight, double delta) {
        return this.inverseNormal(1.0 - delta / 2.0) / (2.0 * Math.sqrt(totalWeight));
    }

    public double conf(double totalWeight, double totalPositiveWeight, Hypothesis hypo, double delta) {
        return this.inverseNormal(1.0 - delta / 2.0) * this.variance(totalWeight, totalPositiveWeight, hypo);
    }

    public abstract double variance(double var1, double var3, Hypothesis var5);

    public double confSmallM(double totalWeight, double delta) {
        return Math.sqrt(Math.log(2.0 / delta) / (2.0 * totalWeight));
    }
}

