/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.tree;

import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.gui.graphs.GraphViewer;
import com.rapidminer.gui.graphs.TreeModelGraphCreator;
import com.rapidminer.gui.tools.JRadioSelectionPanel;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.SimplePredictionModel;
import com.rapidminer.operator.learner.tree.Edge;
import com.rapidminer.operator.learner.tree.SplitCondition;
import com.rapidminer.operator.learner.tree.Tree;
import java.awt.Component;
import java.util.Iterator;

public class TreeModel
extends SimplePredictionModel {
    private static final long serialVersionUID = 4368631725370998591L;
    private Tree root;

    public TreeModel(ExampleSet exampleSet, Tree root) {
        super(exampleSet);
        this.root = root;
    }

    public Tree getRoot() {
        return this.root;
    }

    public double predict(Example example) throws OperatorException {
        return this.predict(example, this.root);
    }

    private double predict(Example example, Tree node) {
        if (node.isLeaf()) {
            Iterator<String> s = node.getCounterMap().keySet().iterator();
            int[] counts = new int[this.getLabel().getMapping().size()];
            int sum = 0;
            while (s.hasNext()) {
                String className = s.next();
                int count = node.getCount(className);
                int index = this.getLabel().getMapping().getIndex(className);
                counts[index] = count;
                sum += count;
            }
            int i = 0;
            while (i < counts.length) {
                example.setConfidence(this.getLabel().getMapping().mapIndex(i), (double)counts[i] / (double)sum);
                ++i;
            }
            return this.getLabel().getMapping().getIndex(node.getLabel());
        }
        Iterator<Edge> childIterator = node.childIterator();
        while (childIterator.hasNext()) {
            Edge edge = childIterator.next();
            SplitCondition condition = edge.getCondition();
            if (!condition.test(example)) continue;
            return this.predict(example, edge.getChild());
        }
        String majorityClass = null;
        int majorityCounter = -1;
        Iterator<String> s = node.getCounterMap().keySet().iterator();
        int[] counts = new int[this.getLabel().getMapping().size()];
        int sum = 0;
        while (s.hasNext()) {
            String className = s.next();
            int count = node.getCount(className);
            int index = this.getLabel().getMapping().getIndex(className);
            counts[index] = count;
            sum += count;
            if (count <= majorityCounter) continue;
            majorityCounter = count;
            majorityClass = className;
        }
        int i = 0;
        while (i < counts.length) {
            example.setConfidence(this.getLabel().getMapping().mapIndex(i), (double)counts[i] / (double)sum);
            ++i;
        }
        if (majorityClass != null) {
            return this.getLabel().getMapping().getIndex(majorityClass);
        }
        return 0.0;
    }

    public String toString() {
        return this.root.toString();
    }

    public Component getVisualizationComponent(IOContainer container) {
        JRadioSelectionPanel mainPanel = new JRadioSelectionPanel();
        GraphViewer<String, String> graphViewer = new GraphViewer<String, String>(new TreeModelGraphCreator(this));
        Component textView = super.getVisualizationComponent(container);
        mainPanel.addComponent("Graph View", graphViewer, "Changes to a graphical view of this model.");
        mainPanel.addComponent("Text View", textView, "Changes to a textual view of this model.");
        return mainPanel;
    }
}

