/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.meta;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorChain;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.condition.InnerOperatorCondition;
import com.rapidminer.operator.condition.SimpleChainInnerOperatorCondition;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeInnerOperator;
import com.rapidminer.parameter.UndefinedParameterError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperatorEnabler
extends OperatorChain {
    public static final String PARAMETER_OPERATOR_NAME = "operator_name";
    public static final String PARAMETER_ENABLE = "enable";

    public OperatorEnabler(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        String operatorName = this.getParameterAsString(PARAMETER_OPERATOR_NAME);
        Operator operator = this.getProcess().getOperator(operatorName);
        if (operator == null) {
            throw new UserError((Operator)this, 109, operatorName);
        }
        operator.setEnabled(this.getParameterAsBoolean(PARAMETER_ENABLE));
        return super.apply();
    }

    @Override
    public boolean shouldReturnInnerOutput() {
        return true;
    }

    @Override
    public InnerOperatorCondition getInnerOperatorCondition() {
        try {
            Operator operator;
            String operatorName = this.getParameterAsString(PARAMETER_OPERATOR_NAME);
            if (operatorName != null && (operator = this.getProcess().getOperator(operatorName)) != null) {
                operator.setEnabled(this.getParameterAsBoolean(PARAMETER_ENABLE));
            }
        }
        catch (UndefinedParameterError undefinedParameterError) {
            // empty catch block
        }
        return new SimpleChainInnerOperatorCondition();
    }

    @Override
    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    @Override
    public boolean getAddOnlyAdditionalOutput() {
        return true;
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[0];
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[0];
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeInnerOperator(PARAMETER_OPERATOR_NAME, "The name of the operator which should be disabled or enabled"));
        types.add(new ParameterTypeBoolean(PARAMETER_ENABLE, "Indicates if the operator should be enabled (true) or disabled (false)", false));
        return types;
    }
}

