/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.MeasuredPerformance;
import com.rapidminer.tools.math.Averagable;

public class CorrelationCriterion
extends MeasuredPerformance {
    private static final long serialVersionUID = -8789903466296509903L;
    private Attribute labelAttribute;
    private Attribute predictedLabelAttribute;
    private Attribute weightAttribute;
    private double exampleCount = 0.0;
    private double sumLabel;
    private double sumPredict;
    private double sumLabelPredict;
    private double sumLabelSqr;
    private double sumPredictSqr;

    public CorrelationCriterion() {
    }

    public CorrelationCriterion(CorrelationCriterion sc) {
        super(sc);
        this.sumLabelPredict = sc.sumLabelPredict;
        this.sumLabelSqr = sc.sumLabelSqr;
        this.sumPredictSqr = sc.sumPredictSqr;
        this.sumLabel = sc.sumLabel;
        this.sumPredict = sc.sumPredict;
        this.exampleCount = sc.exampleCount;
        this.labelAttribute = (Attribute)sc.labelAttribute.clone();
        this.predictedLabelAttribute = (Attribute)sc.predictedLabelAttribute.clone();
        if (sc.weightAttribute != null) {
            this.weightAttribute = (Attribute)sc.weightAttribute.clone();
        }
    }

    public double getExampleCount() {
        return this.exampleCount;
    }

    public double getMaxFitness() {
        return 1.0;
    }

    public void countExample(Example example) {
        double prod;
        double label = example.getValue(this.labelAttribute);
        double plabel = example.getValue(this.predictedLabelAttribute);
        if (this.labelAttribute.isNominal()) {
            String predLabelString = this.predictedLabelAttribute.getMapping().mapIndex((int)plabel);
            plabel = this.labelAttribute.getMapping().getIndex(predLabelString);
        }
        double weight = 1.0;
        if (this.weightAttribute != null) {
            weight = example.getValue(this.weightAttribute);
        }
        if (!Double.isNaN(prod = label * plabel * weight)) {
            this.sumLabelPredict += prod;
            this.sumLabel += label;
            this.sumLabelSqr += label * label;
            this.sumPredict += plabel;
            this.sumPredictSqr += plabel * plabel;
            this.exampleCount += weight;
        }
    }

    public String getDescription() {
        return "Returns the correlation coefficient between the label and predicted label.";
    }

    public double getMikroAverage() {
        double r = (this.exampleCount * this.sumLabelPredict - this.sumLabel * this.sumPredict) / Math.sqrt((this.exampleCount * this.sumLabelSqr - this.sumLabel * this.sumLabel) * (this.exampleCount * this.sumPredictSqr - this.sumPredict * this.sumPredict));
        return r;
    }

    public double getMikroVariance() {
        return Double.NaN;
    }

    public void startCounting(ExampleSet eset, boolean useExampleWeights) throws OperatorException {
        super.startCounting(eset, useExampleWeights);
        this.exampleCount = 0.0;
        this.sumPredictSqr = 0.0;
        this.sumLabelSqr = 0.0;
        this.sumPredict = 0.0;
        this.sumLabel = 0.0;
        this.sumLabelPredict = 0.0;
        this.labelAttribute = eset.getAttributes().getLabel();
        this.predictedLabelAttribute = eset.getAttributes().getPredictedLabel();
        if (useExampleWeights) {
            this.weightAttribute = eset.getAttributes().getWeight();
        }
    }

    public void buildSingleAverage(Averagable performance) {
        CorrelationCriterion other = (CorrelationCriterion)performance;
        this.sumLabelPredict += other.sumLabelPredict;
        this.sumLabelSqr += other.sumLabelSqr;
        this.sumPredictSqr += other.sumPredictSqr;
        this.sumLabel += other.sumLabel;
        this.sumPredict += other.sumPredict;
        this.exampleCount += other.exampleCount;
    }

    public double getFitness() {
        return this.getAverage();
    }

    public String getName() {
        return "correlation";
    }
}

