/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.performance;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.performance.EstimatedPerformance;
import com.rapidminer.operator.performance.PerformanceCriterion;
import com.rapidminer.operator.performance.PerformanceVector;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeDouble;
import com.rapidminer.parameter.ParameterTypeList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedPerformanceCreator
extends Operator {
    public static final String PARAMETER_DEFAULT_WEIGHT = "default_weight";
    public static final String PARAMETER_CRITERIA_WEIGHTS = "criteria_weights";

    public WeightedPerformanceCreator(OperatorDescription description) {
        super(description);
    }

    @Override
    public IOObject[] apply() throws OperatorException {
        PerformanceVector inputPerformance = this.getInput(PerformanceVector.class);
        HashMap<String, Double> weightMap = new HashMap<String, Double>();
        List<String[]> weightList = this.getParameterList(PARAMETER_CRITERIA_WEIGHTS);
        for (String[] entry : weightList) {
            String criterionName = entry[0];
            Double criterionWeight = Double.valueOf(entry[1]);
            weightMap.put(criterionName, criterionWeight);
        }
        double defaultWeight = this.getParameterAsDouble(PARAMETER_DEFAULT_WEIGHT);
        double sum = 0.0;
        double weightSum = 0.0;
        int j = 0;
        while (j < inputPerformance.getSize()) {
            PerformanceCriterion pc = inputPerformance.getCriterion(j);
            Double weightObject = (Double)weightMap.get(pc.getName());
            double weight = weightObject != null ? weightObject : defaultWeight;
            sum += weight * pc.getFitness();
            weightSum += weight;
            ++j;
        }
        PerformanceVector performance = new PerformanceVector();
        performance.addCriterion(new EstimatedPerformance("weighted_performance", sum /= weightSum, 1, false));
        return new IOObject[]{performance};
    }

    @Override
    public Class<?>[] getInputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public Class<?>[] getOutputClasses() {
        return new Class[]{PerformanceVector.class};
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeDouble(PARAMETER_DEFAULT_WEIGHT, "The default weight for all criteria not specified in the list 'criteria_weights'.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeList(PARAMETER_CRITERIA_WEIGHTS, "The weights for several performance criteria. Criteria weights not defined in this list are set to 'default_weight'.", new ParameterTypeDouble("criteria_weight", "The weight for the criteria with the given name", 0.0, Double.POSITIVE_INFINITY, 1.0)));
        return types;
    }
}

