/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueTrim
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_APPLY_TO_SPECIAL_FEATURES = "apply_to_special_features";

    public AttributeValueTrim(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        String regex = this.getParameterAsString(PARAMETER_ATTRIBUTES);
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, e.getMessage());
        }
        Iterator<Attribute> i = exampleSet.getAttributes().iterator();
        if (this.getParameterAsBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES)) {
            i = exampleSet.getAttributes().allAttributes();
        }
        LinkedList<Attribute> matchingAttributes = new LinkedList<Attribute>();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            Matcher matcher = pattern.matcher(attribute.getName());
            if (matcher.matches()) {
                if (attribute.isNominal()) {
                    matchingAttributes.add(attribute);
                } else {
                    this.logWarning("Cannot trim value for non-nominal attribute '" + attribute.getName() + "', skipping...");
                }
            }
            this.checkForStop();
        }
        for (Attribute attribute : matchingAttributes) {
            Attribute newAttribute = this.createTrimmedAttribute(exampleSet, attribute);
            AttributeRole role = exampleSet.getAttributes().getRole(attribute);
            exampleSet.getAttributes().remove(attribute);
            newAttribute.setName(attribute.getName());
            if (!role.isSpecial()) continue;
            String specialName = role.getSpecialName();
            exampleSet.getAttributes().setSpecialAttribute(newAttribute, specialName);
        }
        return exampleSet;
    }

    private Attribute createTrimmedAttribute(ExampleSet exampleSet, Attribute originalAttribute) {
        Attribute newAttribute = AttributeFactory.createAttribute(1);
        exampleSet.getExampleTable().addAttribute(newAttribute);
        exampleSet.getAttributes().addRegular(newAttribute);
        for (Example example : exampleSet) {
            double value = example.getValue(originalAttribute);
            if (Double.isNaN(value)) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            String stringValue = originalAttribute.getMapping().mapIndex((int)value);
            String newValue = stringValue.trim();
            if (newValue.length() == 0) {
                example.setValue(newAttribute, Double.NaN);
                continue;
            }
            example.setValue(newAttribute, newAttribute.getMapping().mapString(newValue));
        }
        return newAttribute;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString(PARAMETER_ATTRIBUTES, "Substring creation of values will be applied to the attributes that match the given regular expression.", false);
        types.add(type);
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_TO_SPECIAL_FEATURES, "Filter also special attributes (label, id...)", false));
        return types;
    }
}

