/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeAttributeNames2Generic
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTES = "attributes";
    public static final String PARAMETER_APPLY_ON_SPECIAL = "apply_on_special";

    public ChangeAttributeNames2Generic(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Pattern attributeFilter = Pattern.compile(this.getParameterAsString(PARAMETER_ATTRIBUTES));
        int counter = 1;
        if (this.getParameterAsBoolean(PARAMETER_APPLY_ON_SPECIAL)) {
            Iterator<Attribute> a = exampleSet.getAttributes().allAttributes();
            while (a.hasNext()) {
                Attribute attribute = a.next();
                String name = attribute.getName();
                if (!attributeFilter.matcher(name).matches()) continue;
                attribute.setName("att" + counter++);
            }
        } else {
            for (Attribute attribute : exampleSet.getAttributes()) {
                String name = attribute.getName();
                if (!attributeFilter.matcher(name).matches()) continue;
                attribute.setName("att" + counter++);
            }
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTES, "A regular expression defining a filter for the attribute names for which the replace operation should be performed.", ".*"));
        types.add(new ParameterTypeBoolean(PARAMETER_APPLY_ON_SPECIAL, "Indicates if this name replacement should also be performed for special attributes.", false));
        return types;
    }
}

