/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterTypeSingle;

public class ParameterTypeCategory
extends ParameterTypeSingle {
    private static final long serialVersionUID = 5747692587025691591L;
    private int defaultValue = 0;
    private String[] categories = new String[0];

    public ParameterTypeCategory(String key, String description, String[] categories, int defaultValue) {
        super(key, description);
        this.categories = categories;
        this.defaultValue = defaultValue;
    }

    public boolean isOptional() {
        return super.isOptional() && this.defaultValue == -1;
    }

    public int getDefault() {
        return this.defaultValue;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == -1) {
            return null;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = (Integer)defaultValue;
    }

    public boolean isNumerical() {
        return false;
    }

    public String getCategory(int index) {
        return this.categories[index];
    }

    public int getIndex(String string) {
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i].equals(string)) {
                return i;
            }
            ++i;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String toString(Object value) {
        try {
            int index = Integer.parseInt(value.toString());
            return super.toString(this.categories[index]);
        }
        catch (NumberFormatException e) {
            return super.toString(value);
        }
    }

    public String[] getValues() {
        return this.categories;
    }

    public String getRange() {
        StringBuffer values = new StringBuffer();
        int i = 0;
        while (i < this.categories.length) {
            if (i > 0) {
                values.append(", ");
            }
            values.append(this.categories[i]);
            ++i;
        }
        return String.valueOf(values.toString()) + "; default: " + this.categories[this.defaultValue];
    }

    public int getNumberOfCategories() {
        return this.categories.length;
    }
}

