/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.parameter;

import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.Parameters;
import com.rapidminer.tools.Tools;
import java.util.LinkedList;
import java.util.List;

public class ParameterTypeList
extends ParameterType {
    private static final long serialVersionUID = -6101604413822993455L;
    private List defaultList = new LinkedList();
    private ParameterType valueType;

    public ParameterTypeList(String key, String description, ParameterType valueType) {
        this(key, description, valueType, new LinkedList());
    }

    public ParameterTypeList(String key, String description, ParameterType valueType, List defaultList) {
        super(key, description);
        this.defaultList = defaultList;
        this.valueType = valueType;
        if (valueType.getDescription() == null) {
            valueType.setDescription(description);
        }
    }

    public ParameterType getValueType() {
        return this.valueType;
    }

    public Object getDefaultValue() {
        return this.defaultList;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultList = (List)defaultValue;
    }

    public boolean isNumerical() {
        return false;
    }

    public String getXML(String indent, String key, String value, boolean hideDefault) {
        StringBuffer result = new StringBuffer();
        result.append(String.valueOf(indent) + "<list key=\"" + key + "\">" + Tools.getLineSeparator());
        if (value != null) {
            List<String[]> list = Parameters.transformString2List(value);
            for (Object[] objectArray : list) {
                result.append(this.valueType.getXML(String.valueOf(indent) + "  ", (String)objectArray[0], objectArray[1].toString(), false));
            }
        } else {
            Object defaultValue = this.getDefaultValue();
            if (defaultValue != null) {
                List defaultList = (List)defaultValue;
                for (Object[] current : defaultList) {
                    result.append(this.valueType.getXML(String.valueOf(indent) + "  ", (String)current[0], current[1].toString(), false));
                }
            }
        }
        result.append(String.valueOf(indent) + "</list>" + Tools.getLineSeparator());
        return result.toString();
    }

    public String getRange() {
        return "list";
    }
}

