/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.jdbc;

import com.rapidminer.tools.jdbc.JDBCProperties;

public class ColumnIdentifier {
    private String tableName;
    private String columnName;

    public ColumnIdentifier(String tableName, String columnName) {
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFullName(JDBCProperties properties, boolean singleTable) {
        if (singleTable) {
            return String.valueOf(properties.getIdentifierQuoteOpen()) + this.columnName + properties.getIdentifierQuoteClose();
        }
        return String.valueOf(properties.getIdentifierQuoteOpen()) + this.tableName + properties.getIdentifierQuoteClose() + "." + properties.getIdentifierQuoteOpen() + this.columnName + properties.getIdentifierQuoteClose();
    }

    public String getAliasName(JDBCProperties properties, boolean singleTable) {
        if (singleTable) {
            return String.valueOf(properties.getIdentifierQuoteOpen()) + this.columnName + properties.getIdentifierQuoteClose();
        }
        return String.valueOf(properties.getIdentifierQuoteOpen()) + this.tableName + "__" + this.columnName + properties.getIdentifierQuoteClose();
    }

    public String toString() {
        return String.valueOf(this.tableName) + "." + this.columnName;
    }
}

