/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.function.window;

import com.rapidminer.tools.math.function.window.WindowFunction;

public class GaussianWindowFunction
extends WindowFunction {
    private double sigma;

    public GaussianWindowFunction(Integer width, double sigma) {
        super(width);
        this.sigma = sigma;
    }

    public GaussianWindowFunction(Integer width, Integer justification) {
        this(width, justification, 0.5);
    }

    public GaussianWindowFunction(Integer width, Integer justification, double sigma) {
        super(width, justification);
        this.sigma = sigma;
    }

    protected double getValue(int width, int n) {
        double term = (double)(2 * n) / (this.sigma * (double)(width - 1)) - 1.0 / this.sigma;
        return Math.exp(-0.5 * term * term);
    }
}

