/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.kernels;

import com.rapidminer.tools.Tools;
import com.rapidminer.tools.math.kernels.Kernel;

public class MultiquadricKernel
extends Kernel {
    private static final long serialVersionUID = -7896178642575555770L;
    private double sigma = 1.0;
    private double shift = 1.0;

    public int getType() {
        return 7;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public double getShift() {
        return this.shift;
    }

    public double calculateDistance(double[] x1, double[] x2) {
        return Math.sqrt(this.norm2(x1, x2) / this.sigma + this.shift * this.shift);
    }

    public String getDistanceFormula(double[] x, String[] attributeConstructions) {
        StringBuffer norm2Expression = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < x.length) {
            double value = x[i];
            String valueString = "(" + value + " - " + attributeConstructions[i] + ")";
            if (first) {
                norm2Expression.append(String.valueOf(valueString) + " * " + valueString);
            } else {
                norm2Expression.append(" + " + valueString + " * " + valueString);
            }
            first = false;
            ++i;
        }
        return "sqrt((" + norm2Expression + " / " + this.sigma + ") + (" + this.shift + " * " + this.shift + "))";
    }

    public String toString() {
        return "Multiquadric Kernel with" + Tools.getLineSeparator() + "  sigma: " + Tools.formatNumber(this.getSigma()) + Tools.getLineSeparator() + "  shift: " + Tools.formatNumber(this.getShift());
    }
}

