/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.similarity.numerical;

import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.tools.math.similarity.SimilarityMeasure;

public class JaccardNumericalSimilarity
extends SimilarityMeasure {
    private static final long serialVersionUID = 1817582690040262790L;

    public double calculateSimilarity(double[] value1, double[] value2) {
        double wxy = 0.0;
        double wx = 0.0;
        double wy = 0.0;
        int i = 0;
        while (i < value1.length) {
            if (!Double.isNaN(value1[i]) && !Double.isNaN(value2[i])) {
                wx += value1[i];
                wy += value2[i];
                wxy += value1[i] * value2[i];
            }
            ++i;
        }
        return wxy / (wx + wy - wxy);
    }

    public double calculateDistance(double[] value1, double[] value2) {
        return -this.calculateSimilarity(value1, value2);
    }

    public void init(ExampleSet exampleSet) throws OperatorException {
        Tools.onlyNumericalAttributes(exampleSet, "value based similarities");
    }
}

