/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import marytts.signalproc.display.CursorDisplayer;
import marytts.signalproc.display.EnergyGraph;
import marytts.signalproc.display.F0Graph;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.SignalGraph;
import marytts.signalproc.display.SilenceMarker;
import marytts.signalproc.display.Spectrogram;
import marytts.util.data.audio.MaryAudioUtils;

public class MultiDisplay
extends JFrame {
    public static final int DEFAULT_WIDTH = 800;
    public static final int DEFAULT_HEIGHT = 600;
    protected SignalGraph signalGraph;
    protected Spectrogram spectrogram;
    protected F0Graph f0Graph;
    protected EnergyGraph energyGraph;
    protected SilenceMarker silenceMarker;
    protected List allGraphs = new ArrayList();

    public MultiDisplay(AudioInputStream ais, String title) {
        this(ais, title, 800, 600);
    }

    public MultiDisplay(AudioInputStream ais, String title, boolean exitOnClose) {
        this(ais, title, 800, 600, exitOnClose);
    }

    public MultiDisplay(AudioInputStream ais, String title, int width, int height, boolean exitOnClose) {
        super(title);
        if (!ais.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            ais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
        }
        if (ais.getFormat().getChannels() > 1) {
            throw new IllegalArgumentException("Can only deal with mono audio signals");
        }
        int samplingRate = (int)ais.getFormat().getSampleRate();
        double[] audioData = MaryAudioUtils.getSamplesAsDoubleArray(ais);
        this.initialise(audioData, samplingRate, width, height, exitOnClose);
    }

    public MultiDisplay(AudioInputStream ais, String title, int width, int height) {
        this(ais, title, width, height, true);
    }

    public MultiDisplay(double[] signal, int samplingRate, String title, int width, int height) {
        super(title);
        this.initialise(signal, samplingRate, width, height, true);
    }

    public MultiDisplay(double[] signal, int samplingRate, String title, int width, int height, boolean exitOnClose) {
        super(title);
        this.initialise(signal, samplingRate, width, height, exitOnClose);
    }

    protected void initialise(double[] signal, int samplingRate, int width, int height, boolean exitOnClose) {
        this.setSize(width, height);
        JPanel zoomPanel = new JPanel();
        zoomPanel.setLayout(new BoxLayout(zoomPanel, 1));
        this.getContentPane().add((Component)zoomPanel, "West");
        JButton zoomIn = new JButton("Zoom In");
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDisplay.this.changeZoomX(2.0);
                MultiDisplay.this.signalGraph.requestFocus();
            }
        });
        zoomPanel.add(zoomIn);
        JButton zoomOut = new JButton("Zoom Out");
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDisplay.this.changeZoomX(0.5);
                MultiDisplay.this.signalGraph.requestFocus();
            }
        });
        zoomPanel.add(zoomOut);
        int graphWidth = width - zoomPanel.getPreferredSize().width - 30;
        JPanel graphPanel = new JPanel();
        graphPanel.setLayout(new BoxLayout(graphPanel, 1));
        JScrollPane scroll = new JScrollPane(graphPanel);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setVerticalScrollBarPolicy(21);
        this.getContentPane().add((Component)scroll, "Center");
        this.signalGraph = new SignalGraph(signal, samplingRate, graphWidth, height * 15 / 100);
        this.allGraphs.add(this.signalGraph);
        this.spectrogram = new Spectrogram(signal, samplingRate, graphWidth, height * 40 / 100);
        this.allGraphs.add(this.spectrogram);
        this.f0Graph = new F0Graph(signal, samplingRate, graphWidth, height * 20 / 100);
        this.allGraphs.add(this.f0Graph);
        this.energyGraph = new EnergyGraph(signal, samplingRate, graphWidth, height * 15 / 100);
        this.allGraphs.add(this.energyGraph);
        this.silenceMarker = new SilenceMarker(signal, samplingRate, graphWidth, height * 5 / 100);
        this.allGraphs.add(this.silenceMarker);
        CursorDisplayer glass = new CursorDisplayer();
        this.setGlassPane(glass);
        glass.setVisible(true);
        for (FunctionGraph g : this.allGraphs) {
            graphPanel.add(g);
            for (FunctionGraph g2 : this.allGraphs) {
                if (g2 == g) continue;
                g.addCursorListener(g2);
            }
            glass.addCursorSource(g);
            g.addCursorListener(glass);
        }
        if (exitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        this.setVisible(true);
        this.signalGraph.requestFocus();
    }

    protected void changeZoomX(double factor) {
        for (FunctionGraph g : this.allGraphs) {
            g.setZoomX(g.getZoomX() * factor);
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            MultiDisplay multiDisplay = new MultiDisplay(ais, args[i]);
        }
    }
}

