/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import marytts.signalproc.effects.BaseAudioEffect;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.MathUtils;

public class VolumeEffect
extends BaseAudioEffect {
    float amount;
    public static float DEFAULT_AMOUNT = 2.0f;
    public static float MAX_AMOUNT = 10.0f;
    public static float MIN_AMOUNT = 0.0f;

    public VolumeEffect() {
        super(16000);
        this.setExampleParameters("amount=" + String.valueOf(DEFAULT_AMOUNT) + ",");
        this.strHelpText = this.getHelpText();
    }

    @Override
    public void parseParameters(String param) {
        super.parseParameters(param);
        this.amount = this.expectFloatParameter("amount");
        if (this.amount == NULL_FLOAT_PARAM) {
            this.amount = DEFAULT_AMOUNT;
        }
        this.amount = MathUtils.CheckLimits(this.amount, MIN_AMOUNT, MAX_AMOUNT);
    }

    @Override
    public DoubleDataSource process(DoubleDataSource input) {
        double[] x = input.getAllData();
        if (x != null) {
            int i = 0;
            while (i < x.length) {
                int n = i++;
                x[n] = x[n] * (double)this.amount;
            }
            input = new BufferedDoubleDataSource(x);
        }
        return input;
    }

    @Override
    public String getHelpText() {
        String strHelp = "Volume Effect:" + strLineBreak + "Scales the output volume by a fixed amount." + strLineBreak + "Parameter:" + strLineBreak + "   <amount>" + "   Definition : Amount of scaling (the output is simply multiplied by amount)" + strLineBreak + "   Range      : [" + String.valueOf(MIN_AMOUNT) + "," + String.valueOf(MAX_AMOUNT) + "]" + strLineBreak + "Example:" + strLineBreak + this.getExampleParameters();
        return strHelp;
    }

    @Override
    public String getName() {
        return "Volume";
    }
}

