/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.util.Arrays;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class FrequencyDomainProcessor
implements InlineDataProcessor {
    private double[] real;
    private double[] imag;
    private double amount;
    private double oneMinusAmount;

    public FrequencyDomainProcessor(int fftSize, double amount) {
        if (!MathUtils.isPowerOfTwo(fftSize)) {
            throw new IllegalArgumentException("FFT size must be a power of two");
        }
        this.real = new double[fftSize];
        this.imag = new double[fftSize];
        this.amount = amount;
        this.oneMinusAmount = 1.0 - this.amount;
    }

    public FrequencyDomainProcessor(int fftSize) {
        this(fftSize, 1.0);
    }

    public int getFFTSize() {
        return this.real.length;
    }

    @Override
    public void applyInline(double[] data, int pos, int len) {
        int i;
        double[] dataOut = new double[len];
        if (len > this.real.length) {
            throw new IllegalArgumentException("Length must not be larger than FFT size");
        }
        int middle = len / 2 + len % 2;
        System.arraycopy(data, 0, dataOut, 0, len);
        System.arraycopy(dataOut, pos + middle, this.real, 0, len - middle);
        System.arraycopy(dataOut, pos, this.real, this.real.length - middle, middle);
        if (this.real.length > len) {
            Arrays.fill(this.real, len - middle, this.real.length - middle, 0.0);
        }
        Arrays.fill(this.imag, 0, this.imag.length, 0.0);
        FFT.transform(this.real, this.imag, false);
        this.process(this.real, this.imag);
        FFT.transform(this.real, this.imag, true);
        System.arraycopy(this.real, 0, dataOut, pos + middle, len - middle);
        System.arraycopy(this.real, this.real.length - middle, dataOut, pos, middle);
        double origAvgEnergy = SignalProcUtils.getAverageSampleEnergy(data, len);
        for (i = 0; i < len; ++i) {
            data[i] = this.amount * dataOut[i] + this.oneMinusAmount * data[i];
        }
        double newAvgEnergy = SignalProcUtils.getAverageSampleEnergy(data, len);
        double scale = origAvgEnergy / newAvgEnergy;
        i = 0;
        while (i < len) {
            int n = i++;
            data[n] = data[n] * (0.8 * scale);
        }
    }

    protected void process(double[] real, double[] imag) {
    }
}

