/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.sinusoidal.BaseSinusoidalSynthesizer;
import marytts.signalproc.sinusoidal.PitchSynchronousSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.SinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalTrack;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class PeakMatchedSinusoidalSynthesizer
extends BaseSinusoidalSynthesizer {
    public PeakMatchedSinusoidalSynthesizer(int samplingRate) {
        super(samplingRate);
    }

    public double[] synthesize(SinusoidalTracks st) {
        SinusoidalTracks[] sts = new SinusoidalTracks[]{st};
        return this.synthesize(sts, false);
    }

    public double[] synthesize(SinusoidalTracks[] sts) {
        return this.synthesize(sts, false);
    }

    public double[] synthesize(SinusoidalTracks[] sts, boolean isSilentSynthesis) {
        double[] y = null;
        double[] tmpy = null;
        for (int i = 0; i < sts.length; ++i) {
            if (y == null) {
                y = this.synthesize(sts[i], isSilentSynthesis);
                continue;
            }
            tmpy = this.synthesize(sts[i], isSilentSynthesis);
            if (tmpy.length <= y.length) continue;
            double[] tmpy2 = new double[y.length];
            System.arraycopy(y, 0, tmpy2, 0, y.length);
            y = new double[tmpy.length];
            Arrays.fill(y, 0.0);
            System.arraycopy(tmpy2, 0, y, 0, tmpy2.length);
            for (int j = 0; j < tmpy.length; ++j) {
                int n = i;
                y[n] = y[n] + tmpy[i];
            }
        }
        return y;
    }

    public double[] synthesize(SinusoidalTracks st, boolean isSilentSynthesis) {
        float tFinal = st.getOriginalDuration();
        int nFinal = (int)Math.floor((double)(tFinal * (float)st.fs) + 0.5);
        double[] y = new double[nFinal + 1];
        Arrays.fill(y, 0.0);
        double oneOverTwoPi = 0.15915494309189535;
        for (int i = 0; i < st.totalTracks; ++i) {
            for (int j = 0; j < st.tracks[i].totalSins - 1; ++j) {
                if (st.tracks[i].states[j] == SinusoidalTrack.TURNED_OFF) continue;
                int pStart = (int)Math.floor((double)(st.tracks[i].times[j] * (float)st.fs) + 0.5);
                int pEnd = (int)Math.floor((double)(st.tracks[i].times[j + 1] * (float)st.fs) + 0.5);
                int nStart = Math.max(0, pStart);
                int nEnd = Math.max(0, pEnd);
                nStart = Math.min(y.length - 1, nStart);
                nEnd = Math.min(y.length - 1, nEnd);
                int n = nStart;
                while (n < nEnd) {
                    float currentTheta;
                    float currentAmp = st.tracks[i].amps[j] + (st.tracks[i].amps[j + 1] - st.tracks[i].amps[j]) * ((float)n - (float)pStart) / (float)(pEnd - pStart + 1);
                    float T = pEnd - pStart;
                    if (n == nStart && st.tracks[i].states[j] == SinusoidalTrack.TURNED_ON) {
                        currentTheta = st.tracks[i].phases[j + 1] - T * st.tracks[i].freqs[j + 1];
                        currentAmp = 0.0f;
                    } else if (n == nStart && st.tracks[i].states[j] == SinusoidalTrack.TURNED_OFF && j > 0) {
                        currentTheta = st.tracks[i].phases[j - 1] + T * st.tracks[i].freqs[j - 1];
                        currentAmp = 0.0f;
                    } else {
                        int M = (int)Math.floor(oneOverTwoPi * ((double)(st.tracks[i].phases[j] + T * st.tracks[i].freqs[j] - st.tracks[i].phases[j + 1]) + (double)(st.tracks[i].freqs[j + 1] - st.tracks[i].freqs[j]) * 0.5 * (double)T) + 0.5);
                        double term1 = (double)(st.tracks[i].phases[j + 1] - st.tracks[i].phases[j] - T * st.tracks[i].freqs[j]) + (double)M * (Math.PI * 2);
                        double term2 = st.tracks[i].freqs[j + 1] - st.tracks[i].freqs[j];
                        float T2 = T * T;
                        float T3 = T * T2;
                        double alpha = 3.0 * term1 / (double)T2 - term2 / (double)T;
                        double beta = -2.0 * term1 / (double)T3 + term2 / (double)T2;
                        float t = (float)n - (float)nStart;
                        float t2 = t * t;
                        float t3 = t * t2;
                        currentTheta = (float)((double)(st.tracks[i].phases[j] + st.tracks[i].freqs[j] * t) + alpha * (double)t2 + beta * (double)t3);
                    }
                    int n2 = n++;
                    y[n2] = y[n2] + (double)currentAmp * Math.cos(currentTheta);
                }
            }
            if (isSilentSynthesis) continue;
            System.out.println("Synthesized track " + String.valueOf(i + 1) + " of " + String.valueOf(st.totalTracks));
        }
        y = MathUtils.multiply(y, (double)st.absMaxOriginal / MathUtils.getAbsMax(y));
        return y;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        double maxOrig = MathUtils.getAbsMax(x);
        SinusoidalAnalyzer sa = null;
        SinusoidalTracks st = null;
        PitchSynchronousSinusoidalAnalyzer pa = null;
        float deltaInHz = 50.0f;
        float numPeriods = PitchSynchronousSinusoidalAnalyzer.DEFAULT_ANALYSIS_PERIODS;
        boolean isSilentSynthesis = false;
        int windowType = 3;
        boolean bRefinePeakEstimatesParabola = false;
        boolean bRefinePeakEstimatesBias = false;
        boolean bSpectralReassignment = false;
        boolean bAdjustNeighFreqDependent = false;
        int spectralEnvelopeType = 1;
        float[] initialPeakLocationsInHz = null;
        initialPeakLocationsInHz = new float[1];
        for (int i = 0; i < 1; ++i) {
            initialPeakLocationsInHz[i] = (float)(i + 1) * 350.0f;
        }
        boolean isFixedRateAnalysis = false;
        boolean isRealSpeech = true;
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)samplingRate;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(samplingRate, startFreqInHz, endFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
        if (isFixedRateAnalysis) {
            double[] f0s = null;
            float ws_f0 = -1.0f;
            float ss_f0 = -1.0f;
            sa = new SinusoidalAnalyzer(params);
            if (spectralEnvelopeType == 1) {
                String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
                PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
                f0s = f0.contour;
                ws_f0 = (float)f0.header.windowSizeInSeconds;
                ss_f0 = (float)f0.header.skipSizeInSeconds;
            }
            st = sa.analyzeFixedRate(x, 0.02f, 0.01f, deltaInHz, spectralEnvelopeType, f0s, ws_f0, ss_f0);
        } else {
            String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
            PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
            int pitchMarkOffset = 0;
            PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, samplingRate, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, pitchMarkOffset);
            pa = new PitchSynchronousSinusoidalAnalyzer(params);
            st = pa.analyzePitchSynchronous(x, pm, numPeriods, -1.0f, deltaInHz, spectralEnvelopeType, initialPeakLocationsInHz);
            isSilentSynthesis = false;
        }
        PeakMatchedSinusoidalSynthesizer ss = new PeakMatchedSinusoidalSynthesizer(samplingRate);
        x = ss.synthesize(st, isSilentSynthesis);
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(x), inputAudio.getFormat());
        String outFileName = args[0].substring(0, args[0].length() - 4) + "_sinResynthFullbandPitchSynch.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
    }
}

