/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.chunker;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import opennlp.model.AbstractModel;
import opennlp.model.BinaryFileDataReader;
import opennlp.model.GenericModelReader;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkerModel
extends BaseModel {
    private static final String COMPONENT_NAME = "ChunkerME";
    private static final String CHUNKER_MODEL_ENTRY_NAME = "chunker.model";

    public ChunkerModel(String languageCode, AbstractModel chunkerModel, Map<String, String> manifestInfoEntries) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries);
        if (chunkerModel == null) {
            throw new IllegalArgumentException("chunkerModel must not be null!");
        }
        this.artifactMap.put(CHUNKER_MODEL_ENTRY_NAME, chunkerModel);
    }

    public ChunkerModel(String languageCode, AbstractModel chunkerModel) {
        this(languageCode, chunkerModel, null);
    }

    public ChunkerModel(InputStream in) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, in);
    }

    @Override
    protected void validateArtifactMap() throws InvalidFormatException {
        super.validateArtifactMap();
        if (!(this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME) instanceof AbstractModel)) {
            throw new InvalidFormatException("Chunker model is incomplete!");
        }
    }

    public AbstractModel getChunkerModel() {
        return (AbstractModel)this.artifactMap.get(CHUNKER_MODEL_ENTRY_NAME);
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 4) {
            System.err.println("ChunkerModel -lang code packageName modelName");
            System.exit(1);
        }
        String lang = args[1];
        String packageName = args[2];
        String modelName = args[3];
        AbstractModel chunkerModel = new GenericModelReader(new BinaryFileDataReader(new FileInputStream(modelName))).getModel();
        ChunkerModel packageModel = new ChunkerModel(lang, chunkerModel);
        packageModel.serialize(new FileOutputStream(packageName));
    }
}

