/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import opennlp.tools.cmdline.sentdetect.SentenceModelLoader;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;

public final class SentenceDetectorEvaluatorTool
implements CmdLineTool {
    public String getName() {
        return "SentenceDetectorEvaluator";
    }

    public String getShortDescription() {
        return "evaluator for the learnable sentence detector";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " -encoding charset -model model -data testData";
    }

    public void run(String[] args) {
        if (args.length != 4) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        Charset encoding = CmdLineUtil.getEncodingParameter(args);
        if (encoding == null) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        SentenceModel model = (SentenceModel)new SentenceModelLoader().load(new File(CmdLineUtil.getParameter("-model", args)));
        File trainingDataInFile = new File(CmdLineUtil.getParameter("-data", args));
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        SentenceDetectorEvaluator evaluator = new SentenceDetectorEvaluator(new SentenceDetectorME(model));
        System.out.print("Evaluating ... ");
        ObjectStream<SentenceSample> sampleStream = SentenceDetectorTrainerTool.openSampleData("Test", trainingDataInFile, encoding);
        try {
            evaluator.evaluate(sampleStream);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        System.err.println("done");
        System.out.println();
        System.out.println(evaluator.getFMeasure());
    }
}

