/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.cmdline.AbstractConverterTool;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.formats.ConllXTokenSampleStreamFactory;
import opennlp.tools.formats.NameToTokenSampleStreamFactory;
import opennlp.tools.formats.POSToTokenSampleStreamFactory;
import opennlp.tools.tokenize.TokenSample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenizerConverterTool
extends AbstractConverterTool<TokenSample> {
    private static final Map<String, ObjectStreamFactory<TokenSample>> streamFactories;

    @Override
    public String getName() {
        return "TokenizerConverter";
    }

    @Override
    public String getShortDescription() {
        return "";
    }

    @Override
    protected ObjectStreamFactory<TokenSample> createStreamFactory(String format) {
        return streamFactories.get(format);
    }

    static {
        HashMap<String, ObjectStreamFactory<TokenSample>> mutableStreamFactories = new HashMap<String, ObjectStreamFactory<TokenSample>>();
        mutableStreamFactories.put("conllx", new ConllXTokenSampleStreamFactory());
        mutableStreamFactories.put("pos", new POSToTokenSampleStreamFactory());
        mutableStreamFactories.put("namefinder", new NameToTokenSampleStreamFactory());
        streamFactories = Collections.unmodifiableMap(mutableStreamFactories);
    }
}

