/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.test;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.KMeansCalculator;
import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.OpdfInteger;
import be.ac.ulg.montefiore.run.jahmm.OpdfIntegerFactory;
import be.ac.ulg.montefiore.run.jahmm.ViterbiCalculator;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class BasicIntegerTest
extends TestCase {
    private static final double DELTA = 1.0E-10;
    private Hmm<ObservationInteger> hmm;
    private List<ObservationInteger> sequence;
    private List<ObservationInteger> randomSequence;

    protected void setUp() {
        this.hmm = new Hmm(5, new OpdfIntegerFactory(10));
        this.hmm.setOpdf(1, new OpdfInteger(6));
        this.sequence = new ArrayList<ObservationInteger>();
        int i = 0;
        while (i < 5) {
            this.sequence.add(new ObservationInteger(i));
            ++i;
        }
        this.randomSequence = new ArrayList<ObservationInteger>();
        i = 0;
        while (i < 30000) {
            this.randomSequence.add(new ObservationInteger((int)(Math.random() * 10.0)));
            ++i;
        }
    }

    public void testForwardBackward() {
        ForwardBackwardCalculator fbc = new ForwardBackwardCalculator(this.sequence, this.hmm);
        BasicIntegerTest.assertEquals((double)1.8697705349794245E-5, (double)fbc.probability(), (double)1.0E-10);
        ForwardBackwardScaledCalculator fbsc = new ForwardBackwardScaledCalculator(this.sequence, this.hmm);
        BasicIntegerTest.assertEquals((double)1.8697705349794245E-5, (double)fbsc.probability(), (double)1.0E-10);
    }

    public void testViterbi() {
        ViterbiCalculator vc = new ViterbiCalculator(this.sequence, this.hmm);
        BasicIntegerTest.assertEquals((double)4.1152263374485705E-8, (double)Math.exp(vc.lnProbability()), (double)1.0E-10);
    }

    public void testKMeansCalculator() {
        int nbClusters = 20;
        KMeansCalculator<ObservationInteger> kmc = new KMeansCalculator<ObservationInteger>(nbClusters, this.randomSequence);
        BasicIntegerTest.assertEquals((String)"KMeans did not produce expected number of clusters", (int)nbClusters, (int)kmc.nbClusters());
    }
}

