/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.example.set;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeRole;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.SimpleAttributes;
import com.rapidminer.example.set.AbstractExampleSet;
import com.rapidminer.example.set.SimpleExampleReader;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.ExampleTable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExampleSet
extends AbstractExampleSet {
    private static final long serialVersionUID = 9163340881176421801L;
    private ExampleTable exampleTable;
    private Attributes attributes = new SimpleAttributes();

    public SimpleExampleSet(ExampleTable exampleTable) {
        this(exampleTable, null, null);
    }

    public SimpleExampleSet(ExampleTable exampleTable, List<Attribute> regularAttributes) {
        this(exampleTable, regularAttributes, null);
    }

    public SimpleExampleSet(ExampleTable exampleTable, Map<Attribute, String> specialAttributes) {
        this(exampleTable, null, specialAttributes);
    }

    public SimpleExampleSet(ExampleTable exampleTable, List<Attribute> regularAttributes, Map<Attribute, String> specialAttributes) {
        this.exampleTable = exampleTable;
        List<Attribute> regularList = regularAttributes;
        if (regularList == null) {
            regularList = new LinkedList<Attribute>();
            int a = 0;
            while (a < exampleTable.getNumberOfAttributes()) {
                Attribute attribute = exampleTable.getAttribute(a);
                if (attribute != null) {
                    regularList.add(attribute);
                }
                ++a;
            }
        }
        for (Attribute attribute : regularList) {
            if (specialAttributes != null && specialAttributes.get(attribute) != null) continue;
            this.getAttributes().add(new AttributeRole(attribute));
        }
        if (specialAttributes != null) {
            for (Map.Entry<Attribute, String> entry : specialAttributes.entrySet()) {
                this.getAttributes().setSpecialAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    public SimpleExampleSet(SimpleExampleSet exampleSet) {
        this.exampleTable = exampleSet.exampleTable;
        this.attributes = (Attributes)exampleSet.getAttributes().clone();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public ExampleTable getExampleTable() {
        return this.exampleTable;
    }

    @Override
    public int size() {
        return this.exampleTable.size();
    }

    @Override
    public Example getExample(int index) {
        DataRow dataRow = this.getExampleTable().getDataRow(index);
        if (dataRow == null) {
            return null;
        }
        return new Example(dataRow, this);
    }

    @Override
    public Iterator<Example> iterator() {
        return new SimpleExampleReader(this.getExampleTable().getDataRowReader(), this);
    }
}

