/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.dialog;

import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.dialog.OperatorInfoPanel;
import com.rapidminer.gui.operatortree.OperatorTree;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.OperatorList;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.learner.Learner;
import com.rapidminer.operator.learner.LearnerCapability;
import com.rapidminer.tools.GroupTree;
import com.rapidminer.tools.OperatorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewOperatorDialog
extends JDialog {
    private static final long serialVersionUID = 390653805759799295L;
    private OperatorTree operatorTree;
    private transient OperatorDescription description = null;
    private JPanel mainPanel = new JPanel();
    private OperatorInfoPanel operatorInfo = null;
    private JList operatorList = new OperatorList();
    private String searchText = "";
    private Class inputClass = null;
    private Class outputClass = null;
    private String group = null;
    private transient LearnerCapability firstCapability = null;
    private transient LearnerCapability secondCapability = null;

    public NewOperatorDialog(OperatorTree tree) {
        super(RapidMinerGUI.getMainFrame(), "New Operator", false);
        this.operatorTree = tree;
        this.mainPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainPanel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("Add");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewOperatorDialog.this.add();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewOperatorDialog.this.cancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.mainPanel.add((Component)buttonPanel, "South");
        JPanel searchPanel = new JPanel(new GridLayout(6, 2));
        searchPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10), BorderFactory.createTitledBorder("Search Constraints")));
        this.mainPanel.add((Component)searchPanel, "North");
        final String[] ioObjects = this.convertSet2Strings(OperatorService.getIOObjectsNames());
        String[] inputObjects = new String[ioObjects.length + 1];
        inputObjects[0] = "Any";
        System.arraycopy(ioObjects, 0, inputObjects, 1, ioObjects.length);
        final JTextField searchField = new JTextField(this.searchText);
        searchField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    NewOperatorDialog.this.searchText = searchField.getText().trim();
                    NewOperatorDialog.this.updateOperatorList();
                }
            }
        });
        searchPanel.add(new JLabel("Search Text: "));
        searchPanel.add(searchField);
        LinkedList<String> allGroups = new LinkedList<String>();
        allGroups.add("Any");
        GroupTree groupTree = OperatorService.getGroups();
        this.addGroups(groupTree, null, allGroups);
        Collections.sort(allGroups);
        final String[] groupArray = new String[allGroups.size()];
        allGroups.toArray(groupArray);
        final JComboBox<String> groupComboBox = new JComboBox<String>(groupArray);
        groupComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = groupComboBox.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.group = null;
                } else {
                    NewOperatorDialog.this.group = groupArray[selectedIndex];
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("Operator group: "));
        searchPanel.add(groupComboBox);
        final JComboBox<String> inputType = new JComboBox<String>(inputObjects);
        inputType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = inputType.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.inputClass = null;
                } else {
                    NewOperatorDialog.this.inputClass = OperatorService.getIOObjectClass(ioObjects[selectedIndex - 1]);
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("Required Input: "));
        searchPanel.add(inputType);
        final JComboBox<String> outputType = new JComboBox<String>(inputObjects);
        outputType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = outputType.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.outputClass = null;
                } else {
                    NewOperatorDialog.this.outputClass = OperatorService.getIOObjectClass(ioObjects[selectedIndex - 1]);
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("Delivered Output: "));
        searchPanel.add(outputType);
        List<LearnerCapability> caps = LearnerCapability.getAllCapabilities();
        String[] capabilities = new String[caps.size() + 1];
        capabilities[0] = "Any";
        int k = 1;
        Iterator<LearnerCapability> i = caps.iterator();
        while (i.hasNext()) {
            capabilities[k++] = i.next().getDescription();
        }
        final JComboBox<String> firstCapabilityType = new JComboBox<String>(capabilities);
        firstCapabilityType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = firstCapabilityType.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.firstCapability = null;
                } else {
                    NewOperatorDialog.this.firstCapability = LearnerCapability.getCapability(selectedIndex - 1);
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("First Capability: "));
        searchPanel.add(firstCapabilityType);
        final JComboBox<String> secondCapabilityType = new JComboBox<String>(capabilities);
        secondCapabilityType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedIndex = secondCapabilityType.getSelectedIndex();
                if (selectedIndex <= 0) {
                    NewOperatorDialog.this.secondCapability = null;
                } else {
                    NewOperatorDialog.this.secondCapability = LearnerCapability.getCapability(selectedIndex - 1);
                }
                NewOperatorDialog.this.updateOperatorList();
            }
        });
        searchPanel.add(new JLabel("Second Capability: "));
        searchPanel.add(secondCapabilityType);
        this.operatorList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OperatorDescription selection = (OperatorDescription)NewOperatorDialog.this.operatorList.getSelectedValue();
                    NewOperatorDialog.this.setSelectedOperator(selection);
                }
            }
        });
        this.operatorList.setSelectionMode(0);
        ExtendedJScrollPane listScrollPane = new ExtendedJScrollPane(this.operatorList);
        GridBagLayout layout = new GridBagLayout();
        JPanel listPanel = new JPanel(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        listPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5), BorderFactory.createTitledBorder("Matching Operators")));
        layout.setConstraints(listScrollPane, c);
        listPanel.add(listScrollPane);
        this.mainPanel.add((Component)listPanel, "West");
        this.updateOperatorList();
        this.setSize(780, 580);
        this.setLocationRelativeTo(RapidMinerGUI.getMainFrame());
    }

    private void updateOperatorList() {
        this.operatorList.removeAll();
        Vector<OperatorDescription> operators = new Vector<OperatorDescription>();
        for (String name : OperatorService.getOperatorNames()) {
            OperatorDescription description = OperatorService.getOperatorDescription(name);
            if (this.searchText != null && this.searchText.length() > 0 && description.getName().toLowerCase().indexOf(this.searchText.toLowerCase()) < 0 && description.getLongDescriptionHTML().toLowerCase().indexOf(this.searchText.toLowerCase()) < 0 || this.group != null && this.group.length() > 0 && description.getGroup().indexOf(this.group) < 0) continue;
            try {
                Operator operator = description.createOperatorInstance();
                if (this.inputClass != null && !this.containsClass(operator.getInputClasses(), this.inputClass) || this.outputClass != null && !this.containsClass(operator.getOutputClasses(), this.outputClass) || this.firstCapability != null && (!(operator instanceof Learner) || !((Learner)((Object)operator)).supportsCapability(this.firstCapability)) || this.secondCapability != null && (!(operator instanceof Learner) || !((Learner)((Object)operator)).supportsCapability(this.secondCapability))) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            operators.add(description);
        }
        Collections.sort(operators);
        this.operatorList.setListData(operators);
        if (operators.size() > 0) {
            this.operatorList.setSelectedIndex(0);
        }
    }

    private boolean containsClass(Class<?>[] classes, Class<?> clazz) {
        if (classes != null) {
            int i = 0;
            while (i < classes.length) {
                if (clazz.isAssignableFrom(classes[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void addGroups(GroupTree tree, String parentName, Collection<String> names) {
        for (GroupTree subGroup : tree.getSubGroups()) {
            String name = parentName == null ? subGroup.getName() : String.valueOf(parentName) + "." + subGroup.getName();
            names.add(name);
            this.addGroups(subGroup, name, names);
        }
    }

    private void setSelectedOperator(OperatorDescription descriptionName) {
        if (this.operatorInfo != null) {
            this.mainPanel.remove(this.operatorInfo);
        }
        if (descriptionName != null) {
            this.description = descriptionName;
            this.operatorInfo = new OperatorInfoPanel(this.description);
        } else {
            this.operatorInfo = new OperatorInfoPanel(null);
        }
        if (this.description.getDeprecationInfo() != null) {
            this.operatorInfo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10), BorderFactory.createTitledBorder("Operator Info (Deprecated!)")));
        } else {
            this.operatorInfo.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10), BorderFactory.createTitledBorder("Operator Info")));
        }
        this.mainPanel.add((Component)this.operatorInfo, "Center");
        this.operatorInfo.revalidate();
    }

    private String[] convertSet2Strings(Collection ioObjects) {
        String[] objectArray = new String[ioObjects.size()];
        Iterator i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            objectArray[index++] = (String)i.next();
        }
        return objectArray;
    }

    private Operator getOperator() throws OperatorCreationException {
        if (this.description != null) {
            Operator operator = OperatorService.createOperator(this.description);
            return operator;
        }
        return null;
    }

    private void add() {
        try {
            Operator operator = this.getOperator();
            if (operator != null) {
                this.operatorTree.insert(operator);
            }
        }
        catch (Exception ex) {
            SwingTools.showSimpleErrorMessage("Cannot create operator:", ex);
        }
    }

    private void cancel() {
        this.dispose();
    }
}

