/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.gui.plotter.charts;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableExampleSetAdapter;
import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.gui.plotter.PlotterAdapter;
import com.rapidminer.gui.plotter.charts.RapidBarPainter;
import com.rapidminer.operator.MissingIOObjectException;
import com.rapidminer.operator.OperatorCreationException;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.learner.bayes.DistributionModel;
import com.rapidminer.operator.learner.bayes.NaiveBayes;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.math.distribution.ContinuousDistribution;
import com.rapidminer.tools.math.distribution.DiscreteDistribution;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionPlotter
extends PlotterAdapter {
    private static final long serialVersionUID = 2923008541302883925L;
    private static final int NUMBER_OF_STEPS = 300;
    private boolean plot = true;
    private int plotColumn = -1;
    private int groupColumn = -1;
    private transient DistributionModel model;
    private transient DataTable dataTable;
    private boolean createFromDataTable = false;
    private JCheckBox rotateLabels = new JCheckBox("Rotate Labels", false);

    public DistributionPlotter() {
        this.rotateLabels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DistributionPlotter.this.repaint();
            }
        });
    }

    public DistributionPlotter(DistributionModel model) {
        this();
        this.model = model;
        this.createFromDataTable = false;
        this.plotColumn = 0;
    }

    public DistributionPlotter(DataTable dataTable) {
        this();
        this.setDataTable(dataTable);
    }

    @Override
    public void setDataTable(DataTable dataTable) {
        super.setDataTable(dataTable);
        this.dataTable = dataTable;
        this.createFromDataTable = true;
    }

    public void setRotateLabels(boolean rotateLabels) {
        this.rotateLabels.setSelected(rotateLabels);
        this.repaint();
    }

    public void preparePlots() {
        if (this.createFromDataTable) {
            ExampleSet wrappedExampleSet;
            Attribute[] attributes;
            Attribute label;
            this.plot = false;
            if (this.groupColumn >= 0 && this.plotColumn >= 0 && this.groupColumn != this.plotColumn && (label = (attributes = Tools.createRegularAttributeArray(wrappedExampleSet = DataTableExampleSetAdapter.createExampleSetFromDataTable(this.dataTable)))[this.groupColumn]).isNominal()) {
                wrappedExampleSet.getAttributes().setLabel(label);
                try {
                    NaiveBayes modelLearner = OperatorService.createOperator(NaiveBayes.class);
                    this.model = (DistributionModel)modelLearner.learn(wrappedExampleSet);
                }
                catch (OperatorCreationException e) {
                    LogService.getGlobal().logWarning("Cannot create distribution model generator. Skip plot...");
                }
                catch (MissingIOObjectException e) {
                    LogService.getGlobal().logWarning("No distribution model was created from data. Skip plot...");
                }
                catch (OperatorException e) {
                    LogService.getGlobal().logWarning("Error during creation of distribution model. Skip plot...");
                }
                this.plot = true;
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintComponent(graphics, this.getWidth(), this.getHeight());
    }

    public void paintComponent(Graphics graphics, int width, int height) {
        this.preparePlots();
        if (this.plot) {
            JFreeChart chart = null;
            try {
                chart = this.model.isDiscrete(this.plotColumn) ? this.createNominalChart() : this.createNumericalChart();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (chart != null) {
                chart.setBackgroundPaint((Paint)Color.white);
                LegendTitle legend = chart.getLegend();
                if (legend != null) {
                    legend.setPosition(RectangleEdge.TOP);
                    legend.setFrame((BlockFrame)BlockBorder.NONE);
                    legend.setHorizontalAlignment(HorizontalAlignment.LEFT);
                    legend.setItemFont(LABEL_FONT);
                }
                Rectangle2D.Double drawRect = new Rectangle2D.Double(0.0, 0.0, width, height);
                chart.draw((Graphics2D)graphics, (Rectangle2D)drawRect);
            }
        }
    }

    private XYDataset createNumericalDataSet() {
        XYSeriesCollection dataSet = new XYSeriesCollection();
        double start = this.model.getLowerBound(this.plotColumn);
        double end = this.model.getUpperBound(this.plotColumn);
        double stepSize = (end - start) / 299.0;
        for (int classIndex : this.model.getClassIndices()) {
            XYSeries series = new XYSeries((Comparable)((Object)this.model.getClassName(classIndex)));
            ContinuousDistribution distribution = (ContinuousDistribution)this.model.getDistribution(classIndex, this.plotColumn);
            double currentValue = start;
            while (currentValue < end) {
                double probability = distribution.getProbability(currentValue);
                if (!Double.isNaN(probability)) {
                    series.add(currentValue, distribution.getProbability(currentValue));
                }
                currentValue += stepSize;
            }
            dataSet.addSeries(series);
        }
        return dataSet;
    }

    private JFreeChart createNumericalChart() {
        XYDataset dataset = this.createNumericalDataSet();
        String domainName = this.dataTable == null ? "Value" : this.dataTable.getColumnName(this.plotColumn);
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)domainName, (String)"Density", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        DeviationRenderer renderer = new DeviationRenderer(true, false);
        BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
        if (dataset.getSeriesCount() == 1) {
            renderer.setSeriesStroke(0, (Stroke)stroke);
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            int i = 0;
            while (i < dataset.getSeriesCount()) {
                renderer.setSeriesStroke(i, (Stroke)stroke);
                Color color = this.getColorProvider().getPointColor((double)i / (double)(dataset.getSeriesCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
                ++i;
            }
        }
        renderer.setAlpha(0.12f);
        plot.setRenderer((XYItemRenderer)renderer);
        ValueAxis valueAxis = plot.getRangeAxis();
        valueAxis.setLabelFont(LABEL_FONT_BOLD);
        valueAxis.setTickLabelFont(LABEL_FONT);
        if (this.dataTable != null) {
            if (this.dataTable.isDate(this.plotColumn) || this.dataTable.isDateTime(this.plotColumn)) {
                DateAxis domainAxis = new DateAxis(this.dataTable.getColumnName(this.plotColumn));
                domainAxis.setTimeZone(com.rapidminer.tools.Tools.getPreferredTimeZone());
                plot.setDomainAxis((ValueAxis)domainAxis);
            } else {
                plot.setDomainAxis((ValueAxis)new NumberAxis(this.dataTable.getColumnName(this.plotColumn)));
            }
        }
        plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
        return chart;
    }

    private JFreeChart createNominalChart() {
        CategoryDataset dataset = this.createNominalDataSet();
        String domainName = this.dataTable == null ? "Value" : this.dataTable.getColumnName(this.plotColumn);
        JFreeChart chart = ChartFactory.createBarChart(null, (String)domainName, (String)"Density", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.getPlot().setBackgroundPaint((Paint)Color.WHITE);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        BarRenderer renderer = new BarRenderer();
        if (dataset.getRowCount() == 1) {
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            renderer.setSeriesFillPaint(0, (Paint)Color.RED);
        } else {
            int i = 0;
            while (i < dataset.getRowCount()) {
                Color color = this.getColorProvider().getPointColor((double)i / (double)(dataset.getRowCount() - 1));
                renderer.setSeriesPaint(i, (Paint)color);
                renderer.setSeriesFillPaint(i, (Paint)color);
                ++i;
            }
        }
        renderer.setBarPainter((BarPainter)new RapidBarPainter());
        renderer.setDrawBarOutline(true);
        plot.setRenderer((CategoryItemRenderer)renderer);
        plot.getRangeAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getRangeAxis().setTickLabelFont(LABEL_FONT);
        plot.getDomainAxis().setLabelFont(LABEL_FONT_BOLD);
        plot.getDomainAxis().setTickLabelFont(LABEL_FONT);
        if (this.rotateLabels.isSelected()) {
            plot.getDomainAxis().setTickLabelsVisible(true);
            plot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
        }
        return chart;
    }

    private CategoryDataset createNominalDataSet() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Integer classIndex : this.model.getClassIndices()) {
            DiscreteDistribution distribution = (DiscreteDistribution)this.model.getDistribution(classIndex, this.plotColumn);
            String labelName = this.model.getClassName(classIndex);
            TreeMap<String, Double> valueMap = new TreeMap<String, Double>();
            for (Double value : distribution.getValues()) {
                String valueName = Double.isNaN(value) ? "Unknown" : distribution.mapValue(value);
                valueMap.put(valueName, value);
            }
            for (String nominalValue : valueMap.keySet()) {
                dataset.addValue(distribution.getProbability((Double)valueMap.get(nominalValue)), (Comparable)((Object)labelName), (Comparable)((Object)nominalValue));
            }
        }
        return dataset;
    }

    @Override
    public void setPlotColumn(int column, boolean plot) {
        this.plotColumn = column;
        this.plot = plot;
        this.repaint();
    }

    @Override
    public boolean getPlotColumn(int column) {
        return column == this.plotColumn && this.plot;
    }

    @Override
    public String getPlotName() {
        return "Plot Column";
    }

    @Override
    public int getNumberOfAxes() {
        return 1;
    }

    @Override
    public void setAxis(int index, int dimension) {
        if (this.groupColumn != dimension) {
            this.groupColumn = dimension;
            this.repaint();
        }
    }

    @Override
    public int getAxis(int index) {
        return this.groupColumn;
    }

    @Override
    public String getAxisName(int axis) {
        return "Class Column";
    }

    @Override
    public JComponent getOptionsComponent(int index) {
        if (index == 0) {
            return this.rotateLabels;
        }
        return null;
    }

    @Override
    public List<ParameterType> getAdditionalParameterKeys() {
        List<ParameterType> types = super.getAdditionalParameterKeys();
        types.add(new ParameterTypeBoolean("rotate_labels", "Indicates if the domain axis labels should be rotated.", false));
        return types;
    }

    @Override
    public void setAdditionalParameter(String key, String value) {
        if ("rotate_labels".equals(key)) {
            this.setRotateLabels(com.rapidminer.tools.Tools.booleanValue(value, false));
        }
    }
}

