/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.operator.RapidMinerOutputFilter;
import com.rapidminer.tools.LoggingHandler;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.main.WVTWordVector;
import edu.udo.cs.wvtool.util.WVToolException;
import edu.udo.cs.wvtool.wordlist.WVTWordList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleSetOutputFilter
implements RapidMinerOutputFilter {
    private Attribute sourceAtt = null;
    private Attribute typeAtt = null;
    private Attribute encodingAtt = null;
    private Attribute languageAtt = null;
    private Attribute[] wordAttributes;
    private ExampleSet exampleSet;
    private Iterator<Example> exampleIterator;
    private List<Attribute> toRemoveAttributes;

    public ExampleSetOutputFilter(ExampleSet exampleSet, WVTWordList wordList, boolean useSpecialAttributes, List<Attribute> toRemoveAttributes, LoggingHandler logger) {
        this.exampleSet = exampleSet;
        this.toRemoveAttributes = toRemoveAttributes;
        this.wordAttributes = new Attribute[wordList.getNumWords()];
        int i = 0;
        while (i < this.wordAttributes.length) {
            Attribute attribute;
            String attributeName = wordList.getWord(i);
            if (exampleSet.getAttributes().get(attributeName) != null) {
                logger.logWarning("The original example example set already contains an attribute named \"" + wordList.getWord(i) + "\". Renaming the new word attribute into " + wordList.getWord(i) + "_");
                while (exampleSet.getAttributes().get(attributeName) != null) {
                    attributeName = String.valueOf(attributeName) + "_";
                }
            }
            this.wordAttributes[i] = attribute = AttributeFactory.createAttribute(attributeName, 4);
            this.exampleSet.getExampleTable().addAttribute(attribute);
            this.exampleSet.getAttributes().addRegular(attribute);
            ++i;
        }
        if (useSpecialAttributes) {
            this.sourceAtt = AttributeFactory.createAttribute("text_source", 1);
            this.typeAtt = AttributeFactory.createAttribute("content_type", 1);
            this.encodingAtt = AttributeFactory.createAttribute("content_encoding", 1);
            this.languageAtt = AttributeFactory.createAttribute("content_language", 1);
            this.exampleSet.getExampleTable().addAttribute(this.sourceAtt);
            this.exampleSet.getExampleTable().addAttribute(this.typeAtt);
            this.exampleSet.getExampleTable().addAttribute(this.encodingAtt);
            this.exampleSet.getExampleTable().addAttribute(this.languageAtt);
            this.exampleSet.getAttributes().addRegular(this.sourceAtt);
            this.exampleSet.getAttributes().addRegular(this.typeAtt);
            this.exampleSet.getAttributes().addRegular(this.encodingAtt);
            this.exampleSet.getAttributes().addRegular(this.languageAtt);
        }
        this.exampleIterator = exampleSet.iterator();
    }

    public void write(WVTWordVector wordVector) throws WVToolException {
        if (this.exampleIterator.hasNext()) {
            WVTDocumentInfo docInfo = wordVector.getDocumentInfo();
            Example e = this.exampleIterator.next();
            double[] values = wordVector.getValues();
            int i = 0;
            while (i < values.length) {
                if (Double.isInfinite(values[i]) || Double.isNaN(values[i])) {
                    e.setValue(this.wordAttributes[i], 0.0);
                } else {
                    e.setValue(this.wordAttributes[i], values[i]);
                }
                ++i;
            }
            if (this.sourceAtt != null) {
                e.setValue(this.sourceAtt, this.sourceAtt.getMapping().mapString(docInfo.getSourceName()));
                e.setValue(this.typeAtt, this.typeAtt.getMapping().mapString(docInfo.getContentType()));
                e.setValue(this.encodingAtt, this.encodingAtt.getMapping().mapString(docInfo.getContentEncoding()));
                e.setValue(this.languageAtt, this.languageAtt.getMapping().mapString(docInfo.getContentLanguage()));
            }
        } else {
            this.exampleIterator = null;
            this.wordAttributes = null;
        }
    }

    @Override
    public ExampleSet createExampleSet() {
        if (this.toRemoveAttributes != null) {
            for (Attribute attribute : this.toRemoveAttributes) {
                this.exampleSet.getAttributes().remove(attribute);
            }
        }
        return this.exampleSet;
    }

    @Override
    public void cleanUp() {
        this.exampleSet = null;
        this.exampleIterator = null;
        this.wordAttributes = null;
        this.sourceAtt = null;
        this.typeAtt = null;
        this.encodingAtt = null;
        this.languageAtt = null;
    }
}

