/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.aggregation;

import com.rapidminer.operator.features.aggregation.AggregationIndividual;
import com.rapidminer.operator.features.aggregation.AggregationSelection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationTournamentSelection
implements AggregationSelection {
    private int popSize = 10;
    private double tournamentFraction = 0.25;
    private Random random;

    public AggregationTournamentSelection(int popSize, double tournamentFraction, Random random) {
        this.popSize = popSize;
        this.tournamentFraction = tournamentFraction;
        this.random = random;
    }

    @Override
    public void performSelection(List<AggregationIndividual> population) {
        LinkedList<AggregationIndividual> newGeneration = new LinkedList<AggregationIndividual>();
        int tournamentSize = Math.max((int)Math.round((double)population.size() * this.tournamentFraction), 1);
        while (newGeneration.size() < this.popSize) {
            AggregationIndividual winner = null;
            int k = 0;
            while (k < tournamentSize) {
                AggregationIndividual current = population.get(this.random.nextInt(population.size()));
                if (winner == null || current.getPerformance().getMainCriterion().getFitness() > winner.getPerformance().getMainCriterion().getFitness()) {
                    winner = current;
                }
                ++k;
            }
            newGeneration.add(winner);
        }
        population.clear();
        population.addAll(newGeneration);
    }
}

