/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.features.construction;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.AttributeParser;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.Tools;
import com.rapidminer.example.set.AttributeWeightedExampleSet;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.DataRowFactory;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.generator.GenerationException;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividual;
import com.rapidminer.operator.features.construction.ExampleSetBasedIndividualOperator;
import com.rapidminer.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquivalentAttributeRemoval
extends ExampleSetBasedIndividualOperator {
    private int numberOfSamples = 5;
    private double epsilon = 0.05;
    private boolean recalculateAttributeStatistics = false;
    private RandomGenerator random;

    public EquivalentAttributeRemoval(int numberOfSamples, double epsilon, boolean recalculateAttributeStatistics, RandomGenerator random) {
        this.numberOfSamples = numberOfSamples;
        this.epsilon = epsilon;
        this.recalculateAttributeStatistics = recalculateAttributeStatistics;
        this.random = random;
    }

    @Override
    public List<ExampleSetBasedIndividual> operate(ExampleSetBasedIndividual individual) {
        AttributeWeightedExampleSet exampleSet = individual.getExampleSet();
        if (this.recalculateAttributeStatistics) {
            exampleSet.recalculateAllAttributeStatistics();
        }
        Attribute[] allAttributes = exampleSet.getExampleTable().getAttributes();
        ArrayList<Attribute> simpleAttributesList = new ArrayList<Attribute>();
        int i = 0;
        while (i < allAttributes.length) {
            if (allAttributes[i] != null && !allAttributes[i].getConstruction().equals(allAttributes[i].getName())) {
                simpleAttributesList.add(allAttributes[i]);
            }
            ++i;
        }
        HashMap<String, Attribute> removeMap = new HashMap<String, Attribute>();
        Attribute[] attributeArray = exampleSet.getAttributes().createRegularAttributeArray();
        int i2 = 0;
        while (i2 < attributeArray.length) {
            int j = i2 + 1;
            while (j < attributeArray.length) {
                Attribute att1 = attributeArray[i2];
                Attribute att2 = attributeArray[j];
                if (att1.getConstruction().equals(att2.getConstruction())) {
                    removeMap.put(att2.getName(), att2);
                } else {
                    MemoryExampleTable exampleTable = new MemoryExampleTable(simpleAttributesList, new DataRowFactory(0, '.'), this.numberOfSamples);
                    try {
                        AttributeParser parser = new AttributeParser();
                        Tools.fillTableWithRandomValues(exampleTable, exampleSet, this.random);
                        SimpleExampleSet randomSet = new SimpleExampleSet((ExampleTable)exampleTable, new LinkedList<Attribute>());
                        parser.generateAttribute(randomSet.getLog(), att1.getConstruction(), exampleTable);
                        parser.generateAttribute(randomSet.getLog(), att2.getConstruction(), exampleTable);
                        if (this.equivalent(randomSet)) {
                            int depth2;
                            int depth1 = att1.getConstruction().length();
                            if (depth1 > (depth2 = att2.getConstruction().length())) {
                                removeMap.put(att1.getName(), att1);
                            } else {
                                removeMap.put(att2.getName(), att2);
                            }
                        }
                    }
                    catch (GenerationException e) {
                        exampleSet.getLog().logWarning("Cannot generate test attribute: " + e.getMessage() + ". We just keep both attributes for sure...");
                    }
                }
                ++j;
            }
            ++i2;
        }
        for (Attribute attribute : removeMap.values()) {
            exampleSet.getLog().log("Remove equivalent attribute '" + attribute.getName() + "'.");
            exampleSet.getAttributes().remove(attribute);
        }
        LinkedList<ExampleSetBasedIndividual> l = new LinkedList<ExampleSetBasedIndividual>();
        l.add(new ExampleSetBasedIndividual(exampleSet));
        return l;
    }

    /*
     * Unable to fully structure code
     */
    private boolean equivalent(ExampleSet exampleSet) {
        if (exampleSet.getAttributes().size() < 2) {
            return true;
        }
        reader = exampleSet.iterator();
        a = exampleSet.getAttributes().iterator();
        a1 = a.next();
        if (!a1.equals(a2 = a.next())) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            example = (Example)reader.next();
            if (!(Math.abs(example.getValue(a1) - example.getValue(a2)) > this.epsilon)) continue;
            return false;
lbl11:
            // 2 sources

            ** while (reader.hasNext())
        }
lbl12:
        // 1 sources

        return true;
    }
}

