/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.transformation;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Attributes;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.InputDescription;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeList;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.ParameterTypeStringCategory;
import com.rapidminer.tools.container.MultidimensionalArraySet;
import com.rapidminer.tools.container.ValueSet;
import com.rapidminer.tools.math.function.aggregation.AbstractAggregationFunction;
import com.rapidminer.tools.math.function.aggregation.AggregationFunction;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationOperator
extends AbstractDataProcessing {
    public static final String PARAMETER_AGGREGATION_ATTRIBUTES = "aggregation_attributes";
    public static final String PARAMETER_AGGREGATION_FUNCTIONS = "aggregation_functions";
    public static final String PARAMETER_GROUP_BY_ATTRIBUTES = "group_by_attributes";
    public static final String PARAMETER_ONLY_DISTINCT = "only_distinct";
    public static final String PARAMETER_IGNORE_MISSINGS = "ignore_missings";
    private static final String GENERIC_GROUP_NAME = "group";
    private static final String GENERIC_ALL_NAME = "all";

    public AggregationOperator(OperatorDescription desc) {
        super(desc);
    }

    private Attribute[] getAttributesArrayFromRegex(Attributes attributes, String regex) throws OperatorException {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new UserError((Operator)this, 206, regex, e.getMessage());
        }
        LinkedList<Attribute> attributeList = new LinkedList<Attribute>();
        Iterator<Attribute> i = attributes.allAttributes();
        while (i.hasNext()) {
            Attribute attribute = i.next();
            Matcher matcher = pattern.matcher(attribute.getName());
            if (!matcher.matches()) continue;
            attributeList.add(attribute);
        }
        Attribute[] attributesArray = new Attribute[attributeList.size()];
        attributesArray = attributeList.toArray(attributesArray);
        return attributesArray;
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        boolean onlyDistinctValues = this.getParameterAsBoolean(PARAMETER_ONLY_DISTINCT);
        boolean ignoreMissings = this.getParameterAsBoolean(PARAMETER_IGNORE_MISSINGS);
        List<String[]> parameterList = this.getParameterList(PARAMETER_AGGREGATION_ATTRIBUTES);
        int aggregations = parameterList.size();
        Attribute[] aggregationAttributes = new Attribute[aggregations];
        String[] aggregationFunctionNames = new String[aggregations];
        boolean[] nominalResults = new boolean[aggregations];
        int parameterListIndex = 0;
        for (String[] valuePair : parameterList) {
            String attributeName = valuePair[0];
            String aggregationFunctionName = valuePair[1];
            Attribute attribute = exampleSet.getAttributes().get(attributeName);
            if (attribute == null) {
                throw new UserError((Operator)this, 111, attributeName);
            }
            aggregationAttributes[parameterListIndex] = attribute;
            aggregationFunctionNames[parameterListIndex] = aggregationFunctionName;
            nominalResults[parameterListIndex] = attribute.isNominal() && aggregationFunctionName.equals(AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[7]);
            ++parameterListIndex;
        }
        Attribute weightAttribute = exampleSet.getAttributes().getWeight();
        MemoryExampleTable resultTable = null;
        if (this.isParameterSet(PARAMETER_GROUP_BY_ATTRIBUTES)) {
            AggregationFunction[] functions;
            String groupByAttributesRegex = this.getParameterAsString(PARAMETER_GROUP_BY_ATTRIBUTES);
            Attribute[] groupByAttributes = this.getAttributesArrayFromRegex(exampleSet.getAttributes(), groupByAttributesRegex);
            if (groupByAttributes.length == 0) {
                throw new UserError((Operator)this, 111, groupByAttributesRegex);
            }
            int[] mappingSizes = new int[groupByAttributes.length];
            int i = 0;
            while (i < groupByAttributes.length) {
                if (!groupByAttributes[i].isNominal()) {
                    throw new UserError((Operator)this, 103, groupByAttributesRegex, "grouping by attribute.");
                }
                mappingSizes[i] = groupByAttributes[i].getMapping().size();
                ++i;
            }
            MultidimensionalArraySet<AggregationFunction[]> functionSet = new MultidimensionalArraySet<AggregationFunction[]>(mappingSizes);
            if (onlyDistinctValues) {
                MultidimensionalArraySet<Object> distinctValueSet = new MultidimensionalArraySet<Object>(mappingSizes);
                for (Example example : exampleSet) {
                    int[] indices = new int[groupByAttributes.length];
                    int i2 = 0;
                    while (i2 < groupByAttributes.length) {
                        indices[i2] = (int)example.getValue(groupByAttributes[i2]);
                        ++i2;
                    }
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    Object distinctValues = (ValueSet[])distinctValueSet.get(indices);
                    if (distinctValues == null) {
                        distinctValues = new ValueSet[aggregations];
                        int j = 0;
                        while (j < aggregations) {
                            distinctValues[j] = new ValueSet();
                            ++j;
                        }
                        distinctValueSet.set(indices, distinctValues);
                    }
                    int i3 = 0;
                    while (i3 < aggregations) {
                        distinctValues[i3].add(example.getValue(aggregationAttributes[i3]), weight);
                        ++i3;
                    }
                }
                int i4 = 0;
                while (i4 < functionSet.size()) {
                    ValueSet[] distinctValues = (ValueSet[])distinctValueSet.get(i4);
                    if (distinctValues != null) {
                        AggregationFunction[] functions2 = new AggregationFunction[aggregations];
                        int j = 0;
                        while (j < aggregations) {
                            functions2[j] = this.getAggregationFunction(aggregationFunctionNames[j], ignoreMissings, aggregationAttributes[j]);
                            ++j;
                        }
                        functionSet.set(i4, functions2);
                        j = 0;
                        while (j < aggregations) {
                            for (Double value : distinctValues[j]) {
                                functions2[j].update(value);
                            }
                            ++j;
                        }
                    }
                    ++i4;
                }
            } else {
                for (Example example : exampleSet) {
                    int[] indices = new int[groupByAttributes.length];
                    int i5 = 0;
                    while (i5 < groupByAttributes.length) {
                        indices[i5] = (int)example.getValue(groupByAttributes[i5]);
                        ++i5;
                    }
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    functions = (AggregationFunction[])functionSet.get(indices);
                    if (functions == null) {
                        functions = new AggregationFunction[aggregations];
                        int j = 0;
                        while (j < aggregations) {
                            functions[j] = this.getAggregationFunction(aggregationFunctionNames[j], ignoreMissings, aggregationAttributes[j]);
                            ++j;
                        }
                        functionSet.set(indices, functions);
                    }
                    int i6 = 0;
                    while (i6 < aggregations) {
                        functions[i6].update(example.getValue(aggregationAttributes[i6]), weight);
                        ++i6;
                    }
                }
            }
            LinkedList<Attribute> resultAttributes = new LinkedList<Attribute>();
            Attribute[] resultGroupAttributes = new Attribute[groupByAttributes.length];
            int i7 = 0;
            while (i7 < groupByAttributes.length) {
                Attribute resultGroupAttribute = AttributeFactory.createAttribute(groupByAttributes[i7].getName(), 1);
                int j = 0;
                while (j < groupByAttributes[i7].getMapping().size()) {
                    resultGroupAttribute.getMapping().mapString(groupByAttributes[i7].getMapping().mapIndex(j));
                    ++j;
                }
                resultAttributes.add(resultGroupAttribute);
                resultGroupAttributes[i7] = resultGroupAttribute;
                ++i7;
            }
            i7 = 0;
            while (i7 < aggregations) {
                if (nominalResults[i7]) {
                    resultAttributes.add(AttributeFactory.createAttribute(String.valueOf(aggregationFunctionNames[i7]) + "(" + aggregationAttributes[i7].getName() + ")", 1));
                } else {
                    resultAttributes.add(AttributeFactory.createAttribute(String.valueOf(aggregationFunctionNames[i7]) + "(" + aggregationAttributes[i7].getName() + ")", 4));
                }
                ++i7;
            }
            resultTable = new MemoryExampleTable(resultAttributes);
            i7 = 0;
            while (i7 < functionSet.size()) {
                double[] data = new double[groupByAttributes.length + aggregations];
                int[] indices = functionSet.getIndices(i7);
                int j = 0;
                while (j < groupByAttributes.length) {
                    data[j] = indices[j];
                    ++j;
                }
                functions = (AggregationFunction[])functionSet.get(i7);
                if (functions != null) {
                    int j2 = 0;
                    while (j2 < aggregations) {
                        data[groupByAttributes.length + j2] = nominalResults[j2] ? (double)resultTable.getAttribute(groupByAttributes.length + j2).getMapping().mapString(aggregationAttributes[j2].getMapping().mapIndex((int)functions[j2].getValue())) : functions[j2].getValue();
                        ++j2;
                    }
                    resultTable.addDataRow(new DoubleArrayDataRow(data));
                }
                ++i7;
            }
        } else {
            AggregationFunction[] functions = new AggregationFunction[aggregations];
            int i = 0;
            while (i < aggregations) {
                functions[i] = this.getAggregationFunction(aggregationFunctionNames[i], ignoreMissings, aggregationAttributes[i]);
                ++i;
            }
            if (onlyDistinctValues) {
                ValueSet[] distinctValues = new ValueSet[aggregations];
                int i8 = 0;
                while (i8 < aggregations) {
                    distinctValues[i8] = new ValueSet();
                    ++i8;
                }
                for (Example example : exampleSet) {
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    int i9 = 0;
                    while (i9 < distinctValues.length) {
                        distinctValues[i9].add(example.getValue(aggregationAttributes[i9]), weight);
                        ++i9;
                    }
                }
                i = 0;
                while (i < distinctValues.length) {
                    for (Double value : distinctValues[i]) {
                        functions[i].update(value);
                    }
                    ++i;
                }
            } else {
                for (Example example : exampleSet) {
                    double weight = weightAttribute != null ? example.getWeight() : 1.0;
                    int i10 = 0;
                    while (i10 < functions.length) {
                        functions[i10].update(example.getValue(aggregationAttributes[i10]), weight);
                        ++i10;
                    }
                }
            }
            LinkedList<Attribute> resultAttributes = new LinkedList<Attribute>();
            Attribute resultGroupAttribute = AttributeFactory.createAttribute(GENERIC_GROUP_NAME, 1);
            resultAttributes.add(resultGroupAttribute);
            int i11 = 0;
            while (i11 < aggregations) {
                if (nominalResults[i11]) {
                    resultAttributes.add(AttributeFactory.createAttribute(String.valueOf(aggregationFunctionNames[i11]) + "(" + aggregationAttributes[i11].getName() + ")", 1));
                } else {
                    resultAttributes.add(AttributeFactory.createAttribute(String.valueOf(aggregationFunctionNames[i11]) + "(" + aggregationAttributes[i11].getName() + ")", 4));
                }
                ++i11;
            }
            for (Attribute attribute : resultAttributes) {
                attribute.setConstruction(attribute.getName());
            }
            resultTable = new MemoryExampleTable(resultAttributes);
            double[] data = new double[aggregations + 1];
            data[0] = resultGroupAttribute.getMapping().mapString(GENERIC_ALL_NAME);
            int i12 = 0;
            while (i12 < aggregations) {
                data[i12 + 1] = nominalResults[i12] ? (double)resultTable.getAttribute(i12 + 1).getMapping().mapString(aggregationAttributes[i12].getMapping().mapIndex((int)functions[i12].getValue())) : functions[i12].getValue();
                ++i12;
            }
            resultTable.addDataRow(new DoubleArrayDataRow(data));
        }
        ExampleSet resultSet = resultTable.createExampleSet();
        return resultSet;
    }

    private AggregationFunction getAggregationFunction(String functionName, boolean ignoreMissings, Attribute attribute) throws UserError {
        AggregationFunction function;
        try {
            function = AbstractAggregationFunction.createAggregationFunction(functionName, ignoreMissings);
        }
        catch (InstantiationException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UserError((Operator)this, 904, functionName, e.getMessage());
        }
        if (!function.supportsAttribute(attribute)) {
            throw new UserError((Operator)this, 136, attribute.getName());
        }
        return function;
    }

    public InputDescription getInputDescription(Class cls) {
        if (ExampleSet.class.isAssignableFrom(cls)) {
            return new InputDescription(cls, true, true);
        }
        return super.getInputDescription(cls);
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        ParameterTypeStringCategory functionParameter = new ParameterTypeStringCategory(PARAMETER_AGGREGATION_FUNCTIONS, "The type of the used aggregation function.", AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES, AbstractAggregationFunction.KNOWN_AGGREGATION_FUNCTION_NAMES[0]);
        types.add(new ParameterTypeList(PARAMETER_AGGREGATION_ATTRIBUTES, "The attributes which should be aggregated.", functionParameter));
        types.add(new ParameterTypeString(PARAMETER_GROUP_BY_ATTRIBUTES, "Performs a grouping by the values of the attributes whose names match the given regular expression."));
        types.add(new ParameterTypeBoolean(PARAMETER_ONLY_DISTINCT, "Indicates if only rows with distinct values for the aggregation attribute should be used for the calculation of the aggregation function.", false));
        types.add(new ParameterTypeBoolean(PARAMETER_IGNORE_MISSINGS, "Indicates if missings should be ignored and aggregation should be based only on existing values or not. In the latter case the aggregated value will be missing in the presence of missing values.", true));
        return types;
    }
}

