/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.htsengine.CartTreeSet;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSModel;
import marytts.htsengine.HTSPStream;
import marytts.htsengine.HTSUttModel;
import marytts.signalproc.analysis.Mfccs;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.util.MaryUtils;
import marytts.util.io.LEDataInputStream;
import org.apache.log4j.Logger;

public class HTSParameterGeneration {
    public static final double INFTY = 1.0E38;
    public static final double INFTY2 = 1.0E19;
    public static final double INVINF = 1.0E-38;
    public static final double INVINF2 = 1.0E-19;
    public static final double LTPI = 1.83787706640935;
    private HTSPStream mcepPst = null;
    private HTSPStream strPst = null;
    private HTSPStream magPst = null;
    private HTSPStream lf0Pst = null;
    private boolean[] voiced;
    private int totalUttFrame;
    private int totalLf0Frame;
    private Logger logger = MaryUtils.getLogger("ParameterGeneration");

    public double getMcep(int i, int j) {
        return this.mcepPst.getPar(i, j);
    }

    public int getMcepOrder() {
        return this.mcepPst.getOrder();
    }

    public int getMcepT() {
        return this.mcepPst.getT();
    }

    public HTSPStream getMcepPst() {
        return this.mcepPst;
    }

    public void setMcepPst(HTSPStream var) {
        this.mcepPst = var;
    }

    public double getStr(int i, int j) {
        return this.strPst.getPar(i, j);
    }

    public int getStrOrder() {
        return this.strPst.getOrder();
    }

    public HTSPStream getStrPst() {
        return this.strPst;
    }

    public double getMag(int i, int j) {
        return this.magPst.getPar(i, j);
    }

    public int getMagOrder() {
        return this.magPst.getOrder();
    }

    public HTSPStream getMagPst() {
        return this.magPst;
    }

    public double getLf0(int i, int j) {
        return this.lf0Pst.getPar(i, j);
    }

    public int getLf0Order() {
        return this.lf0Pst.getOrder();
    }

    public HTSPStream getlf0Pst() {
        return this.lf0Pst;
    }

    public void setlf0Pst(HTSPStream var) {
        this.lf0Pst = var;
    }

    public boolean getVoiced(int i) {
        return this.voiced[i];
    }

    public void setVoiced(int i, boolean bval) {
        this.voiced[i] = bval;
    }

    public boolean[] getVoicedArray() {
        return this.voiced;
    }

    public void setVoicedArray(boolean[] var) {
        this.voiced = var;
    }

    public static double finv(double x) {
        if (x >= 1.0E19) {
            return 0.0;
        }
        if (x <= -1.0E19) {
            return 0.0;
        }
        if (x <= 1.0E-19 && x >= 0.0) {
            return 1.0E38;
        }
        if (x >= -1.0E-19 && x < 0.0) {
            return -1.0E38;
        }
        return 1.0 / x;
    }

    public void htsMaximumLikelihoodParameterGeneration(HTSUttModel um, HMMData htsData) throws Exception {
        this.htsMaximumLikelihoodParameterGeneration(um, htsData, "", false);
    }

    public void htsMaximumLikelihoodParameterGeneration(HTSUttModel um, HMMData htsData, String parFileName, boolean debug) throws Exception {
        int frame;
        int state;
        HTSModel m;
        int i;
        CartTreeSet ms = htsData.getCartTreeSet();
        if (htsData.getPdfMgcStream() != null) {
            this.mcepPst = new HTSPStream(ms.getMcepVsize(), um.getTotalFrame(), 2, htsData.getMaxMgcGvIter());
        }
        if (htsData.getPdfLf0Stream() != null) {
            this.lf0Pst = new HTSPStream(ms.getLf0Stream(), um.getLf0Frame(), 1, htsData.getMaxLf0GvIter());
        }
        if (htsData.getPdfStrStream() != null) {
            this.strPst = new HTSPStream(ms.getStrVsize(), um.getTotalFrame(), 3, htsData.getMaxStrGvIter());
        }
        if (htsData.getPdfMagStream() != null) {
            this.magPst = new HTSPStream(ms.getMagVsize(), um.getTotalFrame(), 4, htsData.getMaxMagGvIter());
        }
        int lf0Frame = 0;
        int uttFrame = 0;
        this.voiced = new boolean[um.getTotalFrame()];
        for (i = 0; i < um.getNumUttModel(); ++i) {
            m = um.getUttModel(i);
            int numVoicedInModel = 0;
            for (state = 0; state < ms.getNumStates(); ++state) {
                for (frame = 0; frame < m.getDur(state); ++frame) {
                    this.voiced[uttFrame] = m.getVoiced(state);
                    ++uttFrame;
                    if (!m.getVoiced(state)) continue;
                    ++lf0Frame;
                    ++numVoicedInModel;
                }
            }
            m.setNumVoiced(numVoicedInModel);
        }
        this.logger.debug("utteranceFrame=" + uttFrame + " lf0frame=" + lf0Frame);
        this.totalUttFrame = uttFrame;
        this.totalLf0Frame = lf0Frame;
        uttFrame = 0;
        lf0Frame = 0;
        for (i = 0; i < um.getNumUttModel(); ++i) {
            m = um.getUttModel(i);
            boolean gvSwitch = m.getGvSwitch();
            for (state = 0; state < ms.getNumStates(); ++state) {
                for (frame = 0; frame < m.getDur(state); ++frame) {
                    int k;
                    if (this.mcepPst != null) {
                        for (k = 0; k < ms.getMcepVsize(); ++k) {
                            this.mcepPst.setMseq(uttFrame, k, m.getMcepMean(state, k));
                            if ((uttFrame == 0 || uttFrame == this.totalUttFrame - 1) && k >= this.mcepPst.getOrder()) {
                                this.mcepPst.setIvseq(uttFrame, k, 0.0);
                                continue;
                            }
                            this.mcepPst.setIvseq(uttFrame, k, HTSParameterGeneration.finv(m.getMcepVariance(state, k)));
                        }
                        if (!gvSwitch) {
                            this.mcepPst.setGvSwitch(uttFrame, false);
                        }
                    }
                    if (this.strPst != null) {
                        for (k = 0; k < ms.getStrVsize(); ++k) {
                            this.strPst.setMseq(uttFrame, k, m.getStrMean(state, k));
                            if ((uttFrame == 0 || uttFrame == this.totalUttFrame - 1) && k >= this.strPst.getOrder()) {
                                this.strPst.setIvseq(uttFrame, k, 0.0);
                                continue;
                            }
                            this.strPst.setIvseq(uttFrame, k, HTSParameterGeneration.finv(m.getStrVariance(state, k)));
                        }
                        if (!gvSwitch) {
                            this.strPst.setGvSwitch(uttFrame, false);
                        }
                    }
                    if (this.magPst != null) {
                        for (k = 0; k < ms.getMagVsize(); ++k) {
                            this.magPst.setMseq(uttFrame, k, m.getMagMean(state, k));
                            if ((uttFrame == 0 || uttFrame == this.totalUttFrame - 1) && k >= this.magPst.getOrder()) {
                                this.magPst.setIvseq(uttFrame, k, 0.0);
                                continue;
                            }
                            this.magPst.setIvseq(uttFrame, k, HTSParameterGeneration.finv(m.getMagVariance(state, k)));
                        }
                        if (!gvSwitch) {
                            this.magPst.setGvSwitch(uttFrame, false);
                        }
                    }
                    if (this.lf0Pst != null && !htsData.getUseAcousticModels()) {
                        for (k = 0; k < ms.getLf0Stream(); ++k) {
                            int lw = this.lf0Pst.getDWwidth(k, 0);
                            int rw = this.lf0Pst.getDWwidth(k, 1);
                            boolean nobound = true;
                            for (int n = lw; n <= rw; ++n) {
                                nobound = uttFrame + n <= 0 || um.getTotalFrame() <= uttFrame + n ? false : nobound && this.voiced[uttFrame + n];
                            }
                            if (!this.voiced[uttFrame]) continue;
                            this.lf0Pst.setMseq(lf0Frame, k, m.getLf0Mean(state, k));
                            if (nobound || k == 0) {
                                this.lf0Pst.setIvseq(lf0Frame, k, HTSParameterGeneration.finv(m.getLf0Variance(state, k)));
                                continue;
                            }
                            this.lf0Pst.setIvseq(lf0Frame, k, 0.0);
                        }
                    }
                    if (this.voiced[uttFrame]) {
                        if (!gvSwitch) {
                            this.lf0Pst.setGvSwitch(lf0Frame, false);
                        }
                        ++lf0Frame;
                    }
                    ++uttFrame;
                }
            }
        }
        if (this.mcepPst != null) {
            this.logger.info("Parameter generation for MGC: ");
            if (htsData.getUseGV()) {
                this.mcepPst.setGvMeanVar(htsData.getGVModelSet().getGVmeanMgc(), htsData.getGVModelSet().getGVcovInvMgc());
            }
            this.mcepPst.mlpg(htsData, htsData.getUseGV());
        }
        if (htsData.getUseAcousticModels()) {
            this.loadMaryXmlF0(um, htsData);
        } else if (this.lf0Pst != null) {
            this.logger.info("Parameter generation for LF0: ");
            if (htsData.getUseGV()) {
                this.lf0Pst.setGvMeanVar(htsData.getGVModelSet().getGVmeanLf0(), htsData.getGVModelSet().getGVcovInvLf0());
            }
            this.lf0Pst.mlpg(htsData, htsData.getUseGV());
            this.setRealisedF0(this.lf0Pst, um, ms.getNumStates());
        }
        boolean useGV = false;
        if (this.strPst != null) {
            this.logger.debug("Parameter generation for STR ");
            if (htsData.getUseGV() && htsData.getPdfStrGVStream() != null) {
                useGV = true;
                this.strPst.setGvMeanVar(htsData.getGVModelSet().getGVmeanStr(), htsData.getGVModelSet().getGVcovInvStr());
            }
            this.strPst.mlpg(htsData, useGV);
        }
        useGV = false;
        if (this.magPst != null) {
            this.logger.info("Parameter generation for MAG ");
            if (htsData.getUseGV() && htsData.getPdfMagGVStream() != null) {
                useGV = true;
                this.magPst.setGvMeanVar(htsData.getGVModelSet().getGVmeanMag(), htsData.getGVModelSet().getGVcovInvMag());
            }
            this.magPst.mlpg(htsData, useGV);
        }
        if (debug) {
            this.saveParam(parFileName + "mcep.bin", this.mcepPst, 2);
            this.saveParam(parFileName + "lf0.bin", this.lf0Pst, 1);
        }
    }

    public void saveParamMaryFormat(String fileName, HTSPStream par, int type) {
        double ws = 0.025;
        double ss = 0.005;
        int fs = 16000;
        try {
            if (type == 1) {
                fileName = fileName + ".ptc";
                int i = 0;
                double[] f0s = new double[this.voiced.length];
                for (int t = 0; t < this.voiced.length; ++t) {
                    if (this.voiced[t]) {
                        f0s[t] = Math.exp(par.getPar(i, 0));
                        ++i;
                    } else {
                        f0s[t] = 0.0;
                    }
                    System.out.println("GEN f0s[" + t + "]=" + f0s[t]);
                }
                PitchReaderWriter.write_pitch_file(fileName, f0s, (float)ws, (float)ss, fs);
            } else if (type == 2) {
                int numfrm = par.getT();
                int dimension = par.getOrder();
                Mfccs mgc = new Mfccs(numfrm, dimension);
                fileName = fileName + ".mfc";
                for (int t = 0; t < par.getT(); ++t) {
                    for (int m = 0; m < par.getOrder(); ++m) {
                        mgc.mfccs[t][m] = par.getPar(t, m);
                    }
                }
                mgc.params.samplingRate = fs;
                mgc.params.skipsize = (float)ss;
                mgc.params.winsize = (float)ws;
                mgc.writeMfccFile(fileName);
            }
            this.logger.info("saveParam in file: " + fileName);
        }
        catch (IOException e) {
            this.logger.info("IO exception = " + e);
        }
    }

    public void saveParam(String fileName, HTSPStream par, int type) {
        try {
            if (type == 1) {
                fileName = fileName + ".f0";
                DataOutputStream data_out = new DataOutputStream(new FileOutputStream(fileName));
                int i = 0;
                for (int t = 0; t < this.voiced.length; ++t) {
                    if (this.voiced[t]) {
                        data_out.writeFloat((float)Math.exp(par.getPar(i, 0)));
                        ++i;
                        continue;
                    }
                    data_out.writeFloat(0.0f);
                }
                data_out.close();
            } else if (type == 2) {
                fileName = fileName + ".mgc";
                DataOutputStream data_out = new DataOutputStream(new FileOutputStream(fileName));
                for (int t = 0; t < par.getT(); ++t) {
                    for (int m = 0; m < par.getOrder(); ++m) {
                        data_out.writeFloat((float)par.getPar(t, m));
                    }
                }
                data_out.close();
            }
            this.logger.info("saveParam in file: " + fileName);
        }
        catch (IOException e) {
            this.logger.info("IO exception = " + e);
        }
    }

    private void loadMaryXmlF0(HTSUttModel um, HMMData htsData) throws Exception {
        int n;
        this.logger.info("Using f0 from maryXML acoustparams");
        double lastF0 = 0.0;
        boolean numVoiced = false;
        Vector<Double> f0Vector = new Vector<Double>();
        for (int i = 0; i < um.getNumUttModel(); ++i) {
            HTSModel m = um.getUttModel(i);
            double[] dval = this.getContourSegment(m.getMaryXmlF0(), m.getNumVoiced());
            for (n = 0; n < dval.length; ++n) {
                f0Vector.add(dval[n]);
            }
        }
        this.interpolateSegments(f0Vector);
        HTSPStream newLf0Pst = new HTSPStream(3, f0Vector.size(), 1, htsData.getMaxLf0GvIter());
        for (n = 0; n < f0Vector.size(); ++n) {
            newLf0Pst.setPar(n, 0, Math.log(f0Vector.get(n)));
        }
        this.setlf0Pst(newLf0Pst);
    }

    private double[] getContourSegment(String maryXmlF0, int numVoiced) throws Exception {
        double[] f0Vector;
        block7: {
            int t = 0;
            boolean k = false;
            boolean f = false;
            f0Vector = new double[numVoiced];
            int[] index = new int[2];
            double[] value = new double[2];
            Pattern p = Pattern.compile("(\\d+,\\d+)");
            if (maryXmlF0 == null) break block7;
            Matcher xml = p.matcher(maryXmlF0);
            TreeMap<Integer, Double> f0Map = new TreeMap<Integer, Double>();
            int numF0s = 0;
            while (xml.find()) {
                String[] f0Values = xml.group().trim().split(",");
                f0Map.put(new Integer(f0Values[0]), new Double(f0Values[1]));
                ++numF0s;
            }
            Set s = f0Map.entrySet();
            Iterator if0 = s.iterator();
            if (numF0s == numVoiced) {
                t = 0;
                while (if0.hasNext() && t < numVoiced) {
                    Map.Entry mf0 = if0.next();
                    int key = (Integer)mf0.getKey();
                    double valF0 = (Double)mf0.getValue();
                    f0Vector[t++] = valF0;
                }
            } else {
                if (numF0s < numVoiced) {
                    for (int i = 0; i < numVoiced; ++i) {
                        f0Vector[i] = 0.0;
                    }
                }
                while (if0.hasNext() && t < numVoiced) {
                    Map.Entry mf0 = if0.next();
                    int key = (Integer)mf0.getKey();
                    double valF0 = (Double)mf0.getValue();
                    int n = key == 0 ? 0 : (key == 100 ? numVoiced - 1 : (int)((double)(numVoiced * key) / 100.0));
                    if (n < 0 || n >= numVoiced) continue;
                    f0Vector[n] = valF0;
                }
            }
        }
        return f0Vector;
    }

    private void interpolateSegments(Vector<Double> f0) {
        int[] index = new int[2];
        double[] value = new double[2];
        index[0] = 0;
        value[0] = 0.0;
        for (int i = 0; i < f0.size(); ++i) {
            if (!(f0.get(i) > 0.0)) continue;
            index[1] = i;
            value[1] = f0.get(i);
            int interval = index[1] - index[0];
            if (interval > 1) {
                double slope = (value[1] - value[0]) / (double)interval;
                for (int n = index[0]; n < index[1]; ++n) {
                    double newVal = slope * (double)(n - index[0]) + value[0];
                    f0.set(n, newVal);
                }
            }
            index[0] = index[1];
            value[0] = value[1];
        }
    }

    private void setRealisedF0(HTSPStream lf0Pst, HTSUttModel um, int numStates) {
        int t = 0;
        for (int i = 0; i < um.getNumUttModel(); ++i) {
            HTSModel m = um.getUttModel(i);
            int numVoicedInModel = m.getNumVoiced();
            String formattedF0 = "";
            int k = 1;
            for (int state = 0; state < numStates; ++state) {
                for (int frame = 0; frame < m.getDur(state); ++frame) {
                    if (!this.voiced[t++]) continue;
                    float f0 = (float)Math.exp(lf0Pst.getPar(i, 0));
                    formattedF0 = formattedF0 + "(" + Integer.toString((int)((double)k * 100.0 / (double)numVoicedInModel)) + "," + Integer.toString((int)f0) + ")";
                    ++k;
                }
            }
            if (formattedF0.contentEquals("")) continue;
            m.setMaryXmlF0(formattedF0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadLogF0FromExternalFile(String lf0File, int totalDurationFrames) throws Exception {
        int lf0Vsize = 3;
        int totalFrame = 0;
        int lf0VoicedFrame = 0;
        LEDataInputStream lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
        try {
            while (true) {
                float fval = lf0Data.readFloat();
                ++totalFrame;
                if (!(fval > 0.0f)) continue;
                ++lf0VoicedFrame;
            }
        }
        catch (EOFException e) {
            lf0Data.close();
            if (totalDurationFrames > totalFrame) {
                throw new Exception("The total duration in frames (" + totalDurationFrames + ") is greater than the number of frames in the lf0File (" + totalFrame + "): " + lf0File + "\nIt can be fixed to some extend using a smaller value for the variable: newStateDurationFactor");
            }
            if (totalDurationFrames < totalFrame) {
                if (Math.abs(totalDurationFrames - totalFrame) >= 5) throw new Exception("The total duration in frames (" + totalDurationFrames + ") is smaller than the number of frames in the lf0File (" + totalFrame + "): " + lf0File + "\nIt can be fixed to some extend using a greater value for the variable: newStateDurationFactor");
                System.out.println("Warning: The total duration in frames (" + totalDurationFrames + ") is smaller than the number of frames in the lf0 file (" + totalFrame + "): " + lf0File + "\n         It can be fixed to some extend using a greater value for the variable: newStateDurationFactor");
            } else {
                System.out.println("totalDurationFrames = " + totalDurationFrames + "  totalF0Frames = " + totalFrame);
            }
            this.voiced = new boolean[totalFrame];
            this.lf0Pst = new HTSPStream(lf0Vsize, totalFrame, 1, 0);
            lf0VoicedFrame = 0;
            lf0Data = new LEDataInputStream(new BufferedInputStream(new FileInputStream(lf0File)));
            for (int i = 0; i < totalFrame; ++i) {
                float fval = lf0Data.readFloat();
                if (fval < 0.0f) {
                    this.voiced[i] = false;
                    continue;
                }
                this.voiced[i] = true;
                this.lf0Pst.setPar(lf0VoicedFrame, 0, fval);
                ++lf0VoicedFrame;
            }
            lf0Data.close();
            return;
        }
    }
}

