/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.Arrays;
import marytts.signalproc.analysis.ShortTermSpectrumAnalyser;
import marytts.signalproc.window.Window;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.FFT;

public class ShortTermPhaseSpectrumAnalyser
extends ShortTermSpectrumAnalyser {
    public ShortTermPhaseSpectrumAnalyser(DoubleDataSource signal, int fftSize, Window window, int frameShift, int samplingRate) {
        super(signal, fftSize, window, frameShift, samplingRate);
    }

    @Override
    public double[] analyse(double[] frame) {
        if (frame.length != this.getFrameLengthSamples()) {
            throw new IllegalArgumentException("Expected frame of length " + this.getFrameLengthSamples() + ", got " + frame.length);
        }
        int len = frame.length;
        int middle = len / 2 + len % 2;
        System.arraycopy(frame, middle, this.real, 0, len - middle);
        System.arraycopy(frame, 0, this.real, this.real.length - middle, middle);
        if (this.real.length > frame.length) {
            Arrays.fill(this.real, len - middle, this.real.length - middle, 0.0);
        }
        FFT.realTransform(this.real, false);
        return FFT.computePhaseSpectrum_FD(this.real);
    }
}

