/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.LogSpectrum;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;

public class GaussWindow
extends Window {
    public static final double DEFAULT_SIGMA = 100.0;
    protected double sigma;
    protected double sigmasquare;

    public GaussWindow(int length) {
        this(length, 100.0, 1.0);
    }

    public GaussWindow(int length, double prescalingFactor) {
        this(length, 100.0, prescalingFactor);
    }

    public GaussWindow(int length, double sigma, double prescalingFactor) {
        this.window = new double[length];
        this.sigma = sigma;
        this.sigmasquare = sigma * sigma;
        this.prescalingFactor = prescalingFactor;
        this.initialise();
    }

    @Override
    protected void initialise() {
        int mid = this.window.length / 2 + 1;
        for (int i = 0; i < this.window.length; ++i) {
            int dist = i - mid;
            this.window[i] = Math.exp(-0.5 * (double)dist * (double)dist / this.sigmasquare);
        }
    }

    public String toString() {
        return "Gauss window";
    }

    public static void main(String[] args) {
        int samplingRate = Integer.getInteger("samplingrate", 1);
        int windowLengthMs = Integer.getInteger("windowlength.ms", 0);
        int windowLength = Integer.getInteger("windowlength.samples", 512);
        if (windowLengthMs != 0) {
            windowLength = windowLengthMs * samplingRate / 1000;
        }
        int fftSize = Math.max(4096, MathUtils.closestPowerOfTwoAbove(windowLength));
        GaussWindow w = new GaussWindow(windowLength);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0 / (double)samplingRate, w.window);
        timeGraph.showInJFrame(((Object)w).toString() + " in time domain", true, false);
        double[] fftSignal = new double[fftSize];
        double sum = MathUtils.sum(w.window);
        for (int i = 0; i < w.window.length; ++i) {
            fftSignal[i] = w.window[i] / sum;
        }
        LogSpectrum freqGraph = new LogSpectrum(fftSignal, samplingRate);
        freqGraph.showInJFrame(((Object)w).toString() + " log frequency response", true, false);
    }
}

