/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.container;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueSet
implements Iterable<Double> {
    private HashMap<Double, Double> valueMap = new HashMap();

    public void add(double value, double weight) {
        if (this.valueMap.containsKey(value)) {
            this.valueMap.put(value, this.valueMap.get(value) + weight);
        } else {
            this.valueMap.put(value, weight);
        }
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public boolean contains(double value) {
        return this.valueMap.containsKey(value);
    }

    @Override
    public Iterator<Double> iterator() {
        return this.valueMap.keySet().iterator();
    }

    public Iterator<Map.Entry<Double, Double>> weightedValuesIterator() {
        return this.valueMap.entrySet().iterator();
    }

    public int size() {
        return this.valueMap.size();
    }

    public double getMode() {
        double mode = Double.NaN;
        double maxWeight = Double.NEGATIVE_INFINITY;
        for (Map.Entry<Double, Double> entry : this.valueMap.entrySet()) {
            double weight = entry.getValue();
            if (!(weight > maxWeight)) continue;
            maxWeight = weight;
            mode = entry.getKey();
        }
        return mode;
    }
}

