/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.tools.math.container;

import com.rapidminer.tools.math.container.ReverseComparableComparator;
import com.rapidminer.tools.math.container.ReverseComparator;
import java.util.Comparator;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedPriorityQueue<E>
extends PriorityQueue<E> {
    private static final long serialVersionUID = 6020635755912950637L;
    private int bound;
    private Comparator<E> comparator;

    public BoundedPriorityQueue(int bound) {
        super(bound, new ReverseComparableComparator());
        this.comparator = new ReverseComparableComparator();
        this.bound = bound;
    }

    public BoundedPriorityQueue(int bound, Comparator<? super E> comp) {
        super(bound, new ReverseComparator<E>(comp));
        this.bound = bound;
        this.comparator = new ReverseComparator<E>(comp);
    }

    @Override
    public boolean offer(E e) {
        if (this.size() == this.bound) {
            Object head = this.peek();
            if (this.comparator.compare(e, head) > 0) {
                this.poll();
                return super.offer(e);
            }
        } else {
            return super.offer(e);
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    public boolean isFilled() {
        return this.size() == this.bound;
    }
}

