/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.exceptions.NoSuchPropertyException;
import marytts.modules.InternalModule;
import marytts.modules.MaryModule;
import marytts.modules.ModuleRegistry;
import marytts.modules.Synthesis;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.MbrolaVoice;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.SAXException;

public class TobiContourGenerator
extends InternalModule {
    private WeakHashMap<Element, TopBaseConfiguration> topBaseConfMap;
    private WeakHashMap<Element, ProsodicSettings> prosodyMap;
    private WeakHashMap<Document, Voice> defaultVoiceMap;
    private AllophoneSet allophoneSet;
    private String phoneSetPropertyName;
    private Map<String, Element> tobiMap;
    private String tobirulefilePropertyName;

    public TobiContourGenerator(String localeString) {
        super("ContourGenerator", MaryDataType.DURATIONS, MaryDataType.ACOUSTPARAMS, MaryUtils.string2locale(localeString));
        this.phoneSetPropertyName = localeString + ".allophoneset";
        this.tobirulefilePropertyName = localeString + ".cap.tobirulefile";
    }

    @Override
    public void startup() throws Exception {
        MaryModule synthesis;
        super.startup();
        try {
            synthesis = ModuleRegistry.getModule(Synthesis.class);
        }
        catch (NullPointerException npe) {
            synthesis = new Synthesis();
        }
        assert (synthesis != null);
        if (synthesis.getState() == 0) {
            synthesis.startup();
        }
        this.allophoneSet = MaryRuntimeUtils.needAllophoneSet(this.phoneSetPropertyName);
        this.tobiMap = new HashMap<String, Element>();
        this.loadTobiRules();
        this.topBaseConfMap = new WeakHashMap();
        this.prosodyMap = new WeakHashMap();
        this.defaultVoiceMap = new WeakHashMap();
    }

    private synchronized void loadTobiRules() throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException, NoSuchPropertyException {
        DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
        f.setValidating(false);
        DocumentBuilder b = f.newDocumentBuilder();
        Document tobiRules = b.parse(new FileInputStream(MaryProperties.needFilename(this.tobirulefilePropertyName)));
        Element root = tobiRules.getDocumentElement();
        Element e = MaryDomUtils.getFirstChildElement(root);
        while (e != null) {
            if (e.getTagName().equals("accent") || e.getTagName().equals("boundary")) {
                String name = e.getAttribute("name");
                this.tobiMap.put(name.toUpperCase(), e);
            }
            e = MaryDomUtils.getNextSiblingElement(e);
        }
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        this.defaultVoiceMap.put(doc, d.getDefaultVoice());
        this.determineProsodicSettings(doc);
        this.addOrDeleteBoundaries(doc);
        NodeList sentences = doc.getElementsByTagName("s");
        for (int i = 0; i < sentences.getLength(); ++i) {
            Element sentence = (Element)sentences.item(i);
            this.processSentence(sentence);
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(doc);
        return result;
    }

    private void determineProsodicSettings(Document doc) {
        NodeList prosodies = doc.getElementsByTagName("prosody");
        for (int i = 0; i < prosodies.getLength(); ++i) {
            Element prosody = (Element)prosodies.item(i);
            this.determineProsodicSettings(prosody);
        }
    }

    private void determineProsodicSettings(Element prosody) {
        ProsodicSettings testSettings;
        ProsodicSettings settings = new ProsodicSettings();
        ProsodicSettings parentSettings = new ProsodicSettings();
        Element ancestor = (Element)MaryDomUtils.getAncestor((Node)prosody, "prosody");
        if (ancestor != null && (testSettings = this.prosodyMap.get(ancestor)) != null) {
            parentSettings = testSettings;
        }
        settings.setRate(parentSettings.rate() + MaryUtils.getPercentageDelta(prosody.getAttribute("rate")));
        settings.setAccentProminence(parentSettings.accentProminence() + MaryUtils.getPercentageDelta(prosody.getAttribute("accent-prominence")));
        settings.setAccentSlope(parentSettings.accentSlope() + MaryUtils.getPercentageDelta(prosody.getAttribute("accent-slope")));
        settings.setNumberOfPauses(parentSettings.numberOfPauses() + MaryUtils.getPercentageDelta(prosody.getAttribute("number-of-pauses")));
        settings.setPauseDuration(parentSettings.pauseDuration() + MaryUtils.getPercentageDelta(prosody.getAttribute("pause-duration")));
        settings.setVowelDuration(parentSettings.vowelDuration() + MaryUtils.getPercentageDelta(prosody.getAttribute("vowel-duration")));
        settings.setPlosiveDuration(parentSettings.plosiveDuration() + MaryUtils.getPercentageDelta(prosody.getAttribute("plosive-duration")));
        settings.setFricativeDuration(parentSettings.fricativeDuration() + MaryUtils.getPercentageDelta(prosody.getAttribute("fricative-duration")));
        settings.setNasalDuration(parentSettings.nasalDuration() + MaryUtils.getPercentageDelta(prosody.getAttribute("nasal-duration")));
        settings.setLiquidDuration(parentSettings.liquidDuration() + MaryUtils.getPercentageDelta(prosody.getAttribute("liquid-duration")));
        settings.setGlideDuration(parentSettings.glideDuration() + MaryUtils.getPercentageDelta(prosody.getAttribute("glide-duration")));
        String sVolume = prosody.getAttribute("volume");
        if (sVolume.equals("")) {
            settings.setVolume(parentSettings.volume());
        } else if (MaryUtils.isPercentageDelta(sVolume)) {
            int newVolume = parentSettings.volume() + MaryUtils.getPercentageDelta(sVolume);
            if (newVolume < 0) {
                newVolume = 0;
            } else if (newVolume > 100) {
                newVolume = 100;
            }
            settings.setVolume(newVolume);
        } else if (MaryUtils.isUnsignedNumber(sVolume)) {
            settings.setVolume(MaryUtils.getUnsignedNumber(sVolume));
        } else if (sVolume.equals("silent")) {
            settings.setVolume(0);
        } else if (sVolume.equals("soft")) {
            settings.setVolume(25);
        } else if (sVolume.equals("medium")) {
            settings.setVolume(50);
        } else if (sVolume.equals("loud")) {
            settings.setVolume(75);
        }
        this.prosodyMap.put(prosody, settings);
    }

    private void addOrDeleteBoundaries(Document doc) {
        NodeIterator it = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NameNodeFilter("boundary"), false);
        Element boundary = null;
        ArrayList<Element> bi1prosodyElements = null;
        while ((boundary = (Element)it.nextNode()) != null) {
            int minBI = 3;
            Element prosody = (Element)MaryDomUtils.getAncestor((Node)boundary, "prosody");
            if (prosody != null) {
                ProsodicSettings settings = this.prosodyMap.get(prosody);
                assert (settings != null);
                int rate = settings.rate();
                int numberOfPauses = settings.numberOfPauses();
                if (numberOfPauses <= 50) {
                    minBI = 5;
                } else if (numberOfPauses <= 75) {
                    minBI = 4;
                } else if (numberOfPauses > 150) {
                    minBI = 1;
                } else if (numberOfPauses > 125) {
                    minBI = 2;
                }
                if (rate < 90 && minBI > 1) {
                    --minBI;
                }
                if (minBI == 1) {
                    if (bi1prosodyElements == null) {
                        bi1prosodyElements = new ArrayList<Element>();
                    }
                    bi1prosodyElements.add(prosody);
                }
            }
            int bi = 3;
            try {
                bi = Integer.parseInt(boundary.getAttribute("breakindex"));
            }
            catch (NumberFormatException e) {
                this.logger.info("Unexpected breakindex value `" + boundary.getAttribute("breakindex") + "', assuming " + bi);
            }
        }
        if (bi1prosodyElements != null) {
            for (Element prosody : bi1prosodyElements) {
                NodeIterator nodeIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(prosody, 1, new NameNodeFilter("t", "boundary"), false);
                Element el = null;
                Element prevEl = null;
                while ((el = (Element)nodeIt.nextNode()) != null) {
                    if (el.getTagName().equals("t") && prevEl != null && prevEl.getTagName().equals("t")) {
                        Element newBoundary = MaryXML.createElement(doc, "boundary");
                        newBoundary.setAttribute("breakindex", "1");
                        el.getParentNode().insertBefore(newBoundary, el);
                    }
                    prevEl = el;
                }
            }
        }
    }

    private void processSentence(Element sentence) {
        NodeList tokens = sentence.getElementsByTagName("t");
        if (tokens.getLength() < 1) {
            return;
        }
        NodeList phrases = sentence.getElementsByTagName("phrase");
        for (int i = 0; i < phrases.getLength(); ++i) {
            Element phrase = (Element)phrases.item(i);
            this.calculateF0Targets(phrase);
        }
    }

    private void determinePhraseTopBaseConf(Element phrase) {
        Voice voice = null;
        Element voiceElement = (Element)MaryDomUtils.getAncestor((Node)phrase, "voice");
        if (voiceElement != null) {
            voice = Voice.getVoice(voiceElement);
        }
        if (voice == null) {
            voice = this.defaultVoiceMap.get(phrase.getOwnerDocument());
        }
        if (voice == null) {
            voice = Voice.getDefaultVoice(this.getLocale());
        }
        if (!(voice instanceof MbrolaVoice)) {
            throw new IllegalStateException("TobiContourGenerator can be used only for MBROLA voices, but voice " + voice.getName() + " is a " + voice.getClass().toString());
        }
        MbrolaVoice mVoice = (MbrolaVoice)voice;
        int topStart = mVoice.topStart();
        int topEnd = mVoice.topEnd();
        int baseStart = mVoice.baseStart();
        int baseEnd = mVoice.baseEnd();
        TopBaseConfiguration tbConf = new TopBaseConfiguration(topStart, topEnd, baseStart, baseEnd);
        Element current = phrase;
        Stack<Element> prosodyElements = new Stack<Element>();
        while (MaryDomUtils.hasAncestor(current, "prosody")) {
            current = (Element)MaryDomUtils.getAncestor((Node)current, "prosody");
            prosodyElements.push(current);
            if (voiceElement == null || MaryDomUtils.isAncestor(voiceElement, current)) continue;
        }
        while (!prosodyElements.empty()) {
            Element prosody = (Element)prosodyElements.pop();
            tbConf = this.calculateTopBase(prosody, tbConf);
        }
        Element lastSegment = MaryDomUtils.getLastElementByTagName(phrase, "ph");
        if (lastSegment != null) {
            int endTime = TobiContourGenerator.getSegmentEndInMillis(lastSegment);
            if (endTime == -1) {
                this.logger.warn("Unexpected end time `" + lastSegment.getAttribute("end") + "'");
            }
            tbConf.setTimes(0, endTime);
        }
        this.topBaseConfMap.put(phrase, tbConf);
    }

    private void determineProsodyTopBaseConf(Element prosody) {
        if (prosody == null) {
            throw new NullPointerException("Received null argument");
        }
        if (!prosody.getTagName().equals("prosody")) {
            throw new IllegalArgumentException("Expected <prosody> argument, got <" + prosody.getTagName() + ">");
        }
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)prosody, "phrase");
        if (phrase == null) {
            this.logger.warn("Trying to determine prosody top base conf for element without a <phrase> ancestor. Ignoring.");
            return;
        }
        Element confReferenceKey = phrase;
        Element firstSegment = MaryDomUtils.getFirstElementByTagName(prosody, "ph");
        if (firstSegment == null) {
            this.logger.info("prosody top base conf for element containing no phones -- ignoring.");
            return;
        }
        Element prosodyAncestor = (Element)MaryDomUtils.getAncestor((Node)prosody, "prosody");
        if (prosodyAncestor != null && MaryDomUtils.isAncestor(phrase, prosodyAncestor)) {
            confReferenceKey = prosodyAncestor;
        }
        TopBaseConfiguration confReference = this.topBaseConfMap.get(confReferenceKey);
        assert (confReference != null);
        int startTime = 0;
        try {
            startTime = TobiContourGenerator.getSegmentEndInMillis(firstSegment) - Integer.parseInt(firstSegment.getAttribute("d"));
        }
        catch (NumberFormatException e) {
            this.logger.warn("Unexpected start time `" + TobiContourGenerator.getSegmentEndInMillis(firstSegment) + "' - `" + firstSegment.getAttribute("d") + "'");
        }
        Element lastSegment = MaryDomUtils.getLastElementByTagName(prosody, "ph");
        int endTime = TobiContourGenerator.getSegmentEndInMillis(lastSegment);
        if (endTime == -1) {
            this.logger.warn("Unexpected end time `" + lastSegment.getAttribute("end") + "'");
        }
        TopBaseConfiguration tbConf = new TopBaseConfiguration(confReference.toplineFrequency(startTime), confReference.toplineFrequency(endTime), confReference.baselineFrequency(startTime), confReference.baselineFrequency(endTime), startTime, endTime);
        tbConf = this.calculateTopBase(prosody, tbConf);
        this.topBaseConfMap.put(prosody, tbConf);
    }

    private TopBaseConfiguration calculateTopBase(Element prosody, TopBaseConfiguration origConf) {
        String rangeDynamics;
        String pitchDynamics;
        String range;
        int topStart = origConf.topStart();
        int topEnd = origConf.topEnd();
        int baseStart = origConf.baseStart();
        int baseEnd = origConf.baseEnd();
        String pitch = prosody.getAttribute("pitch");
        if (!pitch.equals("")) {
            if (MaryUtils.isPercentageDelta(pitch)) {
                int percentage = MaryUtils.getPercentageDelta(pitch);
                baseStart = baseStart * (100 + percentage) / 100;
                baseEnd = baseEnd * (100 + percentage) / 100;
                topStart = topStart * (100 + percentage) / 100;
                topEnd = topEnd * (100 + percentage) / 100;
            } else if (MaryUtils.isSemitonesDelta(pitch)) {
                double semitones = MaryUtils.getSemitonesDelta(pitch);
                double factor = Math.pow(1.0595, semitones);
                baseStart = (int)((double)baseStart * factor);
                baseEnd = (int)((double)baseEnd * factor);
                topStart = (int)((double)topStart * factor);
                topEnd = (int)((double)topEnd * factor);
            } else if (MaryUtils.isNumberDelta(pitch)) {
                int delta = MaryUtils.getNumberDelta(pitch);
                baseStart += delta;
                baseEnd += delta;
                topStart += delta;
                topEnd += delta;
            } else if (MaryUtils.isUnsignedNumber(pitch)) {
                int baseMean = (baseStart + baseEnd) / 2;
                int topMean = (topStart + topEnd) / 2;
                double topBaseRatio = (double)topMean / (double)baseMean;
                int topSpread = (topEnd - topStart) / 2;
                int newBaseMean = MaryUtils.getUnsignedNumber(pitch);
                int baseSpread = (baseEnd - baseStart) / 2;
                baseStart = newBaseMean - baseSpread;
                baseEnd = newBaseMean + baseSpread;
                topStart = (int)((double)newBaseMean * topBaseRatio - (double)topSpread);
                topEnd = (int)((double)newBaseMean * topBaseRatio + (double)topSpread);
            }
        }
        if (!(range = prosody.getAttribute("range")).equals("")) {
            if (MaryUtils.isPercentageDelta(range)) {
                int percentage = MaryUtils.getPercentageDelta(range);
                topStart = baseStart + (topStart - baseStart) * (100 + percentage) / 100;
                topEnd = baseEnd + (topEnd - baseEnd) * (100 + percentage) / 100;
            } else if (MaryUtils.isSemitonesDelta(range)) {
                double semitones = MaryUtils.getSemitonesDelta(range);
                double factor = Math.pow(1.0595, semitones);
                int deltaStart = (int)((double)(topStart - baseStart) * factor);
                int deltaEnd = (int)((double)(topEnd - baseEnd) * factor);
                topStart = baseStart + deltaStart;
                topEnd = baseEnd + deltaEnd;
            } else if (MaryUtils.isNumberDelta(range)) {
                int delta = MaryUtils.getNumberDelta(range);
                topStart += delta;
                topEnd += delta;
            } else if (MaryUtils.isUnsignedSemitones(range)) {
                double semitones = MaryUtils.getUnsignedSemitones(range);
                double factor = Math.pow(1.0595, semitones);
                topStart = (int)((double)baseStart * factor);
                topEnd = (int)((double)baseEnd * factor);
            } else if (MaryUtils.isUnsignedNumber(range)) {
                int baseMean = (baseStart + baseEnd) / 2;
                int topSpread = (topEnd - topStart) / 2;
                int newRange = MaryUtils.getUnsignedNumber(range);
                topStart = baseMean + newRange - topSpread;
                topEnd = baseMean + newRange + topSpread;
            }
        }
        if (!(pitchDynamics = prosody.getAttribute("pitch-dynamics")).equals("")) {
            if (MaryUtils.isPercentageDelta(pitchDynamics)) {
                int percentage = MaryUtils.getPercentageDelta(pitchDynamics);
                int baseMean = (baseStart + baseEnd) / 2;
                baseStart = 200 * baseMean / (200 + percentage);
                baseEnd = baseStart * (100 + percentage) / 100;
            } else if (MaryUtils.isNumberDelta(pitchDynamics)) {
                int delta = MaryUtils.getNumberDelta(pitchDynamics);
                int baseMean = (baseStart + baseEnd) / 2;
                baseStart = baseMean + delta / 2;
                baseEnd = baseMean - delta / 2;
            } else if (MaryUtils.isSemitonesDelta(pitchDynamics)) {
                double semitones = MaryUtils.getSemitonesDelta(pitchDynamics);
                double factor = Math.pow(1.0595, semitones);
                int baseMean = (baseStart + baseEnd) / 2;
                baseStart = (int)((double)(2 * baseMean) / (1.0 + factor));
                baseEnd = (int)(factor * (double)baseStart);
            }
        }
        if (!(rangeDynamics = prosody.getAttribute("range-dynamics")).equals("")) {
            int rangeMean;
            int topMean;
            int baseMean;
            if (MaryUtils.isPercentageDelta(rangeDynamics)) {
                int percentage = MaryUtils.getPercentageDelta(rangeDynamics);
                baseMean = (baseStart + baseEnd) / 2;
                topMean = (topStart + topEnd) / 2;
                rangeMean = topMean - baseMean;
                int rangeStart = 200 * rangeMean / (200 + percentage);
                int rangeEnd = rangeStart * (100 + percentage) / 100;
                topStart = baseStart + rangeStart;
                topEnd = baseEnd + rangeEnd;
            } else if (MaryUtils.isNumberDelta(rangeDynamics)) {
                int delta = MaryUtils.getNumberDelta(rangeDynamics);
                baseMean = (baseStart + baseEnd) / 2;
                topMean = (topStart + topEnd) / 2;
                rangeMean = topMean - baseMean;
                int rangeStart = rangeMean + delta / 2;
                int rangeEnd = rangeMean - delta / 2;
                topStart = baseStart + rangeStart;
                topEnd = baseEnd + rangeEnd;
            } else if (MaryUtils.isSemitonesDelta(rangeDynamics)) {
                double semitones = MaryUtils.getSemitonesDelta(rangeDynamics);
                double factor = Math.pow(1.0595, semitones);
                int baseMean2 = (baseStart + baseEnd) / 2;
                int topMean2 = (topStart + topEnd) / 2;
                int rangeMean2 = topMean2 - baseMean2;
                int rangeStart = (int)((double)(2 * rangeMean2) / (1.0 + factor));
                int rangeEnd = (int)(factor * (double)rangeStart);
                topStart = baseStart + rangeStart;
                topEnd = baseEnd + rangeEnd;
            }
        }
        if (topStart < baseStart) {
            topStart = baseStart;
        }
        if (topEnd < baseEnd) {
            topEnd = baseEnd;
        }
        return new TopBaseConfiguration(topStart, topEnd, baseStart, baseEnd, origConf.startTime(), origConf.endTime());
    }

    private void calculateF0Targets(Element phrase) {
        this.determinePhraseTopBaseConf(phrase);
        NodeList prosodies = phrase.getElementsByTagName("prosody");
        for (int j = 0; j < prosodies.getLength(); ++j) {
            Element prosody = (Element)prosodies.item(j);
            this.determineProsodyTopBaseConf(prosody);
        }
        boolean isFirstInPhrase = true;
        Element prevToneSyllable = null;
        int prevTone = 0;
        int lastHFreq = 0;
        ArrayList<Target> allTargetList = new ArrayList<Target>();
        TreeWalker tw = ((DocumentTraversal)((Object)phrase.getOwnerDocument())).createTreeWalker(phrase, 1, new NameNodeFilter("t", "boundary"), false);
        Element e = null;
        while ((e = (Element)tw.nextNode()) != null) {
            String tone;
            Element referenceSyllable = null;
            Element rule = null;
            if (e.getTagName().equals("t")) {
                String accent;
                if (e.hasAttribute("accent") && (rule = this.tobiMap.get(accent = e.getAttribute("accent").toUpperCase())) != null) {
                    referenceSyllable = this.getStressedSyllable(e);
                }
            } else if (e.hasAttribute("tone") && (rule = this.tobiMap.get(tone = e.getAttribute("tone").toUpperCase())) != null) {
                TreeWalker stw = ((DocumentTraversal)((Object)e.getOwnerDocument())).createTreeWalker(phrase, 1, new NameNodeFilter("syllable"), false);
                stw.setCurrentNode(e);
                referenceSyllable = (Element)stw.previousNode();
            }
            if (referenceSyllable == null || rule == null) continue;
            this.logger.debug("Now assigning targets for tone `" + rule.getAttribute("name") + "' on syllable [" + referenceSyllable.getAttribute("ph") + "]");
            ArrayList<Target> targetList = new ArrayList<Target>();
            Target starTarget = null;
            TreeWalker rtw = ((DocumentTraversal)((Object)rule.getOwnerDocument())).createTreeWalker(rule, 1, new NameNodeFilter("target", "prosody"), false);
            Element rulePart = null;
            while ((rulePart = (Element)rtw.nextNode()) != null) {
                if (rulePart.getTagName().equals("target")) {
                    Target target = this.determineInitialTargetLocation(rulePart, referenceSyllable, isFirstInPhrase, (char)prevTone, prevToneSyllable);
                    if (target == null) continue;
                    targetList.add(target);
                    allTargetList.add(target);
                    this.logger.debug("  " + target.type() + " target on [" + target.segment().getAttribute("p") + "] at " + target.getTargetTime() + " ms");
                    if (!target.type().equals("star")) continue;
                    if (starTarget != null) {
                        this.logger.info("Found more than one star target for tone rule `" + rule.getAttribute("name") + "'");
                    }
                    starTarget = target;
                    continue;
                }
                String tCode = rulePart.getAttribute("t_code");
                Element prosSyllable = null;
                if (tCode.equals("21")) {
                    prosSyllable = referenceSyllable;
                } else if (tCode.equals("11")) {
                    prosSyllable = MaryDomUtils.getPreviousOfItsKindIn(referenceSyllable, phrase);
                } else if (tCode.equals("31")) {
                    prosSyllable = MaryDomUtils.getNextOfItsKindIn(referenceSyllable, phrase);
                } else if (tCode.equals("99")) {
                    prosSyllable = MaryDomUtils.getNextOfItsKindIn(prevToneSyllable, phrase);
                }
                if (prosSyllable == null) {
                    prosSyllable = referenceSyllable;
                }
                this.logger.debug("  upstep/downstep starting with syllable [" + prosSyllable.getAttribute("ph") + "]");
                this.adaptProsody(rulePart, prosSyllable);
            }
            for (Target target : targetList) {
                target.setMyStar(starTarget);
                if (!target.type().equals("plus")) continue;
                this.adjustTargetLocation(target, starTarget);
            }
            for (Target target : targetList) {
                lastHFreq = this.calculateTargetFrequency(target, lastHFreq);
            }
            isFirstInPhrase = false;
            prevToneSyllable = referenceSyllable;
            String label = rule.getAttribute("name");
            if (label.lastIndexOf(72) > label.lastIndexOf(76)) {
                prevTone = 72;
                continue;
            }
            prevTone = 76;
        }
        ListIterator it = allTargetList.listIterator();
        Target prev = null;
        Target current = null;
        Target next = null;
        while (it.hasNext()) {
            int nextTargetTime;
            int currentTargetTime;
            next = (Target)it.next();
            if (current != null && (currentTargetTime = current.getTargetTime()) > (nextTargetTime = next.getTargetTime())) {
                int newTiming;
                if (current.type().equals("star") && !next.type().equals("star")) {
                    Element oldSegment = next.segment();
                    Element newSegment = TobiContourGenerator.getNextSegment(current.segment());
                    newTiming = 10;
                    if (newSegment == null) {
                        newSegment = current.segment();
                        newTiming = 100;
                    }
                    next.setSegment(newSegment);
                    next.setTiming(newTiming);
                    this.calculateTargetFrequency(next, 0);
                    this.logger.debug("Found overlapping targets. Moved \"plus\" target from " + nextTargetTime + "ms [" + oldSegment.getAttribute("p") + "] to " + next.getTargetTime() + "ms [" + next.segment().getAttribute("p") + "].");
                } else if (next.type().equals("star") && !current.type().equals("star")) {
                    Element oldSegment = current.segment();
                    Element newSegment = TobiContourGenerator.getPreviousSegment(next.segment());
                    newTiming = 90;
                    if (newSegment == null) {
                        newSegment = next.segment();
                        newTiming = 0;
                    }
                    current.setSegment(newSegment);
                    current.setTiming(newTiming);
                    this.calculateTargetFrequency(current, 0);
                    this.logger.debug("Found overlapping targets. Moved \"plus\" target from " + currentTargetTime + "ms [" + oldSegment.getAttribute("p") + "] to " + current.getTargetTime() + "ms [" + current.segment().getAttribute("p") + "].");
                } else {
                    int f1;
                    int t1;
                    int tn = next.getTargetTime();
                    int fn = next.f0();
                    int tc = current.getTargetTime();
                    int fc = current.f0();
                    if (next.myStar() != null && next.myStar() != next && current.myStar() != null && current.myStar() != current) {
                        int tns = next.myStar().getTargetTime();
                        int fns = next.myStar().f0();
                        int tcs = current.myStar().getTargetTime();
                        int fcs = current.myStar().f0();
                        double slope_n = ((double)fns - (double)fn) / (double)(tns - tn);
                        double slope_c = ((double)fc - (double)fcs) / (double)(tc - tcs);
                        if (slope_n < 0.0 && slope_c >= 0.0 || slope_c < 0.0 && slope_n >= 0.0) {
                            t1 = (int)(((double)fn - slope_n * (double)tn - ((double)fc - slope_c * (double)tc)) / (slope_c - slope_n));
                            f1 = (int)((double)fn + slope_n * (double)(t1 - tn));
                        } else {
                            t1 = (tn + tc) / 2;
                            f1 = (fn + fc) / 2;
                        }
                    } else {
                        t1 = (tn + tc) / 2;
                        f1 = (fn + fc) / 2;
                    }
                    current.setTargetTime(t1);
                    current.setF0(f1);
                    this.logger.debug("Found two overlapping targets, at " + tc + "ms, " + fc + "Hz and " + tn + "ms, " + fn + "Hz. Replaced them with a target at " + t1 + "ms, " + f1 + "Hz.");
                    it.remove();
                    continue;
                }
            }
            if (prev != null) {
                int prevTime = prev.getTargetTime();
                int currentTime = current.getTargetTime();
                int nextTime = next.getTargetTime();
                if (current.myStar() == next && nextTime - currentTime > currentTime - prevTime || current.myStar() == prev && currentTime - prevTime > nextTime - currentTime) {
                    int newTime = (prevTime + nextTime) / 2;
                    this.logger.debug("Target at " + currentTime + "ms is further from its star than from" + " a different target -- moving to " + newTime + "ms.");
                    current.setTargetTime(newTime);
                    this.calculateTargetFrequency(current, 0);
                }
            }
            prev = current;
            current = next;
        }
        it = allTargetList.listIterator();
        while (it.hasNext()) {
            this.insertTargetIntoMaryXML((Target)it.next());
        }
    }

    private Target determineInitialTargetLocation(Element rulePart, Element syllable, boolean isFirstInPhrase, char prevTone, Element prevToneSyllable) {
        Element syl;
        if (rulePart == null || !rulePart.getTagName().equals("target") || syllable == null || !syllable.getTagName().equals("syllable")) {
            return null;
        }
        if (rulePart.hasAttribute("condition")) {
            String condition = rulePart.getAttribute("condition");
            if (condition.equals("first_in_IP") && !isFirstInPhrase) {
                return null;
            }
            if (condition.equals("prevtone_H") && prevTone != 'H') {
                return null;
            }
            if (condition.equals("prevtone_L") && prevTone != 'L') {
                return null;
            }
        }
        Element segment = null;
        int timing = -1;
        String tCode = rulePart.getAttribute("t_code");
        if (tCode.equals("0")) {
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)syllable, "phrase");
            segment = MaryDomUtils.getFirstElementByTagName(phrase, "ph");
            timing = 0;
        } else if (tCode.equals("12")) {
            Element prevSyl = TobiContourGenerator.getPreviousSyllable(syllable);
            if (prevSyl != null) {
                Element nucleus = this.getNucleus(prevSyl);
                segment = nucleus == null ? MaryDomUtils.getFirstElementByTagName(prevSyl, "ph") : nucleus;
                timing = 0;
            }
        } else if (tCode.equals("21")) {
            segment = MaryDomUtils.getFirstElementByTagName(syllable, "ph");
            timing = 0;
        } else if (tCode.equals("22")) {
            Element nucleus = this.getNucleus(syllable);
            segment = nucleus == null ? MaryDomUtils.getFirstElementByTagName(syllable, "ph") : nucleus;
            timing = 0;
        } else if (tCode.equals("23")) {
            Element nucleus = this.getNucleus(syllable);
            segment = nucleus == null ? MaryDomUtils.getFirstElementByTagName(syllable, "ph") : nucleus;
            timing = 50;
        } else if (tCode.equals("24")) {
            Element nucleus = this.getNucleus(syllable);
            segment = nucleus == null ? MaryDomUtils.getLastElementByTagName(syllable, "ph") : nucleus;
            timing = 100;
        } else if (tCode.equals("25")) {
            segment = MaryDomUtils.getLastElementByTagName(syllable, "ph");
            timing = 100;
        } else if (tCode.equals("34")) {
            Element nextSyl = TobiContourGenerator.getNextSyllable(syllable);
            if (nextSyl != null) {
                Element nucleus = this.getNucleus(nextSyl);
                segment = nucleus == null ? MaryDomUtils.getLastElementByTagName(nextSyl, "ph") : nucleus;
                timing = 100;
            }
        } else if (tCode.equals("99")) {
            Element syl2 = TobiContourGenerator.getNextSyllable(prevToneSyllable);
            if (syl2 != null) {
                Element nucleus = this.getNucleus(syl2);
                segment = nucleus == null ? MaryDomUtils.getFirstElementByTagName(syl2, "ph") : nucleus;
                timing = 50;
            }
        } else if (tCode.equals("98") && (syl = TobiContourGenerator.getNextSyllable(prevToneSyllable)) != null && (syl = TobiContourGenerator.getNextSyllable(syl)) != null) {
            Element nucleus;
            Element fallback = syl;
            while (syl != null && !syl.getAttribute("stress").equals("1") && !syl.getAttribute("stress").equals("2")) {
                syl = TobiContourGenerator.getNextSyllable(syl);
            }
            if (syl == null) {
                syl = fallback;
            }
            segment = (nucleus = this.getNucleus(syl)) == null ? MaryDomUtils.getFirstElementByTagName(syl, "ph") : nucleus;
            timing = 50;
        }
        if (segment == null || timing == -1) {
            this.logger.debug("  Target (" + rulePart.getAttribute("f0") + ") could not be attached. skipping.");
            return null;
        }
        return new Target(rulePart, segment, timing, 0);
    }

    private void adjustTargetLocation(Target plus, Target star) {
        if (plus == null || plus.segment() == null || plus.timing() == -1 || star == null || star.segment() == null || star.timing() == -1) {
            return;
        }
        Element prosody = (Element)MaryDomUtils.getAncestor((Node)plus.segment(), "prosody");
        if (prosody == null) {
            return;
        }
        ProsodicSettings settings = this.prosodyMap.get(prosody);
        assert (settings != null);
        int accentSlope = settings.accentSlope();
        if (accentSlope == 100) {
            return;
        }
        if (accentSlope == 0) {
            accentSlope = 1;
        }
        int plusTime = plus.getTargetTime();
        int starTime = star.getTargetTime();
        if (plusTime == -1 || starTime == -1) {
            return;
        }
        int distance = starTime - plusTime;
        int newDistance = 100 * distance / accentSlope;
        int newPlusTime = starTime - newDistance;
        if (newPlusTime < 0) {
            newPlusTime = 0;
        }
        String oldSegment = plus.segment().getAttribute("p");
        boolean success = plus.setTargetTime(newPlusTime);
        if (success) {
            this.logger.debug("Accent slope: moved \"plus\" target from [" + oldSegment + "] at " + plusTime + " ms to [" + plus.segment().getAttribute("p") + "] at " + plus.getTargetTime() + " ms.");
        }
    }

    private int calculateTargetFrequency(Target target, int lastHFreq) {
        if (target == null || target.targetRule() == null || target.segment() == null) {
            throw new NullPointerException("Null target specification -- cannot calculate Frequency");
        }
        String f0descr = target.targetRule().getAttribute("f0");
        int f0 = 0;
        TopBaseConfiguration tbConf = null;
        if (f0descr.equals("last_H_freq") && lastHFreq == 0) {
            f0descr = "1100";
        }
        if (MaryUtils.isNumber(f0descr)) {
            ProsodicSettings settings;
            int f0promille = MaryUtils.getNumber(f0descr);
            Element phrase = (Element)MaryDomUtils.getAncestor((Node)target.segment(), "phrase");
            Element prosody = (Element)MaryDomUtils.getAncestor((Node)target.segment(), "prosody");
            Element topBaseRef = phrase;
            if (prosody != null && MaryDomUtils.isAncestor(phrase, prosody)) {
                topBaseRef = prosody;
            }
            if (prosody != null && target.targetRule().getParentNode().getNodeName().equals("accent") && target.type().equals("star") && (settings = this.prosodyMap.get(prosody)) != null) {
                int accentProminence = settings.accentProminence();
                int dist = f0promille - 500;
                int newDist = dist * accentProminence / 100;
                f0promille = 500 + newDist;
            }
            tbConf = this.topBaseConfMap.get(topBaseRef);
            assert (tbConf != null);
            int d = 0;
            try {
                d = Integer.parseInt(target.segment().getAttribute("d"));
            }
            catch (NumberFormatException e) {
                this.logger.warn("Unexpected duration value `" + target.segment().getAttribute("d") + "'");
            }
            int end = TobiContourGenerator.getSegmentEndInMillis(target.segment());
            if (end == -1) {
                this.logger.warn("Unexpected duration value `" + target.segment().getAttribute("end") + "'");
            }
            int timeMillis = end - d + d * target.timing() / 100;
            if (f0promille == 1000) {
                lastHFreq = f0 = tbConf.toplineFrequency(timeMillis);
            } else if (f0promille == 0) {
                f0 = tbConf.baselineFrequency(timeMillis);
            } else {
                int base = tbConf.baselineFrequency(timeMillis);
                int top = tbConf.toplineFrequency(timeMillis);
                int range = top - base;
                f0 = base + f0promille * range / 1000;
            }
        } else if (f0descr.equals("last_H_freq")) {
            f0 = lastHFreq;
        } else {
            this.logger.warn("Unknown f0 specification `" + f0descr + "' in file " + MaryProperties.getFilename(this.tobirulefilePropertyName));
        }
        if (f0 != 0) {
            target.setF0(f0);
            this.logger.debug("Target on segment [" + target.segment().getAttribute("p") + "] at " + target.getTargetTime() + " ms, " + target.f0() + " Hz (" + f0descr + ")");
        }
        return lastHFreq;
    }

    private void insertTargetIntoMaryXML(Target target) {
        if (target != null && target.segment() != null && target.timing() != -1 && target.f0() != 0) {
            String newF0 = "(" + target.timing() + "," + target.f0() + ")";
            if (target.segment().hasAttribute("f0")) {
                String oldF0 = target.segment().getAttribute("f0");
                target.segment().setAttribute("f0", oldF0 + " " + newF0);
            } else {
                target.segment().setAttribute("f0", newF0);
            }
        }
    }

    private void adaptProsody(Element prosodyRule, Element syllable) {
        Element lastSyl;
        Element last;
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)syllable, "phrase");
        Element first = (Element)MaryDomUtils.getAncestor((Node)syllable, "t");
        if (MaryDomUtils.hasAncestor(first, "mtu")) {
            first = (Element)MaryDomUtils.getHighestLevelAncestor(first, "mtu");
        }
        if (MaryDomUtils.hasAncestor(last = (Element)MaryDomUtils.getAncestor((Node)(lastSyl = MaryDomUtils.getLastElementByTagName(phrase, "syllable")), "t"), "mtu")) {
            last = (Element)MaryDomUtils.getHighestLevelAncestor(last, "mtu");
        }
        Element newProsody = MaryDomUtils.encloseNodesWithNewElement(first, last, "prosody");
        newProsody.setAttribute("range", prosodyRule.getAttribute("range"));
        this.determineProsodicSettings(newProsody);
        this.determineProsodyTopBaseConf(newProsody);
        TreeWalker tw = ((DocumentTraversal)((Object)newProsody.getOwnerDocument())).createTreeWalker(newProsody, 1, new NameNodeFilter("prosody"), false);
        Element p = null;
        while ((p = (Element)tw.nextNode()) != null) {
            this.determineProsodyTopBaseConf(p);
        }
    }

    private Element getToken(Element segmentOrSyllable) {
        return (Element)MaryDomUtils.getAncestor((Node)segmentOrSyllable, "t");
    }

    private Element getSyllable(Element segment) {
        return (Element)MaryDomUtils.getAncestor((Node)segment, "syllable");
    }

    private static Element getPreviousSegment(Element segment) {
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, "phrase");
        return MaryDomUtils.getPreviousOfItsKindIn(segment, phrase);
    }

    private static Element getNextSegment(Element segment) {
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)segment, "phrase");
        return MaryDomUtils.getNextOfItsKindIn(segment, phrase);
    }

    private static Element getPreviousSyllable(Element syllable) {
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)syllable, "phrase");
        return MaryDomUtils.getPreviousOfItsKindIn(syllable, phrase);
    }

    private static Element getNextSyllable(Element syllable) {
        if (syllable == null) {
            return null;
        }
        Element phrase = (Element)MaryDomUtils.getAncestor((Node)syllable, "phrase");
        return MaryDomUtils.getNextOfItsKindIn(syllable, phrase);
    }

    private boolean hasAccent(Element token) {
        String accent = token.getAttribute("accent").toUpperCase();
        return this.tobiMap.containsKey(accent);
    }

    private boolean isLastBeforeBoundary(Element syllable, int minBreakindex) {
        Document doc = syllable.getOwnerDocument();
        Element sentence = (Element)MaryDomUtils.getAncestor((Node)syllable, "s");
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(sentence, 1, new NameNodeFilter("syllable", "boundary"), false);
        tw.setCurrentNode(syllable);
        Element next = (Element)tw.nextNode();
        if (next == null) {
            return true;
        }
        return next.getNodeName().equals("boundary") && this.getBreakindex(next) >= minBreakindex;
    }

    private boolean isMajIPFinal(Element syllable) {
        return this.isLastBeforeBoundary(syllable, 4);
    }

    private boolean isMinipFinal(Element syllable) {
        return this.isLastBeforeBoundary(syllable, 3);
    }

    private boolean isWordFinal(Element syllable) {
        Element e = syllable;
        while (e != null) {
            if ((e = MaryDomUtils.getNextSiblingElement(e)) == null || !e.getNodeName().equals("syllable")) continue;
            return false;
        }
        return true;
    }

    private boolean isWordMedial(Element syllable) {
        return !this.isWordFinal(syllable) && !this.isWordInitial(syllable);
    }

    private boolean isWordInitial(Element syllable) {
        Element e = syllable;
        while (e != null) {
            if ((e = MaryDomUtils.getPreviousSiblingElement(e)) == null || !e.getNodeName().equals("syllable")) continue;
            return false;
        }
        return true;
    }

    private boolean isInOnset(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        assert (ph != null);
        if (ph.isSyllabic()) {
            return false;
        }
        Element e = MaryDomUtils.getNextSiblingElement(segment);
        while (e != null) {
            ph = this.allophoneSet.getAllophone(e.getAttribute("p"));
            assert (ph != null);
            if (ph.isSyllabic()) {
                return true;
            }
            e = MaryDomUtils.getNextSiblingElement(e);
        }
        return false;
    }

    private boolean isInNucleus(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        assert (ph != null);
        return ph.isSyllabic();
    }

    private boolean isInCoda(Element segment) {
        Allophone ph = this.allophoneSet.getAllophone(segment.getAttribute("p"));
        assert (ph != null);
        if (ph.isSyllabic()) {
            return false;
        }
        Element e = MaryDomUtils.getPreviousSiblingElement(segment);
        while (e != null) {
            ph = this.allophoneSet.getAllophone(e.getAttribute("p"));
            assert (ph != null);
            if (ph.isSyllabic()) {
                return true;
            }
            e = MaryDomUtils.getPreviousSiblingElement(e);
        }
        return false;
    }

    private int getBreakindex(Element boundary) {
        int breakindex = 0;
        try {
            breakindex = Integer.parseInt(boundary.getAttribute("breakindex"));
        }
        catch (NumberFormatException e) {
            this.logger.warn("Unexpected breakindex value `" + boundary.getAttribute("breakindex") + "'");
        }
        return breakindex;
    }

    private Element getStressedSyllable(Element token) {
        Element first;
        if (token == null || !token.getTagName().equals("t")) {
            return null;
        }
        Element syl = MaryDomUtils.getFirstElementByTagName(token, "syllable");
        while (syl != null && !syl.getAttribute("stress").equals("1")) {
            syl = MaryDomUtils.getNextSiblingElementByTagName(syl, "syllable");
        }
        if (syl != null) {
            return syl;
        }
        Element secondary = first = MaryDomUtils.getFirstElementByTagName(token, "syllable");
        while (secondary != null && !secondary.getAttribute("stress").equals("2")) {
            secondary = MaryDomUtils.getNextSiblingElementByTagName(secondary, "syllable");
        }
        if (secondary != null) {
            return secondary;
        }
        return first;
    }

    private Element getNucleus(Element syllable) {
        if (syllable == null || !syllable.getTagName().equals("syllable")) {
            return null;
        }
        Element seg = MaryDomUtils.getFirstElementByTagName(syllable, "ph");
        while (seg != null && !this.isInNucleus(seg)) {
            seg = MaryDomUtils.getNextSiblingElementByTagName(seg, "ph");
        }
        return seg;
    }

    private static int getSegmentEndInMillis(Element segment) {
        try {
            float endInSeconds = Float.valueOf(segment.getAttribute("end")).floatValue();
            int endInMillis = (int)(endInSeconds * 1000.0f);
            return endInMillis;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static class Target {
        Element targetRule;
        Element segment;
        int timing;
        int f0;
        Target myStar;

        Target() {
            this.targetRule = null;
            this.segment = null;
            this.timing = -1;
            this.f0 = 0;
            this.myStar = null;
        }

        Target(Element targetRule, Element segment, int timing, int f0) {
            this.targetRule = targetRule;
            this.segment = segment;
            this.timing = timing;
            this.f0 = f0;
            this.myStar = null;
        }

        Element targetRule() {
            return this.targetRule;
        }

        Element segment() {
            return this.segment;
        }

        int timing() {
            return this.timing;
        }

        int f0() {
            return this.f0;
        }

        Target myStar() {
            return this.myStar;
        }

        void setTargetRule(Element targetRule) {
            this.targetRule = targetRule;
        }

        void setSegment(Element segment) {
            this.segment = segment;
        }

        void setTiming(int timing) {
            this.timing = timing;
        }

        void setF0(int f0) {
            this.f0 = f0;
        }

        void setMyStar(Target star) {
            this.myStar = star;
        }

        String type() {
            if (this.targetRule != null) {
                return this.targetRule.getAttribute("type");
            }
            return "";
        }

        int getTargetTime() {
            if (this.segment == null || this.timing == -1) {
                return -1;
            }
            int end = TobiContourGenerator.getSegmentEndInMillis(this.segment);
            if (end == -1) {
                return -1;
            }
            int d = -1;
            try {
                d = Integer.parseInt(this.segment.getAttribute("d"));
            }
            catch (NumberFormatException e) {
                return -1;
            }
            return end - (100 - this.timing) * d / 100;
        }

        boolean setTargetTime(int targetTime) {
            if (targetTime < 0) {
                return false;
            }
            int currentTargetTime = this.getTargetTime();
            Element seg = this.segment;
            try {
                Element s;
                if (targetTime < currentTargetTime) {
                    while (seg != null && TobiContourGenerator.getSegmentEndInMillis(seg) - Integer.parseInt(seg.getAttribute("d")) > targetTime) {
                        s = TobiContourGenerator.getPreviousSegment(seg);
                        if (s != null && TobiContourGenerator.getSegmentEndInMillis(s) < targetTime) {
                            targetTime = TobiContourGenerator.getSegmentEndInMillis(seg) - Integer.parseInt(seg.getAttribute("d"));
                            break;
                        }
                        seg = s;
                    }
                } else {
                    while (seg != null && TobiContourGenerator.getSegmentEndInMillis(seg) < targetTime) {
                        s = TobiContourGenerator.getNextSegment(seg);
                        if (s != null && TobiContourGenerator.getSegmentEndInMillis(s) - Integer.parseInt(s.getAttribute("d")) > targetTime) {
                            targetTime = TobiContourGenerator.getSegmentEndInMillis(seg);
                            break;
                        }
                        seg = s;
                    }
                }
                if (seg != null) {
                    int newTiming = 100 - 100 * (TobiContourGenerator.getSegmentEndInMillis(seg) - targetTime) / Integer.parseInt(seg.getAttribute("d"));
                    this.segment = seg;
                    this.timing = newTiming;
                    assert (this.timing >= 0 && this.timing <= 100);
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
    }

    static class TopBaseConfiguration {
        int topStart;
        int topEnd;
        int baseStart;
        int baseEnd;
        int startTime;
        int endTime;
        double topSlope;
        double baseSlope;

        TopBaseConfiguration(int topStart, int topEnd, int baseStart, int baseEnd) {
            this(topStart, topEnd, baseStart, baseEnd, 0, 0);
        }

        TopBaseConfiguration(int topStart, int topEnd, int baseStart, int baseEnd, int startTime, int endTime) {
            this.topStart = topStart;
            this.topEnd = topEnd;
            this.baseStart = baseStart;
            this.baseEnd = baseEnd;
            this.startTime = startTime;
            this.endTime = endTime;
            if (startTime != endTime) {
                this.topSlope = ((double)topEnd - (double)topStart) / (double)(endTime - startTime);
                this.baseSlope = ((double)baseEnd - (double)baseStart) / (double)(endTime - startTime);
            } else {
                this.topSlope = 0.0;
                this.baseSlope = 0.0;
            }
        }

        int topStart() {
            return this.topStart;
        }

        int topEnd() {
            return this.topEnd;
        }

        int baseStart() {
            return this.baseStart;
        }

        int baseEnd() {
            return this.baseEnd;
        }

        int startTime() {
            return this.startTime;
        }

        int endTime() {
            return this.endTime;
        }

        void setTimes(int startTime, int endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
            if (startTime != endTime) {
                this.topSlope = ((double)this.topEnd - (double)this.topStart) / (double)(endTime - startTime);
                this.baseSlope = ((double)this.baseEnd - (double)this.baseStart) / (double)(endTime - startTime);
            } else {
                this.topSlope = 0.0;
                this.baseSlope = 0.0;
            }
        }

        int toplineFrequency(int time) {
            if (time < this.startTime || time > this.endTime) {
                throw new RuntimeException("Invalid time " + time + " (startTime " + this.startTime + ", endTime " + this.endTime + ")");
            }
            return this.topStart + (int)(this.topSlope * (double)(time - this.startTime));
        }

        int baselineFrequency(int time) {
            if (time < this.startTime || time > this.endTime) {
                throw new RuntimeException("Invalid time " + time + "(startTime " + this.startTime + ", endTime " + this.endTime + ")");
            }
            return this.baseStart + (int)(this.baseSlope * (double)(time - this.startTime));
        }
    }

    static class ProsodicSettings {
        int rate;
        int accentProminence;
        int accentSlope;
        int numberOfPauses;
        int pauseDuration;
        int vowelDuration;
        int plosiveDuration;
        int fricativeDuration;
        int nasalDuration;
        int liquidDuration;
        int glideDuration;
        int volume;

        ProsodicSettings() {
            this.rate = 100;
            this.accentProminence = 100;
            this.accentSlope = 100;
            this.numberOfPauses = 100;
            this.pauseDuration = 100;
            this.vowelDuration = 100;
            this.plosiveDuration = 100;
            this.fricativeDuration = 100;
            this.nasalDuration = 100;
            this.liquidDuration = 100;
            this.glideDuration = 100;
            this.volume = 50;
        }

        ProsodicSettings(int rate, int accentProminence, int accentSlope, int numberOfPauses, int pauseDuration, int vowelDuration, int plosiveDuration, int fricativeDuration, int nasalDuration, int liquidDuration, int glideDuration, int volume) {
            this.rate = rate;
            this.accentProminence = accentProminence;
            this.accentSlope = accentSlope;
            this.numberOfPauses = numberOfPauses;
            this.pauseDuration = pauseDuration;
            this.vowelDuration = vowelDuration;
            this.plosiveDuration = plosiveDuration;
            this.fricativeDuration = fricativeDuration;
            this.nasalDuration = nasalDuration;
            this.liquidDuration = liquidDuration;
            this.glideDuration = glideDuration;
            this.volume = volume;
        }

        int rate() {
            return this.rate;
        }

        int accentProminence() {
            return this.accentProminence;
        }

        int accentSlope() {
            return this.accentSlope;
        }

        int numberOfPauses() {
            return this.numberOfPauses;
        }

        int pauseDuration() {
            return this.pauseDuration;
        }

        int vowelDuration() {
            return this.vowelDuration;
        }

        int plosiveDuration() {
            return this.plosiveDuration;
        }

        int fricativeDuration() {
            return this.fricativeDuration;
        }

        int nasalDuration() {
            return this.nasalDuration;
        }

        int liquidDuration() {
            return this.liquidDuration;
        }

        int glideDuration() {
            return this.glideDuration;
        }

        int volume() {
            return this.volume;
        }

        void setRate(int value) {
            this.rate = value;
        }

        void setAccentProminence(int value) {
            this.accentProminence = value;
        }

        void setAccentSlope(int value) {
            this.accentSlope = value;
        }

        void setNumberOfPauses(int value) {
            this.numberOfPauses = value;
        }

        void setPauseDuration(int value) {
            this.pauseDuration = value;
        }

        void setVowelDuration(int value) {
            this.vowelDuration = value;
        }

        void setPlosiveDuration(int value) {
            this.plosiveDuration = value;
        }

        void setFricativeDuration(int value) {
            this.fricativeDuration = value;
        }

        void setNasalDuration(int value) {
            this.nasalDuration = value;
        }

        void setLiquidDuration(int value) {
            this.liquidDuration = value;
        }

        void setGlideDuration(int value) {
            this.glideDuration = value;
        }

        void setVolume(int value) {
            this.volume = value;
        }
    }
}

