/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.learner.rules;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.set.SplittedExampleSet;
import com.rapidminer.operator.learner.rules.Criterion;
import com.rapidminer.operator.learner.rules.NumericalSplitter;
import com.rapidminer.operator.learner.rules.Split;
import com.rapidminer.operator.learner.tree.AbstractSplitCondition;
import com.rapidminer.operator.learner.tree.GreaterSplitCondition;
import com.rapidminer.operator.learner.tree.LessEqualsSplitCondition;
import com.rapidminer.operator.learner.tree.NominalSplitCondition;
import com.rapidminer.operator.learner.tree.SplitCondition;

public class TermDetermination {
    private Criterion criterion;
    private NumericalSplitter splitter;
    private double minValue;

    public TermDetermination(Criterion criterion) {
        this(criterion, Double.NEGATIVE_INFINITY);
    }

    public TermDetermination(Criterion criterion, double minValue) {
        this.criterion = criterion;
        this.splitter = new NumericalSplitter(criterion);
        this.minValue = minValue;
    }

    public SplitCondition getBestTerm(ExampleSet exampleSet, String labelName) {
        AbstractSplitCondition bestCondition = null;
        double bestBenefit = Double.NEGATIVE_INFINITY;
        double bestTotalWeight = 0.0;
        for (Attribute attribute : exampleSet.getAttributes()) {
            double[] benefits;
            if (attribute.isNominal()) {
                SplittedExampleSet splitted = SplittedExampleSet.splitByAttribute(exampleSet, attribute);
                int i = 0;
                while (i < splitted.getNumberOfSubsets()) {
                    SplittedExampleSet posSet = (SplittedExampleSet)splitted.clone();
                    posSet.selectSingleSubset(i);
                    SplittedExampleSet negSet = (SplittedExampleSet)splitted.clone();
                    negSet.selectAllSubsetsBut(i);
                    double[] benefits2 = this.criterion.getBenefit(posSet, negSet, labelName);
                    if (benefits2[0] > this.minValue && benefits2[0] > 0.0 && benefits2[1] > 0.0 && (benefits2[0] > bestBenefit || benefits2[0] == bestBenefit && benefits2[1] > bestTotalWeight)) {
                        bestBenefit = benefits2[0];
                        bestTotalWeight = benefits2[1];
                        bestCondition = new NominalSplitCondition(attribute, posSet.iterator().next().getValueAsString(attribute));
                    }
                    ++i;
                }
                continue;
            }
            Split bestSplit = this.splitter.getBestSplit(exampleSet, attribute, labelName);
            double bestSplitValue = bestSplit.getSplitPoint();
            if (Double.isNaN(bestSplitValue) || !((benefits = bestSplit.getBenefit())[0] > this.minValue) || !(benefits[0] > 0.0) || !(benefits[1] > 0.0) || !(benefits[0] > bestBenefit) && (benefits[0] != bestBenefit || !(benefits[1] > bestTotalWeight))) continue;
            bestBenefit = benefits[0];
            bestTotalWeight = benefits[1];
            bestCondition = bestSplit.getSplitType() == 0 ? new LessEqualsSplitCondition(attribute, bestSplitValue) : new GreaterSplitCondition(attribute, bestSplitValue);
        }
        return bestCondition;
    }
}

