/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.preprocessing.filter;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.BinominalAttribute;
import com.rapidminer.example.table.ExampleTable;
import com.rapidminer.example.table.NominalMapping;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.preprocessing.AbstractDataProcessing;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeString;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNominalValue
extends AbstractDataProcessing {
    public static final String PARAMETER_ATTRIBUTE_NAME = "attribute_name";
    public static final String PARAMETER_NEW_VALUE = "new_value";

    public AddNominalValue(OperatorDescription description) {
        super(description);
    }

    @Override
    public ExampleSet apply(ExampleSet exampleSet) throws OperatorException {
        Attribute attribute = exampleSet.getAttributes().get(this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        if (attribute == null) {
            throw new UserError((Operator)this, 111, this.getParameterAsString(PARAMETER_ATTRIBUTE_NAME));
        }
        if (!attribute.isNominal()) {
            throw new UserError((Operator)this, 119, attribute.getName(), this.getName());
        }
        String newValue = this.getParameterAsString(PARAMETER_NEW_VALUE);
        if (attribute instanceof BinominalAttribute) {
            Attribute newAttribute = AttributeFactory.createAttribute(1);
            ExampleTable table = exampleSet.getExampleTable();
            table.addAttribute(newAttribute);
            exampleSet.getAttributes().addRegular(newAttribute);
            NominalMapping originalMapping = attribute.getMapping();
            NominalMapping newMapping = newAttribute.getMapping();
            int i = 0;
            while (i < originalMapping.size()) {
                newMapping.mapString(originalMapping.mapIndex(i));
                ++i;
            }
            newAttribute.getMapping().mapString(newValue);
            for (Example example : exampleSet) {
                example.setValue(newAttribute, example.getValue(attribute));
            }
            exampleSet.getAttributes().remove(attribute);
            newAttribute.setName(attribute.getName());
        } else {
            attribute.getMapping().mapString(newValue);
        }
        return exampleSet;
    }

    @Override
    public List<ParameterType> getParameterTypes() {
        List<ParameterType> types = super.getParameterTypes();
        types.add(new ParameterTypeString(PARAMETER_ATTRIBUTE_NAME, "The name of the nominal attribute to which values should be added.", false));
        types.add(new ParameterTypeString(PARAMETER_NEW_VALUE, "The value which should be added.", false));
        return types;
    }
}

